/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.multiparts;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.INeighborTileChange;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.DummyPipePart;
import com.rwtema.extrautils.tileentity.transfernodes.multiparts.MCMetaTilePart;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipeCosmetic;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.StdPipes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PipePart
extends MCMetaTilePart
implements ISidedHollowConnect,
IPipe,
IPipeCosmetic,
INeighborTileChange,
TSlottedPart {
    public static DummyPipePart[] dummyPipes = new DummyPipePart[6];
    public int blockMasks = -1;
    public byte[] flagmasks = new byte[]{1, 2, 4, 8, 16, 32};

    public PipePart(int meta) {
        super(meta);
    }

    public PipePart() {
    }

    public Iterable<ItemStack> getDrops() {
        return Arrays.asList(new ItemStack(this.getBlock(), 1, this.getBlock().func_149692_a(this.getMetadata())));
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack(this.getBlock(), 1, this.getBlock().func_149692_a(this.getMetadata()));
    }

    public int getMetadata() {
        return this.meta % 16;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        return Arrays.asList(new Cuboid6((double)(0.5f - this.baseSize()), (double)(0.5f - this.baseSize()), (double)(0.5f - this.baseSize()), (double)(0.5f + this.baseSize()), (double)(0.5f + this.baseSize()), (double)(0.5f + this.baseSize())));
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition part, ItemStack item) {
        if (this.getWorld().field_72995_K) {
            return true;
        }
        if (XUHelper.isWrench(item)) {
            int newmetadata = StdPipes.getNextPipeType((IBlockAccess)this.getWorld(), part.field_72311_b, part.field_72312_c, part.field_72309_d, this.meta);
            this.meta = (byte)newmetadata;
            this.sendDescUpdate();
            return true;
        }
        return false;
    }

    public final Cuboid6 getBounds() {
        Box bounds = ((BlockTransferPipe)this.getBlock()).getWorldModel((IBlockAccess)this.getWorld(), this.x(), this.y(), this.z()).boundingBox();
        return new Cuboid6((double)bounds.minX, (double)bounds.minY, (double)bounds.minZ, (double)bounds.maxX, (double)bounds.maxY, (double)bounds.maxZ);
    }

    public final HashSet<IndexedCuboid6> getSubParts() {
        HashSet<IndexedCuboid6> boxes = new HashSet<IndexedCuboid6>();
        for (Box bounds : ((BlockTransferPipe)this.getBlock()).getWorldModel((IBlockAccess)this.getWorld(), this.x(), this.y(), this.z())) {
            boxes.add(new IndexedCuboid6((Object)0, new Cuboid6((double)bounds.minX, (double)bounds.minY, (double)bounds.minZ, (double)bounds.maxX, (double)bounds.maxY, (double)bounds.maxZ)));
        }
        return boxes;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean drawHighlight(MovingObjectPosition hit, EntityPlayer player, float frame) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        float f1 = 0.002f;
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)frame;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)frame;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)frame;
        RenderGlobal.func_147590_a((AxisAlignedBB)this.getBounds().add(new Vector3((double)this.x(), (double)this.y(), (double)this.z())).toAABB().func_72314_b((double)f1, (double)f1, (double)f1).func_72325_c(-d0, -d1, -d2), (int)-1);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        return true;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        BoxModel model = ((BlockTransferPipe)this.getBlock()).getWorldModel((IBlockAccess)this.world(), this.x(), this.y(), this.z());
        for (Box box : model) {
            t2.add(new Cuboid6((double)box.minX, (double)box.minY, (double)box.minZ, (double)box.maxX, (double)box.maxY, (double)box.maxZ));
        }
        return t2;
    }

    public Block getBlock() {
        return this.meta < 16 ? ExtraUtils.transferPipe : ExtraUtils.transferPipe2;
    }

    public String getType() {
        return "extrautils:transfer_pipe";
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.meta).getOutputDirections(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.meta).transferItems(world, x, y, z, dir, buffer);
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && StdPipes.getPipeType(this.meta).canInput(world, x, y, z, dir);
    }

    @Override
    public boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && StdPipes.getPipeType(this.meta).canOutput((IBlockAccess)this.getWorld(), x, y, z, dir);
    }

    @Override
    public int limitTransfer(TileEntity dest, ForgeDirection side, INodeBuffer buffer) {
        return StdPipes.getPipeType(this.meta).limitTransfer(dest, side, buffer);
    }

    @Override
    public IInventory getFilterInventory(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return !this.isBlocked(dir) && StdPipes.getPipeType(this.meta).shouldConnectToTile(world, x, y, z, dir);
    }

    public void reloadBlockMasks() {
        this.blockMasks = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            PipePart.dummyPipes[dir.ordinal()].h = 0.5f - this.baseSize();
            if (this.tile().canAddPart((TMultiPart)dummyPipes[dir.ordinal()])) continue;
            this.blockMasks |= this.flagmasks[dir.ordinal()];
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.reloadBlockMasks();
    }

    public void onNeighborChanged() {
        this.reloadBlockMasks();
    }

    public boolean isBlocked(ForgeDirection dir) {
        if (this.blockMasks < 0) {
            this.reloadBlockMasks();
        }
        return (this.blockMasks & this.flagmasks[dir.ordinal()]) == this.flagmasks[dir.ordinal()];
    }

    @Override
    public IIcon baseTexture() {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).baseTexture();
    }

    @Override
    public IIcon socketTexture(ForgeDirection dir) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).socketTexture(dir);
    }

    @Override
    public IIcon pipeTexture(ForgeDirection dir, boolean blocked) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).pipeTexture(dir, blocked);
    }

    @Override
    public IIcon invPipeTexture(ForgeDirection dir) {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).invPipeTexture(dir);
    }

    @Override
    public String getPipeType() {
        return StdPipes.getPipeType(this.meta).getPipeType();
    }

    @Override
    public float baseSize() {
        return ((IPipeCosmetic)((Object)StdPipes.getPipeType(this.meta))).baseSize();
    }

    public boolean occlusionTest(TMultiPart npart) {
        return DummyPipePart.class.equals(npart.getClass()) || super.occlusionTest(npart);
    }

    public void onNeighborTileChanged(int arg0, boolean arg1) {
        this.reloadBlockMasks();
    }

    public boolean weakTileChanges() {
        return true;
    }

    public int getSlotMask() {
        return 64;
    }

    public int getHollowSize(int side) {
        return 6;
    }

    @Override
    public TileEntity getBlockTile() {
        return this.tile();
    }

    static {
        for (int i = 0; i < 6; ++i) {
            PipePart.dummyPipes[i] = new DummyPipePart(i, 0.375f);
        }
    }
}

