/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.nei;

import codechicken.microblock.MicroMaterialRegistry;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.rwtema.extrautils.multipart.FMPBase;
import com.rwtema.extrautils.multipart.microblock.RecipeMicroBlocks;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;

public class MicroBlocksHandler
extends ShapedRecipeHandler {
    public static String[] currentMaterials = null;
    public static ItemStack[] currentBlocks = null;
    public static Set<RecipeMicroBlocks> recipes = null;
    public String currentMaterial = "";
    public ItemStack currentBlock = null;
    public boolean scroll = true;

    public static Set<RecipeMicroBlocks> getCraftingRecipes() {
        if (recipes == null) {
            recipes = new HashSet<RecipeMicroBlocks>();
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof RecipeMicroBlocks)) continue;
                recipes.add((RecipeMicroBlocks)irecipe);
            }
        }
        return recipes;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "xu_microblocks_crafting", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("xu_microblocks_crafting")) {
            for (RecipeMicroBlocks irecipe : MicroBlocksHandler.getCraftingRecipes()) {
                MicroblockCachedRecipe recipe = new MicroblockCachedRecipe(irecipe);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
            this.scroll = true;
            this.currentMaterial = "";
            this.currentBlock = null;
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!result.func_77942_o() || "".equals(result.func_77978_p().func_74779_i("mat"))) {
            return;
        }
        MicroMaterialRegistry.IMicroMaterial m = MicroMaterialRegistry.getMaterial((String)result.func_77978_p().func_74779_i("mat"));
        if (m == null) {
            return;
        }
        this.scroll = false;
        this.currentMaterial = result.func_77978_p().func_74779_i("mat");
        this.currentBlock = m.getItem().func_77946_l();
        for (RecipeMicroBlocks irecipe : MicroBlocksHandler.getCraftingRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            MicroblockCachedRecipe recipe = new MicroblockCachedRecipe(irecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!ingredient.func_77942_o() || "".equals(ingredient.func_77978_p().func_74779_i("mat"))) {
            return;
        }
        MicroMaterialRegistry.IMicroMaterial m = MicroMaterialRegistry.getMaterial((String)ingredient.func_77978_p().func_74779_i("mat"));
        if (m == null) {
            return;
        }
        this.scroll = false;
        this.currentMaterial = ingredient.func_77978_p().func_74779_i("mat");
        this.currentBlock = m.getItem().func_77946_l();
        for (RecipeMicroBlocks irecipe : MicroBlocksHandler.getCraftingRecipes()) {
            MicroblockCachedRecipe recipe = new MicroblockCachedRecipe(irecipe);
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getRecipeName() {
        return "Extra Utilities: Microblocks";
    }

    public class MicroblockCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public MicroblockPositionedStack result;

        public MicroblockCachedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)MicroBlocksHandler.this);
            this.result = new MicroblockPositionedStack(out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public MicroblockCachedRecipe(RecipeMicroBlocks irecipe) {
            this(irecipe.recipeWidth, irecipe.recipeHeight, irecipe.getRecipeItems(), irecipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = items[y * width + x] instanceof ItemStack && ((ItemStack)items[y * width + x]).func_77973_b() == FMPBase.getMicroBlockItemId() ? new MicroblockPositionedStack((ItemStack)items[y * width + x], 25 + x * 18, 6 + y * 18) : new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public void permMaterial() {
            int i;
            if (!MicroBlocksHandler.this.scroll) {
                return;
            }
            if (currentMaterials == null) {
                currentMaterials = new String[MicroMaterialRegistry.getIdMap().length];
                for (i = 0; i < MicroMaterialRegistry.getIdMap().length; ++i) {
                    MicroBlocksHandler.currentMaterials[i] = (String)MicroMaterialRegistry.getIdMap()[i]._1();
                }
            }
            if (currentBlocks == null) {
                currentBlocks = new ItemStack[MicroMaterialRegistry.getIdMap().length];
                for (i = 0; i < MicroMaterialRegistry.getIdMap().length; ++i) {
                    MicroBlocksHandler.currentBlocks[i] = ((MicroMaterialRegistry.IMicroMaterial)MicroMaterialRegistry.getIdMap()[i]._2()).getItem().func_77946_l();
                }
            }
            MicroBlocksHandler.this.currentMaterial = currentMaterials[MicroBlocksHandler.this.cycleticks / 20 % currentMaterials.length];
            MicroBlocksHandler.this.currentBlock = currentBlocks[MicroBlocksHandler.this.cycleticks / 20 % currentMaterials.length];
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(MicroBlocksHandler.this.cycleticks / 20, this.ingredients);
        }

        public List<PositionedStack> getCycledIngredients(int cycle, List<PositionedStack> ingredients) {
            return super.getCycledIngredients(cycle, ingredients);
        }

        public void randomRenderPermutation(PositionedStack stack, long cycle) {
            stack.setPermutationToRender(0);
        }

        public PositionedStack getResult() {
            this.result.setPermutationToRender(0);
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }

        public class MicroblockPositionedStack
        extends PositionedStack {
            boolean materialTag;

            public MicroblockPositionedStack(ItemStack object, int x, int y) {
                super((Object)object, x, y, false);
                this.materialTag = false;
                this.item = this.items[0].func_77946_l();
                this.materialTag = this.item.func_77973_b() != FMPBase.getMicroBlockItemId() || this.item.func_77960_j() != 0;
            }

            public void setItem(ItemStack item) {
                if (item != null) {
                    this.item = item.func_77946_l();
                    this.items[0] = item.func_77946_l();
                } else {
                    this.item = null;
                }
            }

            public void setPermutationToRender(int index) {
                if (this.item == null) {
                    return;
                }
                MicroblockCachedRecipe.this.permMaterial();
                if (this.materialTag) {
                    this.addMaterial();
                } else {
                    this.items[0] = MicroBlocksHandler.this.currentBlock.func_77946_l();
                }
                super.setPermutationToRender(0);
            }

            public void addMaterial() {
                NBTTagCompound tag = this.items[0].func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74778_a("mat", MicroBlocksHandler.this.currentMaterial);
                this.items[0].func_77982_d(tag);
            }
        }
    }
}

