/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.crafting;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.item.ItemUnstableIngot;
import com.rwtema.extrautils.modintegration.EE3Integration;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeUnstableCrafting
extends ShapedOreRecipe
implements IRecipe {
    public static final NBTTagCompound nbt = new NBTTagCompound();
    private ItemStack stableOutput;
    ShapedOreRecipe checker;

    public RecipeUnstableCrafting(ItemStack result, Object ... recipe) {
        super(result, recipe);
        this.checker = new ShapedOreRecipe(result, recipe);
        Object[] input = super.getInput();
        ArrayList<Object> ee3input = new ArrayList<Object>();
        for (Object anInput : input) {
            boolean flag = true;
            if (anInput instanceof ArrayList) {
                ArrayList itemStacks = (ArrayList)anInput;
                for (ItemStack itemStack : itemStacks) {
                    if (itemStack.func_77973_b() != ExtraUtils.unstableIngot || itemStack.func_77960_j() != 2) continue;
                    itemStack.func_77982_d(nbt);
                    ee3input.add(Items.field_151045_i);
                    ee3input.add(Items.field_151042_j);
                    flag = false;
                    break;
                }
            }
            if (!flag) continue;
            ee3input.add(anInput);
        }
        EE3Integration.addRecipe(this.func_77571_b().func_77946_l(), ee3input.toArray());
    }

    public RecipeUnstableCrafting setStableItem(Item stack) {
        if (stack != null) {
            this.stableOutput = new ItemStack(stack);
        }
        return this;
    }

    public RecipeUnstableCrafting setStable(ItemStack stack) {
        this.stableOutput = stack;
        return this;
    }

    public RecipeUnstableCrafting addStableEnchant(Enchantment enchantment, int level) {
        if (this.stableOutput == null) {
            this.stableOutput = this.func_77571_b().func_77946_l();
        }
        this.stableOutput.func_77966_a(enchantment, level);
        return this;
    }

    public boolean func_77569_a(InventoryCrafting par1InventoryCrafting, World par2World) {
        return par2World != null && this.checker.func_77569_a(par1InventoryCrafting, par2World) && !this.hasExpired(par1InventoryCrafting, par2World);
    }

    public boolean hasExpired(InventoryCrafting par1InventoryCrafting, World par2World) {
        for (int i = 0; i < par1InventoryCrafting.func_70302_i_(); ++i) {
            ItemStack item = par1InventoryCrafting.func_70301_a(i);
            if (item == null || item.func_77973_b() != ExtraUtils.unstableIngot || item.func_77960_j() != 0 || !item.func_77942_o() || item.func_77978_p().func_74764_b("creative") || item.func_77978_p().func_74764_b("stable")) continue;
            if (!item.func_77978_p().func_74764_b("dimension") && !item.func_77978_p().func_74764_b("time") && item.func_77978_p().func_74764_b("crafting")) {
                return true;
            }
            long t = (200L - (par2World.func_82737_E() - item.func_77978_p().func_74763_f("time"))) / 20L;
            if (par2World.field_73011_w.field_76574_g == item.func_77978_p().func_74762_e("dimension") && t >= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean hasStable(InventoryCrafting par1InventoryCrafting) {
        for (int i = 0; i < par1InventoryCrafting.func_70302_i_(); ++i) {
            ItemStack item = par1InventoryCrafting.func_70301_a(i);
            if (item == null || item.func_77973_b() != ExtraUtils.unstableIngot || item.func_77960_j() != 0 || !item.func_77942_o()) continue;
            if (!ItemUnstableIngot.isStable(item)) {
                return false;
            }
            if (!ItemUnstableIngot.isSuperStable(item)) {
                return false;
            }
            if (!item.func_77978_p().func_74764_b("time")) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting par1InventoryCrafting) {
        if (this.stableOutput != null && this.hasStable(par1InventoryCrafting)) {
            return this.stableOutput.func_77946_l();
        }
        return super.func_77572_b(par1InventoryCrafting);
    }

    public static RecipeUnstableCrafting addRecipe(ItemStack itemStack, Object ... objects) {
        return new RecipeUnstableCrafting(itemStack, objects);
    }

    static {
        nbt.func_74757_a("isNEI", true);
    }
}

