/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.command;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public class Texture {
    private int id;
    public final int w;
    public final int h;
    private final IntBuffer pixelBuf;

    public Texture(int w, int h, int fillColour, int minFilter, int maxFilter, int textureWrap) {
        this.id = GL11.glGenTextures();
        this.w = w;
        this.h = h;
        this.pixelBuf = Texture.allocateDirectIntBuffer(w * h);
        this.fillRect(0, 0, w, h, fillColour);
        this.pixelBuf.position(0);
        this.bind();
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)w, (int)h, (int)0, (int)32993, (int)5121, (IntBuffer)this.pixelBuf);
        this.setTexParameters(minFilter, maxFilter, textureWrap);
    }

    public static IntBuffer allocateDirectIntBuffer(int size) {
        return ByteBuffer.allocateDirect(size * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public Texture(int w, int h, int fillColour) {
        this(w, h, fillColour, 9729, 9728, 33071);
    }

    public static int getTextureWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public static int getTextureHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public Texture(int id) {
        this.id = id;
        this.bind();
        this.w = Texture.getTextureWidth();
        this.h = Texture.getTextureHeight();
        this.pixelBuf = Texture.allocateDirectIntBuffer(this.w * this.h);
        this.getPixelsFromExistingTexture();
    }

    public synchronized void close() {
        if (this.id != 0) {
            try {
                GL11.glDeleteTextures((int)this.id);
            }
            catch (NullPointerException e) {
                this.log("MwTexture.close: null pointer exception (texture %d)", this.id);
            }
            this.id = 0;
        }
    }

    public synchronized void fillRect(int x, int y, int w, int h, int colour) {
        int offset = y * this.w + x;
        for (int j = 0; j < h; ++j) {
            this.pixelBuf.position(offset + j * this.w);
            for (int i = 0; i < w; ++i) {
                this.pixelBuf.put(colour);
            }
        }
    }

    public synchronized void getRGB(int x, int y, int w, int h, int[] pixels, int offset, int scanSize) {
        int bufOffset = y * this.w + x;
        for (int i = 0; i < h; ++i) {
            this.pixelBuf.position(bufOffset + i * this.w);
            this.pixelBuf.get(pixels, offset + i * scanSize, w);
        }
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.id);
    }

    public void setTexParameters(int minFilter, int maxFilter, int textureWrap) {
        this.bind();
        GL11.glTexParameteri((int)3553, (int)10242, (int)textureWrap);
        GL11.glTexParameteri((int)3553, (int)10243, (int)textureWrap);
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)maxFilter);
    }

    private synchronized void getPixelsFromExistingTexture() {
        try {
            this.bind();
            this.pixelBuf.clear();
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)5121, (IntBuffer)this.pixelBuf);
            this.pixelBuf.limit(this.w * this.h);
        }
        catch (NullPointerException e) {
            this.log("MwTexture.getPixels: null pointer exception (texture %d)", this.id);
        }
    }

    private void log(String s, int id) {
    }
}

