/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import net.machinemuse.numina.recipe.SimpleItemMaker;
import net.machinemuse.numina.recipe.SimpleItemMatcher;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class JSONRecipe
implements IRecipe {
    public SimpleItemMatcher[][] ingredients;
    public SimpleItemMaker result;
    public Boolean mirror;
    public Boolean unshaped;
    static final int MAX_WIDTH = 3;
    static final int MAX_HEIGHT = 3;

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        int width = this.getWidth();
        int height = this.ingredients.length;
        for (int xoffset = 0; xoffset <= 3 - width; ++xoffset) {
            for (int yoffset = 0; yoffset <= 3 - height; ++yoffset) {
                if (this.matchSpot(inv, xoffset, yoffset, width, height, false)) {
                    return true;
                }
                if (this.mirror == null || !this.mirror.booleanValue() || !this.matchSpot(inv, xoffset, yoffset, width, height, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchSpot(InventoryCrafting inv, int xoffset, int yoffset, int width, int height, boolean mirror) {
        boolean mismatch = false;
        for (int xinventory = 0; xinventory < 3; ++xinventory) {
            for (int yinventory = 0; yinventory < 3; ++yinventory) {
                SimpleItemMatcher matcher = !mirror ? this.getMatcher(-xoffset + xinventory, -yoffset + yinventory) : this.getMatcher(-xoffset + width - xinventory - 1, -yoffset + yinventory);
                if (matcher != null && !matcher.matchesItem(this.getInvStack(inv, xinventory, yinventory))) {
                    mismatch = true;
                }
                if (matcher != null || this.getInvStack(inv, xinventory, yinventory) == null) continue;
                mismatch = true;
            }
        }
        return !mismatch;
    }

    private ItemStack getInvStack(InventoryCrafting inv, int x, int y) {
        if (x < 0 || y < 0) {
            return null;
        }
        return inv.func_70463_b(x, y);
    }

    public SimpleItemMatcher getMatcher(int x, int y) {
        if (y >= 0 && y < this.ingredients.length && x >= 0 && x < this.ingredients[y].length) {
            return this.ingredients[y][x];
        }
        return null;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return this.result.makeItem(inventoryCrafting);
    }

    public int func_77570_a() {
        if (this.ingredients == null) {
            return 0;
        }
        int size = 0;
        for (SimpleItemMatcher[] row : this.ingredients) {
            if (row == null) continue;
            for (SimpleItemMatcher cell : row) {
                if (cell == null) continue;
                ++size;
            }
        }
        return size;
    }

    public ItemStack func_77571_b() {
        return this.result.getRecipeOutput();
    }

    public int getWidth() {
        int size = 0;
        for (SimpleItemMatcher[] row : this.ingredients) {
            if (row == null) continue;
            size = Math.max(row.length, size);
        }
        return size;
    }
}

