/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.item;

import net.machinemuse.numina.item.MuseItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.IItemRenderer;

public class ItemRenderDelegator
implements IItemRenderer {
    public MuseItemRenderer renderer;

    public ItemRenderDelegator(MuseItemRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                RenderBlocks renderEntity = (RenderBlocks)data[0];
                EntityItem entityEntity = (EntityItem)data[1];
                this.renderer.renderEntity(item, renderEntity, entityEntity);
                break;
            }
            case INVENTORY: {
                RenderBlocks renderInventory = (RenderBlocks)data[0];
                this.renderer.renderInventory(item, renderInventory);
                break;
            }
            case EQUIPPED: {
                RenderBlocks renderEquipped = (RenderBlocks)data[0];
                EntityLivingBase entityEquipped = (EntityLivingBase)data[1];
                this.renderer.renderEquipped(item, renderEquipped, entityEquipped);
                break;
            }
            case FIRST_PERSON_MAP: {
                EntityPlayer playerFirstPerson = (EntityPlayer)data[0];
                TextureManager engineFirstPerson = (TextureManager)data[1];
                MapData mapDataFirstPerson = (MapData)data[2];
                this.renderer.renderFirstPersonMap(item, playerFirstPerson, engineFirstPerson, mapDataFirstPerson);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                RenderBlocks renderEquFP = (RenderBlocks)data[0];
                EntityLivingBase entityEquFP = (EntityLivingBase)data[1];
                this.renderer.renderFirstPerson(item, renderEquFP, entityEquFP);
                break;
            }
        }
    }
}

