/*
 * Decompiled with CFR 0.152.
 */
package ckathode.weaponmod.item;

import ckathode.weaponmod.PlayerWeaponData;
import ckathode.weaponmod.WarhammerExplosion;
import ckathode.weaponmod.item.MeleeComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class MeleeCompWarhammer
extends MeleeComponent {
    public static final int CHARGE_DELAY = 400;

    public MeleeCompWarhammer(Item.ToolMaterial toolmaterial) {
        super(MeleeComponent.MeleeSpecs.WARHAMMER, toolmaterial);
    }

    @Override
    public float getBlockDamage(ItemStack itemstack, Block block) {
        float f = super.getBlockDamage(itemstack, block);
        float f1 = this.weaponMaterial.func_78000_c() + 2.0f;
        return f * f1;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityplayer, int i) {
        int j = this.getMaxItemUseDuration(itemstack) - i;
        float f = (float)j / 20.0f;
        if ((f = (f * f + f * 2.0f) / 4.0f) > 1.0f) {
            this.superSmash(itemstack, world, entityplayer);
        }
    }

    protected void superSmash(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        entityplayer.func_71038_i();
        float f = this.getEntityDamage() / 2.0f;
        WarhammerExplosion expl = new WarhammerExplosion(world, (Entity)entityplayer, entityplayer.field_70165_t, entityplayer.field_70163_u - (double)entityplayer.func_70047_e(), entityplayer.field_70161_v, f);
        expl.doEntityExplosion(DamageSource.func_76365_a((EntityPlayer)entityplayer));
        expl.doParticleExplosion(true, false);
        itemstack.func_77972_a(16, (EntityLivingBase)entityplayer);
        entityplayer.func_71020_j(6.0f);
        this.setSmashed(entityplayer);
    }

    public void setSmashed(EntityPlayer entityplayer) {
        PlayerWeaponData.setLastWarhammerSmashTicks(entityplayer, entityplayer.field_70173_aa);
    }

    public boolean isCharged(EntityPlayer entityplayer) {
        return entityplayer.field_70173_aa > PlayerWeaponData.getLastWarhammerSmashTicks(entityplayer) + 400;
    }

    @Override
    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.bow;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 72000;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (itemstack.field_77994_a <= 0) {
            return itemstack;
        }
        if (this.isCharged(entityplayer)) {
            int i = this.getMaxItemUseDuration(itemstack);
            entityplayer.func_71008_a(itemstack, i);
        }
        return itemstack;
    }
}

