/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.lib.util.position.ChunkCoord;
import cofh.thermaldynamics.core.WorldGridList;
import cofh.thermaldynamics.duct.light.PacketLight;
import cofh.thermaldynamics.duct.light.TileLightDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import com.google.common.collect.Iterables;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class LightGrid
extends MultiBlockGrid {
    public HashSet<ChunkCoord> chunks;
    public boolean upToDate = false;
    boolean lit = false;

    public LightGrid(WorldGridList worldGridList) {
        super(worldGridList);
    }

    public LightGrid(World world) {
        super(world);
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof TileLightDuct;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.upToDate = false;
        this.chunks = null;
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.upToDate = false;
    }

    @Override
    public void tickGrid() {
        boolean bl;
        super.tickGrid();
        if (this.upToDate && this.worldGrid.worldObj.func_82737_E() % 160L != 0L) {
            if (this.nextRedstoneLevel != -128) {
                this.upToDate = false;
            }
            return;
        }
        boolean bl2 = this.upToDate = this.nextRedstoneLevel == -128;
        if (this.nextRedstoneLevel != -128) {
            bl = this.nextRedstoneLevel > 0;
        } else {
            boolean bl3 = bl = this.redstoneLevel > 0;
        }
        if (!bl) {
            for (Object t : Iterables.concat(this.nodeSet, this.idleSet)) {
                TileLightDuct tileLightDuct = (TileLightDuct)t;
                if (!tileLightDuct.lit) continue;
                bl = true;
                break;
            }
        }
        if (this.lit != bl) {
            this.setLight(bl);
        }
    }

    public void setLight(boolean bl) {
        this.lit = bl;
        if (this.chunks == null) {
            this.buildMap();
        }
        PacketLight packetLight = new PacketLight(bl, this);
        int n = this.worldGrid.worldObj.field_73011_w.field_76574_g;
        block0: for (Object object : FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b) {
            if (n != object.field_71093_bK) continue;
            for (ChunkCoord chunkCoord : this.chunks) {
                double d = (double)chunkCoord.chunkX - object.field_70165_t;
                double d2 = (double)chunkCoord.chunkZ - object.field_70161_v;
                if (!(d * d + d2 * d2 < 36864.0)) continue;
                PacketHandler.sendTo((PacketBase)packetLight, (EntityPlayerMP)object);
                continue block0;
            }
        }
        for (Object object : Iterables.concat(this.nodeSet, this.idleSet)) {
            ((TileLightDuct)object).checkLight();
        }
    }

    public void buildMap() {
        this.chunks = new HashSet();
        for (IMultiBlock iMultiBlock : Iterables.concat(this.nodeSet, this.idleSet)) {
            this.buildMapEntry(iMultiBlock);
        }
    }

    private void buildMapEntry(IMultiBlock iMultiBlock) {
        this.chunks.add(new ChunkCoord(iMultiBlock.x() + 8, iMultiBlock.z() + 8));
    }
}

