/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.CoFHCore;
import cofh.lib.util.position.BlockPosition;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.entity.TileTransportDuct;
import cofh.thermaldynamics.multiblock.Route;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class EntityTransport
extends Entity {
    public static final int DATAWATCHER_DIRECTIONS = 16;
    public static final int DATAWATCHER_PROGRESS = 17;
    public static final int DATAWATCHER_POSX = 18;
    public static final int DATAWATCHER_POSY = 19;
    public static final int DATAWATCHER_POSZ = 20;
    public static final int DATAWATCHER_STEP = 21;
    public static final int PIPE_LENGTH = 2;
    public static final int PIPE_LENGTH2 = 1;
    public byte progress;
    public byte direction = (byte)7;
    public byte oldDirection;
    public byte step = 0;
    public boolean reRoute = false;
    Route myPath;
    BlockPosition pos;

    public boolean func_85032_ar() {
        return true;
    }

    public double func_70033_W() {
        return super.func_70033_W();
    }

    public double func_70042_X() {
        Entity entity = this.field_70153_n;
        if (entity == null) {
            return super.func_70042_X();
        }
        if (entity == CoFHCore.proxy.getClientPlayer()) {
            return -entity.func_70033_W();
        }
        double d = entity.field_70121_D.field_72337_e - entity.field_70121_D.field_72338_b;
        return -entity.func_70033_W() - d / 2.0;
    }

    public EntityTransport(World world) {
        super(world);
        this.field_70131_O = 0.1f;
        this.field_70130_N = 0.1f;
        this.field_70145_X = true;
        this.field_70178_ae = true;
    }

    public EntityTransport(TileTransportDuct tileTransportDuct, Route route, byte by, byte by2) {
        this(tileTransportDuct.world());
        this.step = by2;
        this.pos = new BlockPosition((TileEntity)tileTransportDuct);
        this.myPath = route;
        this.progress = 0;
        this.direction = route.getNextDirection();
        this.oldDirection = by;
        this.setPosition(0.0);
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public void start(EntityLivingBase entityLivingBase) {
        this.field_70170_p.func_72838_d((Entity)this);
        entityLivingBase.func_70078_a((Entity)this);
    }

    public boolean func_82150_aj() {
        return true;
    }

    public boolean func_98034_c(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && (this.field_70153_n == null || this.field_70153_n.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_75684_a()) {
            this.field_70180_af.func_111144_e();
            this.loadWatcherData();
        }
        if (this.direction == 7 || this.pos == null) {
            return;
        }
        TileEntity tileEntity = this.field_70170_p.func_147438_o(this.pos.x, this.pos.y, this.pos.z);
        if (tileEntity == null || !(tileEntity instanceof TileTransportDuct)) {
            if (this.field_70170_p.field_72995_K) {
                this.pos = null;
            } else {
                this.dropPassenger();
            }
            return;
        }
        TileTransportDuct tileTransportDuct = (TileTransportDuct)tileEntity;
        if (!this.field_70170_p.field_72995_K) {
            this.progress = (byte)(this.progress + this.step);
            if (this.myPath == null) {
                this.bouncePassenger(tileTransportDuct);
            } else if (this.progress >= 2) {
                this.progress = (byte)(this.progress % 2);
                this.advanceTile(tileTransportDuct);
            } else if (this.progress >= 1 && this.progress - this.step < 1 && (this.reRoute || tileTransportDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.NONE)) {
                this.bouncePassenger(tileTransportDuct);
            }
            this.updateWatcherData();
        } else {
            this.progress = (byte)(this.progress + this.step);
            if (this.progress >= 2) {
                BlockPosition blockPosition = this.pos.copy().step((int)this.direction);
                TileEntity tileEntity2 = this.field_70170_p.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
                if (!(tileEntity2 instanceof TileTransportDuct)) {
                    this.pos = null;
                    return;
                }
                TileTDBase.NeighborTypes[] neighborTypesArray = ((TileTransportDuct)tileEntity2).neighborTypes;
                if (neighborTypesArray[this.direction ^ 1] != TileTDBase.NeighborTypes.MULTIBLOCK) {
                    this.pos = null;
                    return;
                }
                this.pos = blockPosition;
                this.oldDirection = this.direction;
                this.progress = (byte)(this.progress % 2);
            }
        }
        this.setPosition(0.0);
        if (this.field_70153_n != null && !this.field_70153_n.field_70128_L) {
            this.func_70043_V();
        }
    }

    public void func_70030_z() {
    }

    public void setPosition(double d) {
        if (this.pos == null) {
            return;
        }
        Vector3 vector3 = this.getPos(d - 1.0);
        this.field_70142_S = this.field_70169_q = vector3.x;
        this.field_70137_T = this.field_70167_r = vector3.y;
        this.field_70136_U = this.field_70166_s = vector3.z;
        Vector3 vector32 = this.getPos(d);
        this.func_70107_b(vector32.x, vector32.y, vector32.z);
        this.field_70159_w = vector32.x - vector3.x;
        this.field_70181_x = vector32.y - vector3.y;
        this.field_70179_y = vector32.z - vector3.z;
    }

    private void dropPassenger() {
        if (!this.field_70170_p.field_72995_K) {
            this.moveToSafePosition();
            this.field_70153_n.func_70078_a(null);
            this.func_70106_y();
        }
    }

    public void moveToSafePosition() {
        if (this.direction >= 0 && this.direction < 6) {
            this.func_70107_b((double)(this.pos.x + Facing.field_71586_b[this.direction]) + 0.5, this.pos.y + Facing.field_71587_c[this.direction], (double)(this.pos.z + Facing.field_71585_d[this.direction]) + 0.5);
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void advanceTile(TileTransportDuct tileTransportDuct) {
        if (tileTransportDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.MULTIBLOCK && tileTransportDuct.connectionTypes[this.direction] == TileTDBase.ConnectionTypes.NORMAL) {
            TileTransportDuct tileTransportDuct2 = (TileTransportDuct)tileTransportDuct.getConnectedSide(this.direction);
            if (tileTransportDuct2 != null && tileTransportDuct2.neighborTypes[this.direction ^ 1] == TileTDBase.NeighborTypes.MULTIBLOCK) {
                this.pos = new BlockPosition((TileEntity)tileTransportDuct2);
                if (this.myPath.hasNextDirection()) {
                    this.oldDirection = this.direction;
                    this.direction = this.myPath.getNextDirection();
                } else {
                    this.reRoute = true;
                }
            }
        } else if (tileTransportDuct.neighborTypes[this.direction] == TileTDBase.NeighborTypes.OUTPUT && tileTransportDuct.connectionTypes[this.direction].allowTransfer) {
            this.dropPassenger();
        } else {
            this.bouncePassenger(tileTransportDuct);
        }
    }

    public void bouncePassenger(TileTransportDuct tileTransportDuct) {
        this.myPath = tileTransportDuct.getRoute(this, this.direction, this.step);
        if (this.myPath == null) {
            this.dropPassenger();
        } else {
            this.oldDirection = this.direction;
            this.direction = this.myPath.getNextDirection();
            this.reRoute = false;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)1);
    }

    public void updateWatcherData() {
        byte by = (byte)(this.direction | this.oldDirection << 3);
        this.field_70180_af.func_75692_b(16, (Object)by);
        this.field_70180_af.func_75692_b(17, (Object)this.progress);
        this.field_70180_af.func_75692_b(18, (Object)this.pos.x);
        this.field_70180_af.func_75692_b(19, (Object)this.pos.y);
        this.field_70180_af.func_75692_b(20, (Object)this.pos.z);
        this.field_70180_af.func_75692_b(21, (Object)this.step);
    }

    public void loadWatcherData() {
        byte by = this.field_70180_af.func_75683_a(16);
        this.direction = (byte)(by & 7);
        this.oldDirection = (byte)(by >> 3);
        this.progress = this.field_70180_af.func_75683_a(17);
        this.pos = new BlockPosition(this.field_70180_af.func_75679_c(18), this.field_70180_af.func_75679_c(19), this.field_70180_af.func_75679_c(20));
        this.step = this.field_70180_af.func_75683_a(21);
    }

    protected void func_70037_a(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_150297_b("route", 7)) {
            this.myPath = new Route(nBTTagCompound.func_74770_j("route"));
        }
        this.pos = new BlockPosition(nBTTagCompound.func_74762_e("posx"), nBTTagCompound.func_74762_e("posy"), nBTTagCompound.func_74762_e("posz"));
        this.progress = nBTTagCompound.func_74771_c("progress");
        this.direction = nBTTagCompound.func_74771_c("direction");
        this.oldDirection = nBTTagCompound.func_74771_c("oldDirection");
        this.step = nBTTagCompound.func_74771_c("step");
        this.reRoute = nBTTagCompound.func_74767_n("reRoute");
    }

    protected void func_70014_b(NBTTagCompound nBTTagCompound) {
        if (this.myPath != null) {
            nBTTagCompound.func_74773_a("route", this.myPath.toByteArray());
        }
        nBTTagCompound.func_74768_a("posx", this.pos.x);
        nBTTagCompound.func_74768_a("posy", this.pos.y);
        nBTTagCompound.func_74768_a("posz", this.pos.z);
        nBTTagCompound.func_74774_a("progress", this.progress);
        nBTTagCompound.func_74774_a("direction", this.direction);
        nBTTagCompound.func_74774_a("oldDirection", this.oldDirection);
        nBTTagCompound.func_74774_a("step", this.step);
        nBTTagCompound.func_74757_a("reRoute", this.reRoute);
    }

    public Vector3 getPos(double d) {
        return this.getPos(this.progress, d);
    }

    public Vector3 getPos(byte by, double d) {
        double d2 = ((double)by + (double)this.step * d) / 2.0 - 0.5;
        byte by2 = d2 < 0.0 ? this.oldDirection : this.direction;
        Vector3 vector3 = Vector3.center.copy();
        vector3.add(d2 * (double)Facing.field_71586_b[by2], d2 * (double)Facing.field_71587_c[by2], d2 * (double)Facing.field_71585_d[by2]);
        vector3.add((double)this.pos.x, (double)this.pos.y, (double)this.pos.z);
        return vector3;
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70058_J() {
        return false;
    }

    public void func_70091_d(double d, double d2, double d3) {
        this.setPosition(0.0);
    }

    public void func_70024_g(double d, double d2, double d3) {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }
}

