/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy;

import cofh.thermaldynamics.duct.energy.EnergyGrid;
import cofh.thermaldynamics.duct.energy.TileEnergyDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.world.World;

public class EnergyGridSuper
extends EnergyGrid {
    int nodeTracker;
    boolean isSendingEnergy;
    TileEnergyDuct[] nodeList = null;

    public EnergyGridSuper(World world, int n) {
        super(world, n);
        this.myStorage.setMaxExtract(this.myStorage.getMaxEnergyStored());
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        int n = 0;
        if (this.nodeList == null) {
            this.nodeList = new TileEnergyDuct[this.nodeSet.size()];
            for (IMultiBlock iMultiBlock : this.nodeSet) {
                this.nodeList[n] = (TileEnergyDuct)iMultiBlock;
                ++n;
            }
        }
    }

    public int sendEnergy(int n, boolean bl) {
        int n2;
        if (this.isSendingEnergy) {
            return 0;
        }
        int n3 = this.nodeTracker;
        TileEnergyDuct[] tileEnergyDuctArray = this.nodeList;
        int n4 = n;
        if (tileEnergyDuctArray == null || tileEnergyDuctArray.length == 0) {
            return 0;
        }
        this.isSendingEnergy = true;
        for (n2 = this.nodeTracker; n2 < tileEnergyDuctArray.length && n > 0; ++n2) {
            if ((n -= tileEnergyDuctArray[n2].transmitEnergy(n, bl)) != 0) continue;
            this.nodeTracker = n2 + 1;
        }
        for (n2 = 0; n2 < tileEnergyDuctArray.length && n2 < this.nodeTracker && n > 0; ++n2) {
            if ((n -= tileEnergyDuctArray[n2].transmitEnergy(n, bl)) != 0) continue;
            this.nodeTracker = n2 + 1;
        }
        if (n > 0) {
            ++this.nodeTracker;
        }
        if (this.nodeTracker >= tileEnergyDuctArray.length) {
            this.nodeTracker = 0;
        }
        if (bl) {
            this.nodeTracker = n3;
        }
        this.isSendingEnergy = false;
        return n4 - n;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.nodeList = null;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return multiBlockGrid instanceof EnergyGridSuper;
    }

    @Override
    public void destroy() {
        this.nodeList = null;
        super.destroy();
    }
}

