/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.cover;

import cofh.core.network.PacketCoFHBase;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.attachments.cover.CoverHelper;
import cofh.thermaldynamics.duct.attachments.cover.CoverRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class Cover
extends Attachment {
    private static Cuboid6 bound = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static Cuboid6[] bounds = new Cuboid6[]{bound, bound.copy().apply(Rotation.sideRotations[1].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[2].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[3].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[4].at(Vector3.center)), bound.copy().apply(Rotation.sideRotations[5].at(Vector3.center))};
    public Block block;
    public int meta;

    public Cover(TileTDBase tileTDBase, byte by, Block block, int n) {
        super(tileTDBase, by);
        this.block = block;
        this.meta = n;
    }

    public Cover(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
    }

    @Override
    public String getName() {
        return "item.thermalfoundation.cover.name";
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public Cuboid6 getCuboid() {
        return bounds[this.side].copy();
    }

    @Override
    public boolean onWrenched() {
        this.tile.removeFacade(this);
        for (ItemStack itemStack : this.getDrops()) {
            this.dropItemStack(itemStack);
        }
        return true;
    }

    @Override
    public TileTDBase.NeighborTypes getNeighborType() {
        return TileTDBase.NeighborTypes.NONE;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean render(int n, RenderBlocks renderBlocks) {
        if (!this.block.canRenderInPass(n)) {
            return false;
        }
        return CoverRenderer.renderCover(renderBlocks, ((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e, this.side, this.block, this.meta, this.getCuboid(), false, false);
    }

    @Override
    public boolean makesSideSolid() {
        return true;
    }

    @Override
    public ItemStack getPickBlock() {
        return CoverHelper.getCoverStack(this.block, this.meta);
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> linkedList = new LinkedList<ItemStack>();
        linkedList.add(this.getPickBlock());
        return linkedList;
    }

    @Override
    public boolean addToTile() {
        return this.tile.addFacade(this);
    }

    @Override
    public void addDescriptionToPacket(PacketCoFHBase packetCoFHBase) {
        packetCoFHBase.addShort(Block.func_149682_b((Block)this.block));
        packetCoFHBase.addByte(this.meta);
    }

    @Override
    public void getDescriptionFromPacket(PacketCoFHBase packetCoFHBase) {
        this.block = Block.func_149729_e((int)packetCoFHBase.getShort());
        this.meta = packetCoFHBase.getByte();
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        nBTTagCompound.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
        nBTTagCompound.func_74774_a("meta", (byte)this.meta);
    }

    @Override
    public boolean canAddToTile(TileTDBase tileTDBase) {
        return tileTDBase.covers[this.side] == null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        this.block = Block.func_149684_b((String)nBTTagCompound.func_74779_i("block"));
        if (this.block == null) {
            this.block = Blocks.field_150350_a;
        }
        this.meta = nBTTagCompound.func_74771_c("meta");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawSelectionExtra(EntityPlayer entityPlayer, MovingObjectPosition movingObjectPosition, float f) {
        super.drawSelectionExtra(entityPlayer, movingObjectPosition, f);
        RenderHelper.setBlockTextureSheet();
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)false);
        double d = entityPlayer.field_70142_S + (entityPlayer.field_70165_t - entityPlayer.field_70142_S) * (double)f;
        double d2 = entityPlayer.field_70137_T + (entityPlayer.field_70163_u - entityPlayer.field_70137_T) * (double)f;
        double d3 = entityPlayer.field_70136_U + (entityPlayer.field_70161_v - entityPlayer.field_70136_U) * (double)f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-d), (double)(-d2), (double)(-d3));
        GL11.glTranslated((double)((double)((TileEntity)this.tile).field_145851_c + 0.5), (double)((double)((TileEntity)this.tile).field_145848_d + 0.5), (double)((double)((TileEntity)this.tile).field_145849_e + 0.5));
        GL11.glScaled((double)1.0009765625, (double)1.0009765625, (double)1.0009765625);
        GL11.glTranslated((double)((double)(-((TileEntity)this.tile).field_145851_c) - 0.5), (double)((double)(-((TileEntity)this.tile).field_145848_d) - 0.5), (double)((double)(-((TileEntity)this.tile).field_145849_e) - 0.5));
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.5f);
        tessellator.func_78380_c(this.tile.func_145838_q().func_149677_c((IBlockAccess)this.tile.world(), ((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e));
        RenderBlocks renderBlocks = CoverRenderer.renderBlocks;
        renderBlocks.field_147845_a = entityPlayer.func_130014_f_();
        for (int i = 0; i < 2; ++i) {
            if (!this.block.canRenderInPass(i)) continue;
            CoverRenderer.renderCover(renderBlocks, ((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e, this.side, this.block, this.meta, this.getCuboid(), false, true);
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2903);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
    }
}

