/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.core.lib.render.RenderEntityBlock;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.render.PipeTransportRenderer;
import buildcraft.transport.utils.FluidRenderData;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class PipeTransportFluidsRenderer
extends PipeTransportRenderer<PipeTransportFluids> {
    private static final IntHashMap displayFluidLists = new IntHashMap();
    private static final TIntHashSet displayFluidListsSet = new TIntHashSet();
    private static final int LIQUID_STAGES = 40;
    private static final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private static final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};

    protected static void clear() {
        TIntIterator i = displayFluidListsSet.iterator();
        while (i.hasNext()) {
            GL11.glDeleteLists((int)i.next(), (int)1);
        }
        displayFluidListsSet.clear();
        displayFluidLists.func_76046_c();
    }

    @Override
    public boolean useServerTileIfPresent() {
        return false;
    }

    private DisplayFluidList getDisplayFluidLists(int liquidId, int skylight, int blocklight, int flags, World world) {
        int finalBlockLight = Math.max(flags & 0x1F, blocklight);
        int listId = (liquidId & 0x3FFFF) << 13 | (flags & 0xE0 | finalBlockLight) << 5 | skylight & 0x1F;
        if (displayFluidLists.func_76037_b(listId)) {
            return (DisplayFluidList)displayFluidLists.func_76041_a(listId);
        }
        Fluid fluid = FluidRegistry.getFluid((int)liquidId);
        if (fluid == null) {
            return null;
        }
        DisplayFluidList d = new DisplayFluidList();
        displayFluidLists.func_76038_a(listId, (Object)d);
        displayFluidListsSet.add(listId);
        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
        block.baseBlock = fluid.getBlock() != null ? fluid.getBlock() : Blocks.field_150355_j;
        block.texture = fluid.getStillIcon();
        block.brightness = skylight << 16 | finalBlockLight;
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block);
            GL11.glEndList();
        }
        return d;
    }

    @Override
    public void render(Pipe<PipeTransportFluids> pipe, double x, double y, double z, float f) {
        DisplayFluidList d;
        PipeTransportFluids trans = (PipeTransportFluids)pipe.transport;
        boolean needsRender = false;
        FluidRenderData renderData = trans.renderCache;
        for (int i = 0; i < 7; ++i) {
            if (renderData.amount[i] <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        int skylight = pipe.container.getWorld().func_72925_a(EnumSkyBlock.Sky, pipe.container.x(), pipe.container.y(), pipe.container.z());
        int blocklight = pipe.container.getWorld().func_72925_a(EnumSkyBlock.Block, pipe.container.x(), pipe.container.y(), pipe.container.z());
        boolean sides = false;
        boolean above = false;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            DisplayFluidList d2;
            int i = side.ordinal();
            if (renderData.amount[i] <= 0 || !pipe.container.isPipeConnected(side) || (d2 = this.getDisplayFluidLists(renderData.fluidID, skylight, blocklight, renderData.flags, pipe.container.func_145831_w())) == null) continue;
            int stage = (int)((float)renderData.amount[i] / (float)trans.getCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.bindTexture(TextureMap.field_110575_b);
            RenderUtils.setGLColorFromInt(renderData.color);
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        if (renderData.amount[6] > 0 && (d = this.getDisplayFluidLists(renderData.fluidID, skylight, blocklight, renderData.flags, pipe.container.func_145831_w())) != null) {
            int stage = (int)((float)renderData.amount[6] / (float)trans.getCapacity() * 39.0f);
            this.bindTexture(TextureMap.field_110575_b);
            RenderUtils.setGLColorFromInt(renderData.color);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private class DisplayFluidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayFluidList() {
        }
    }
}

