/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.gui;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.render.DynamicTextureBC;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.robotics.TileZonePlan;
import buildcraft.robotics.ZonePlan;
import buildcraft.robotics.gui.ContainerZonePlan;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiZonePlan
extends GuiAdvancedInterface {
    private static final ResourceLocation TMP_TEXTURE = new ResourceLocation("buildcraftrobotics:textures/gui/zone_planner_gui.png");
    private int mapWidth = 213;
    private int mapHeight = 100;
    private TileZonePlan zonePlan;
    private DynamicTextureBC newSelection;
    private int selX1 = 0;
    private int selX2 = 0;
    private int selY1 = 0;
    private int selY2 = 0;
    private boolean inSelection = false;
    private DynamicTextureBC currentSelection;
    private int mapXMin = 0;
    private int mapYMin = 0;
    private float blocksPerPixel = 1.0f;
    private int cx;
    private int cz;
    private AreaSlot colorSelected = null;
    private float alpha = 0.8f;
    private GuiBetterButton tool;
    private GuiBetterButton fsButton;
    private List inventorySlots;
    private List<GuiBetterButton> savedButtonList;
    private GuiTextField textField;

    public GuiZonePlan(IInventory inventory, TileZonePlan iZonePlan) {
        super(new ContainerZonePlan(inventory, iZonePlan), inventory, TMP_TEXTURE);
        this.getContainer().gui = this;
        this.field_146999_f = 256;
        this.field_147000_g = 228;
        this.zonePlan = iZonePlan;
        this.getContainer().mapTexture = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.currentSelection = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.newSelection = new DynamicTextureBC(1, 1);
        this.getContainer().currentAreaSelection = new ZonePlan();
        this.cx = this.zonePlan.field_145851_c;
        this.cz = this.zonePlan.field_145849_e;
        this.resetNullSlots(16);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.slots.set(i * 4 + j, new AreaSlot(this, 8 + 18 * i, 146 + 18 * j, EnumColor.values()[i * 4 + j]));
            }
        }
        this.colorSelected = (AreaSlot)this.slots.get(0);
        this.newSelection.setColor(0, 0, this.colorSelected.color.getDarkHex(), this.alpha);
        this.uploadMap();
        this.getContainer().loadArea(this.colorSelected.color.ordinal());
        this.inventorySlots = this.container.field_75151_b;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tool = new GuiBetterButton(0, this.field_147003_i + 27, this.field_147009_r + 111, 15, StandardButtonTextureSets.SMALL_BUTTON, "+");
        this.tool.setToolTip(new ToolTip(new ToolTipLine(StringUtils.localize("tip.tool.add"))));
        this.field_146292_n.add(this.tool);
        this.fsButton = new GuiBetterButton(1, this.field_147003_i + 44, this.field_147009_r + 111, 20, StandardButtonTextureSets.SMALL_BUTTON, "FS");
        this.fsButton.setToolTip(new ToolTip(new ToolTipLine(StringUtils.localize("tip.tool.fullscreen"))));
        this.field_146292_n.add(this.fsButton);
        this.savedButtonList = this.field_146292_n;
        this.textField = new GuiTextField(this.field_146289_q, 28, 129, 156, 12);
        this.textField.func_146203_f(32);
        this.textField.func_146180_a(this.zonePlan.mapName);
        this.textField.func_146195_b(true);
    }

    private void uploadMap() {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this.getContainer(), "computeMap", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeInt(GuiZonePlan.this.cx);
                data.writeInt(GuiZonePlan.this.cz);
                data.writeShort(GuiZonePlan.this.getContainer().mapTexture.width);
                data.writeShort(GuiZonePlan.this.getContainer().mapTexture.height);
                data.writeFloat(GuiZonePlan.this.blocksPerPixel);
            }
        }));
    }

    private boolean isFullscreen() {
        return this.getContainer().mapTexture.height > 100;
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.mapXMin = this.getContainer().mapTexture.width <= 213 ? this.field_147003_i + 8 + (213 - this.getContainer().mapTexture.width) / 2 : (this.field_146294_l - this.getContainer().mapTexture.width) / 2;
        this.mapYMin = this.getContainer().mapTexture.height <= 100 ? this.field_147009_r + 9 + (100 - this.getContainer().mapTexture.height) / 2 : (this.field_146295_m - this.getContainer().mapTexture.height) / 2;
        this.getContainer().mapTexture.draw(this.mapXMin, this.mapYMin, this.field_73735_i);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        this.currentSelection.draw(this.mapXMin, this.mapYMin, this.field_73735_i);
        GL11.glPopAttrib();
        GL11.glDisable((int)3042);
        this.newSelection.updateTexture();
        if (this.inSelection && this.selX2 != 0) {
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            int x1 = this.selX1 < this.selX2 ? this.selX1 : this.selX2;
            int x2 = this.selX1 < this.selX2 ? this.selX2 : this.selX1;
            int y1 = this.selY1 < this.selY2 ? this.selY1 : this.selY2;
            int y2 = this.selY1 < this.selY2 ? this.selY2 : this.selY1;
            this.func_73729_b(x1, y1, 0, 0, x2 - x1 + 1, y2 - y1 + 1);
            GL11.glPopAttrib();
            GL11.glDisable((int)3042);
        }
        if (!this.isFullscreen()) {
            this.drawBackgroundSlots(x, y);
            this.bindTexture(this.texture);
            GL11.glEnable((int)3008);
            this.func_73729_b(this.field_147003_i + this.colorSelected.x, this.field_147009_r + this.colorSelected.y, 0, 228, 16, 16);
            this.func_73729_b(this.field_147003_i + 236, this.field_147009_r + 27, 16, 228, 8, (int)((float)this.zonePlan.progress / 120.0f * 27.0f));
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (!this.isFullscreen()) {
            this.textField.func_146194_f();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        boolean clickOnMap;
        int blocksX = Math.round((float)(mouseX - this.mapXMin) * this.blocksPerPixel);
        int blocksZ = Math.round((float)(mouseY - this.mapYMin) * this.blocksPerPixel);
        int blockStartX = Math.round((float)this.cx - (float)this.mapWidth * this.blocksPerPixel / 2.0f);
        int blockStartZ = Math.round((float)this.cz - (float)this.mapHeight * this.blocksPerPixel / 2.0f);
        boolean bl = clickOnMap = mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height;
        if (clickOnMap) {
            if (mouseButton == 1) {
                this.cx = blockStartX + blocksX;
                this.cz = blockStartZ + blocksZ;
                this.uploadMap();
                this.refreshSelectedArea();
                return;
            }
            this.inSelection = true;
            this.selX1 = mouseX;
            this.selY1 = mouseY;
            this.selX2 = 0;
            this.selY2 = 0;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.textField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
        AdvancedSlot slot = this.getSlotAtLocation(mouseX, mouseY);
        if (slot instanceof AreaSlot) {
            this.colorSelected = (AreaSlot)slot;
            this.newSelection.setColor(0, 0, this.colorSelected.color.getDarkHex(), this.alpha);
            this.getContainer().loadArea(this.colorSelected.color.ordinal());
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int lastButtonBlicked, long time) {
        super.func_146273_a(mouseX, mouseY, lastButtonBlicked, time);
        if (this.inSelection && mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height) {
            this.selX2 = mouseX;
            this.selY2 = mouseY;
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        if (eventType != -1 && this.inSelection) {
            boolean val = this.tool.field_146126_j.equals("+");
            int blockStartX = Math.round((float)this.cx - (float)this.mapWidth * this.blocksPerPixel / 2.0f);
            int blockStartZ = Math.round((float)this.cz - (float)this.mapHeight * this.blocksPerPixel / 2.0f);
            int x1 = this.selX1 < this.selX2 ? this.selX1 : this.selX2;
            int x2 = this.selX1 < this.selX2 ? this.selX2 : this.selX1;
            int y1 = this.selY1 < this.selY2 ? this.selY1 : this.selY2;
            int y2 = this.selY1 < this.selY2 ? this.selY2 : this.selY1;
            int lengthX = Math.round((float)(x2 - x1) * this.blocksPerPixel);
            int lengthY = Math.round((float)(y2 - y1) * this.blocksPerPixel);
            for (int i = 0; i <= lengthX; ++i) {
                for (int j = 0; j <= lengthY; ++j) {
                    int x = Math.round((float)blockStartX + (float)(x1 - this.mapXMin) * this.blocksPerPixel) + i;
                    int z = Math.round((float)blockStartZ + (float)(y1 - this.mapYMin) * this.blocksPerPixel) + j;
                    this.getContainer().currentAreaSelection.set(x, z, val);
                }
            }
            this.inSelection = false;
            this.getContainer().saveArea(this.colorSelected.color.ordinal());
            this.refreshSelectedArea();
        }
    }

    private void toFullscreen() {
        if (this.blocksPerPixel > 4.0f) {
            this.blocksPerPixel = 4.0f;
        }
        this.mapWidth = this.field_146297_k.field_71443_c;
        this.mapHeight = this.field_146297_k.field_71440_d;
        this.getContainer().mapTexture = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.currentSelection = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.uploadMap();
        this.refreshSelectedArea();
        this.container.field_75151_b = new LinkedList();
        this.field_146292_n = new LinkedList();
    }

    private void toWindowed() {
        this.mapWidth = 213;
        this.mapHeight = 100;
        this.getContainer().mapTexture = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.currentSelection = new DynamicTextureBC(this.mapWidth, this.mapHeight);
        this.uploadMap();
        this.refreshSelectedArea();
        this.container.field_75151_b = this.inventorySlots;
        this.field_146292_n = this.savedButtonList;
    }

    private boolean incBlocksPerPixel() {
        if (this.blocksPerPixel > 0.125f) {
            this.blocksPerPixel = this.blocksPerPixel <= 1.0f ? (this.blocksPerPixel /= 2.0f) : (this.blocksPerPixel -= 1.0f);
            return true;
        }
        return false;
    }

    private boolean decBlocksPerPixel() {
        if (this.isFullscreen() && this.blocksPerPixel < 4.0f || !this.isFullscreen() && this.blocksPerPixel < 8.0f) {
            this.blocksPerPixel = this.blocksPerPixel >= 1.0f ? (this.blocksPerPixel += 1.0f) : (this.blocksPerPixel *= 2.0f);
            return true;
        }
        return false;
    }

    protected void func_73869_a(char carac, int val) {
        if (!this.isFullscreen() && this.textField.func_146206_l()) {
            if (carac == '\r' || carac == '\u001b') {
                this.textField.func_146195_b(false);
            } else {
                this.textField.func_146201_a(carac, val);
                final String text = this.textField.func_146179_b();
                BuildCraftCore.instance.sendToServer(new PacketCommand(this.getContainer(), "setName", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        NetworkUtils.writeUTF(data, text);
                    }
                }));
            }
            return;
        }
        if (val == 63) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == '+' && this.incBlocksPerPixel()) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == '-' && this.decBlocksPerPixel()) {
            this.uploadMap();
            this.refreshSelectedArea();
        } else if (carac == 'm' || carac == '\u001b' && this.isFullscreen()) {
            this.toWindowed();
        } else if (carac == 'M') {
            this.toFullscreen();
        } else {
            super.func_73869_a(carac, val);
        }
    }

    public void refreshSelectedArea() {
        int color = this.colorSelected.color.getDarkHex();
        int rAdd = color >> 16 & 0xFF;
        int gAdd = color >> 8 & 0xFF;
        int bAdd = color & 0xFF;
        for (int i = 0; i < this.currentSelection.width; ++i) {
            for (int j = 0; j < this.currentSelection.height; ++j) {
                int blockStartX = Math.round((float)this.cx - (float)this.mapWidth * this.blocksPerPixel / 2.0f);
                int blockStartZ = Math.round((float)this.cz - (float)this.mapHeight * this.blocksPerPixel / 2.0f);
                int c = (int)Math.ceil(this.blocksPerPixel);
                double r = 0.0;
                double g = 0.0;
                double b = 0.0;
                for (int stepi = 0; stepi < c; ++stepi) {
                    for (int stepj = 0; stepj < c; ++stepj) {
                        int z;
                        int x = Math.round((float)blockStartX + (float)i * this.blocksPerPixel) + stepi;
                        if (!this.getContainer().currentAreaSelection.get(x, z = Math.round((float)blockStartZ + (float)j * this.blocksPerPixel) + stepj)) continue;
                        r += (double)rAdd;
                        g += (double)gAdd;
                        b += (double)bAdd;
                    }
                }
                g /= (double)(c * c);
                b /= (double)(c * c);
                if ((r /= (double)(c * c)) != 0.0) {
                    this.currentSelection.setColori(i, j, (int)r, (int)g, (int)b, (int)(this.alpha * 255.0f));
                    continue;
                }
                this.currentSelection.setColori(i, j, 0, 0, 0, 0);
            }
        }
    }

    @Override
    public ContainerZonePlan getContainer() {
        return (ContainerZonePlan)super.getContainer();
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.tool) {
            if (this.tool.field_146126_j.equals("+")) {
                this.tool.field_146126_j = "-";
                this.tool.getToolTip().remove(0);
                this.tool.getToolTip().add(new ToolTipLine(StringUtils.localize("tip.tool.remove")));
            } else {
                this.tool.field_146126_j = "+";
                this.tool.getToolTip().remove(0);
                this.tool.getToolTip().add(new ToolTipLine(StringUtils.localize("tip.tool.add")));
            }
        } else if (button == this.fsButton) {
            this.toFullscreen();
        }
    }

    public void func_146274_d() {
        int wheel;
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (mouseX >= this.mapXMin && mouseX <= this.mapXMin + this.getContainer().mapTexture.width && mouseY >= this.mapYMin && mouseY <= this.mapYMin + this.getContainer().mapTexture.height && (wheel = Mouse.getEventDWheel()) != 0) {
            if (wheel > 0 && this.decBlocksPerPixel()) {
                this.uploadMap();
                this.refreshSelectedArea();
            } else if (wheel < 0 && this.incBlocksPerPixel()) {
                this.uploadMap();
                this.refreshSelectedArea();
            }
        }
    }

    private static class AreaSlot
    extends AdvancedSlot {
        public EnumColor color;

        public AreaSlot(GuiAdvancedInterface gui, int x, int y, EnumColor iColor) {
            super(gui, x, y);
            this.color = iColor;
        }

        @Override
        public IIcon getIcon() {
            return this.color.getIcon();
        }

        @Override
        public String getDescription() {
            return this.color.getLocalizedName();
        }
    }
}

