/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.render;

import buildcraft.builders.BuilderProxy;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.core.lib.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderFrame
implements ISimpleBlockRenderingHandler {
    private void renderTwoWayBlock(RenderBlocks renderblocks, FakeBlock stateHost, int x, int y, int z, float[] dim, int mask) {
        assert (mask != 0);
        stateHost.setRenderMask(mask);
        renderblocks.func_147782_a((double)dim[2], (double)dim[0], (double)dim[1], (double)dim[5], (double)dim[3], (double)dim[4]);
        renderblocks.func_147736_d((Block)stateHost, x, y, z, 1.0f, 1.0f, 1.0f);
        stateHost.setRenderMask((mask & 0x15) << 1 | (mask & 0x2A) >> 1);
        renderblocks.func_147782_a((double)dim[5], (double)dim[3], (double)dim[4], (double)dim[2], (double)dim[0], (double)dim[1]);
        renderblocks.func_147736_d((Block)stateHost, x, y, z, 0.8f, 0.8f, 0.8f);
        stateHost.setRenderAllSides();
    }

    private void resetToCenterDimensions(float[] dim) {
        for (int i = 0; i < 3; ++i) {
            dim[i] = 0.25f;
            dim[i + 3] = 0.75f;
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        renderer.func_147782_a(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
        RenderUtils.drawBlockItem(renderer, Tessellator.field_78398_a, block, metadata);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        FakeBlock fakeBlock = FakeBlock.INSTANCE;
        fakeBlock.getTextureState().set(block.func_149691_a(0, 0));
        int connectivity = 0;
        int connections = 0;
        float[] dim = new float[6];
        this.resetToCenterDimensions(dim);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            if (world.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ) != block) continue;
            connectivity |= 1 << i;
            ++connections;
        }
        if (connections != 2) {
            this.renderTwoWayBlock(renderer, fakeBlock, x, y, z, dim, 63);
        } else {
            this.renderTwoWayBlock(renderer, fakeBlock, x, y, z, dim, connectivity ^ 0x3F);
        }
        for (int dir = 0; dir < 6; ++dir) {
            int mask = 1 << dir;
            if ((connectivity & mask) == 0) continue;
            this.resetToCenterDimensions(dim);
            dim[dir / 2] = dir % 2 == 0 ? 0.0f : 0.75f;
            dim[dir / 2 + 3] = dir % 2 == 0 ? 0.25f : 1.0f;
            int renderMask = 3 << (dir & 6) ^ 0x3F;
            this.renderTwoWayBlock(renderer, fakeBlock, x, y, z, dim, renderMask);
        }
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BuilderProxy.frameRenderId;
    }
}

