/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.IInvSlot;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Schematic {
    public boolean isItemMatchingRequirement(ItemStack suppliedStack, ItemStack requiredStack) {
        return BuilderAPI.schematicHelper.isEqualItem(suppliedStack, requiredStack);
    }

    public ItemStack useItem(IBuilderContext context, ItemStack req, IInvSlot slot) {
        ItemStack stack = slot.getStackInSlot();
        ItemStack result = stack.func_77946_l();
        if (stack.func_77984_f()) {
            if (req.func_77960_j() + stack.func_77960_j() <= stack.func_77958_k()) {
                stack.func_77964_b(req.func_77960_j() + stack.func_77960_j());
                result.func_77964_b(req.func_77960_j());
                req.field_77994_a = 0;
            }
            if (stack.func_77960_j() >= stack.func_77958_k()) {
                slot.decreaseStackInSlot(1);
            }
        } else if (stack.field_77994_a >= req.field_77994_a) {
            result.field_77994_a = req.field_77994_a;
            stack.field_77994_a -= req.field_77994_a;
            req.field_77994_a = 0;
        } else {
            req.field_77994_a -= stack.field_77994_a;
            stack.field_77994_a = 0;
        }
        if (stack.field_77994_a == 0) {
            stack.field_77994_a = 1;
            if (stack.func_77973_b().hasContainerItem(stack)) {
                ItemStack newStack = stack.func_77973_b().getContainerItem(stack);
                slot.setStackInSlot(newStack);
            } else {
                slot.setStackInSlot(null);
            }
        }
        return result;
    }

    public void rotateLeft(IBuilderContext context) {
    }

    public void translateToBlueprint(Translation transform) {
    }

    public void translateToWorld(Translation transform) {
    }

    public void idsToBlueprint(MappingRegistry registry) {
    }

    public void idsToWorld(MappingRegistry registry) {
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
    }

    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
    }

    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
    }

    public int getEnergyRequirement(LinkedList<ItemStack> stacksUsed) {
        int result = 0;
        if (stacksUsed != null) {
            for (ItemStack s : stacksUsed) {
                result += s.field_77994_a * 240;
            }
        }
        return result;
    }

    public LinkedList<ItemStack> getStacksToDisplay(LinkedList<ItemStack> stackConsumed) {
        return stackConsumed;
    }

    public BuildingStage getBuildStage() {
        return BuildingStage.STANDALONE;
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return true;
    }

    public boolean doNotBuild() {
        return false;
    }

    public boolean doNotUse() {
        return false;
    }

    public BuildingPermission getBuildingPermission() {
        return BuildingPermission.ALL;
    }

    public void postProcessing(IBuilderContext context, int x, int y, int z) {
    }

    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
    }

    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
    }

    public int buildTime() {
        return 1;
    }

    public static enum BuildingStage {
        STANDALONE,
        EXPANDING;

    }
}

