/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.minetweaker;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.common.util.compat.minetweaker.MTHelper;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.BottlingMachine")
public class BottlingMachine {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, ILiquidStack fluid) {
        Object oInput = MTHelper.toObject(input);
        if (oInput == null || output == null || fluid == null) {
            return;
        }
        BottlingMachineRecipe r = new BottlingMachineRecipe(MTHelper.toStack(output), oInput, MTHelper.toFluidStack(fluid));
        MineTweakerAPI.apply((IUndoableAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<BottlingMachineRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = BottlingMachineRecipe.removeRecipes(this.output);
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (BottlingMachineRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    BottlingMachineRecipe.recipeList.add(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Bottling Machine Recipe for " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Re-Adding Bottling Machine Recipe for " + this.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final BottlingMachineRecipe recipe;

        public Add(BottlingMachineRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BottlingMachineRecipe.recipeList.add(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BottlingMachineRecipe.recipeList.remove(this.recipe);
        }

        public String describe() {
            return "Adding Bottling Machine Recipe for " + this.recipe.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Bottling Machine Recipe for " + this.recipe.output.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

