/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IERecipes;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class GregTechHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        IERecipes.addOredictRecipe(new ItemStack((Block)IEContent.blockMetalDevice, 8, 11), "LLL", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), "sheetRubber");
        IERecipes.addOredictRecipe(new ItemStack((Block)IEContent.blockMetalDevice, 1, 10), "III", "CBC", "CCC", Character.valueOf('I'), "ingotSteel", Character.valueOf('C'), "ingotCupronickel", Character.valueOf('B'), new ItemStack((Block)IEContent.blockStorage, 1, 8));
        if (Config.getBoolean("hardmodeBulletRecipes")) {
            BlueprintCraftingRecipe.addRecipe("bullet", new ItemStack((Item)IEContent.itemBullet, 1, 3), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.field_151016_H, "ingotSteel", "ingotCupronickel");
        } else {
            BlueprintCraftingRecipe.addRecipe("bullet", new ItemStack((Item)IEContent.itemBullet, 1, 3), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.field_151016_H, "nuggetSteel", "nuggetSteel", "nuggetCupronickel", "nuggetCupronickel");
        }
        IERecipes.oreOutputSecondaries.put("Beryllium", new Object[]{Items.field_151166_bC, Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Magnesium", new Object[]{"gemPeridot", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Silicon", new Object[]{"dustSiliconDioxide", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Phosphor", new Object[]{"dustPhosphate", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Titanium", new Object[]{new ItemStack((Item)IEContent.itemMetal, 1, 11), Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Chrome", new Object[]{"dustIron", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Manganese", new Object[]{"dustChrome", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Thorium", new Object[]{"dustUranium", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("PigIron", new Object[]{"dustIron", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Naquadah", new Object[]{"dustNaquadahEnriched", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("NaquadahEnriched", new Object[]{"dustNaquadah", Float.valueOf(0.1f)});
        IERecipes.addOreDictAlloyingRecipe("ingotHotNichrome", 5, "Chrome", 400, 4096, "dustNickel", "dustNickel", "dustNickel", "dustNickel");
        IERecipes.addOreDictAlloyingRecipe("ingotHotKanthal", 3, "Iron", 500, 4096, "dustAluminium", "dustChrome");
        IERecipes.addOreDictAlloyingRecipe("ingotHotKanthal", 3, "Aluminium", 500, 4096, "dustIron", "dustChrome");
        IERecipes.addOreDictAlloyingRecipe("ingotHotKanthal", 3, "Chrome", 500, 4096, "dustAluminium", "dustIron");
        IERecipes.addOreDictAlloyingRecipe("ingotMagnalium", 3, "Magnesium", 200, 512, "dustAluminium", "dustAluminium");
        IERecipes.addOreDictAlloyingRecipe("ingotBatteryAlloy", 5, "Antimony", 200, 512, "dustLead", "dustLead", "dustLead", "dustLead");
        IERecipes.addOreDictAlloyingRecipe("ingotHotTungstenSteel", 2, "Tungsten", 800, 4096, "dustSteel");
        IERecipes.addOreDictAlloyingRecipe("ingotHotTungstenSteel", 2, "Steel", 800, 4096, "dustTungsten");
        IERecipes.addOreDictAlloyingRecipe("ingotHotTungstenCarbide", 2, "Tungsten", 1000, 4096, "dustCoke");
        for (ExcavatorHandler.MineralMix min : ExcavatorHandler.mineralList.keySet()) {
            if (!min.name.equalsIgnoreCase("Magnetite")) continue;
            min.ores = new String[]{"oreMagnetite", "oreIron", "oreVanadiumMagnetite"};
            min.chances = new float[]{0.75f, 0.2f, 0.05f};
        }
        ExcavatorHandler.addMineral("Wolframite", 15, 0.2f, new String[]{"oreTungsten", "oreIron", "oreManganese"}, new float[]{0.55f, 0.3f, 0.15f});
    }

    @Override
    public void postInit() {
    }

    public static boolean gregtech_isValidEnergyOutput(TileEntity tile) {
        if (!Lib.GREG) {
            return false;
        }
        return tile instanceof IBasicEnergyContainer && ((IBasicEnergyContainer)tile).getEUCapacity() > 0L;
    }

    public static long gregtech_outputGTPower(Object energyContainer, byte side, long volt, long amp, boolean simulate) {
        if (!Lib.GREG) {
            return 0L;
        }
        if (energyContainer instanceof IBasicEnergyContainer) {
            IBasicEnergyContainer container = (IBasicEnergyContainer)energyContainer;
            if (!container.inputEnergyFrom(side) || container.getStoredEU() >= container.getEUCapacity()) {
                return 0L;
            }
            if (volt > container.getInputVoltage() && container instanceof IGregTechTileEntity) {
                ((IGregTechTileEntity)container).doExplosion(volt);
                return 0L;
            }
            long voltRound = volt;
            long in = 0L;
            if (((IBasicEnergyContainer)energyContainer).increaseStoredEnergyUnits(voltRound, false)) {
                // empty if block
            }
            if (simulate) {
                ((IBasicEnergyContainer)energyContainer).decreaseStoredEnergyUnits(voltRound, true);
            }
            return ++in > 0L ? volt : 0L;
        }
        return 0L;
    }
}

