/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.DirectionalChunkCoords;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    static String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    static Method m_getHarvestLevel = null;

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        ItemStack comp = Utils.copyStackWithAmount(stack, 1);
        ArrayList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!ItemStack.func_77989_b((ItemStack)comp, (ItemStack)st)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false);
        }
        if (o instanceof ArrayList) {
            for (Object io : (ArrayList)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        } else if (o instanceof ItemStack[]) {
            for (ItemStack io : (ItemStack[])o) {
                if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        } else if (o instanceof String) {
            return Utils.compareToOreName(stack, (String)o);
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack == null) {
            return null;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = amount;
        return s2;
    }

    public static int getDye(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        if (stack.func_77973_b().equals(Items.field_151100_aR)) {
            return stack.func_77960_j();
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return dye;
        }
        return -1;
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.tag != null && fs.tag.func_74764_b("pressurized")) {
            fs.tag.func_82580_o("pressurized");
            if (fs.tag.func_82582_d()) {
                fs.tag = null;
            }
        }
        return fs;
    }

    public static ChunkCoordinates toCC(Object object) {
        if (object instanceof ChunkCoordinates) {
            return (ChunkCoordinates)object;
        }
        if (object instanceof TileEntity) {
            return new ChunkCoordinates(((TileEntity)object).field_145851_c, ((TileEntity)object).field_145848_d, ((TileEntity)object).field_145849_e);
        }
        return null;
    }

    public static DirectionalChunkCoords toDirCC(Object object, ForgeDirection direction) {
        if (object instanceof ChunkCoordinates) {
            return new DirectionalChunkCoords((ChunkCoordinates)object, direction);
        }
        if (object instanceof TileEntity) {
            return new DirectionalChunkCoords(((TileEntity)object).field_145851_c, ((TileEntity)object).field_145848_d, ((TileEntity)object).field_145849_e, direction);
        }
        return null;
    }

    public static IImmersiveConnectable toIIC(Object object, World world) {
        TileEntity te;
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof ChunkCoordinates && world != null && world.func_72899_e(((ChunkCoordinates)object).field_71574_a, ((ChunkCoordinates)object).field_71572_b, ((ChunkCoordinates)object).field_71573_c) && (te = world.func_147438_o(((ChunkCoordinates)object).field_71574_a, ((ChunkCoordinates)object).field_71572_b, ((ChunkCoordinates)object).field_71573_c)) instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)te;
        }
        return null;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String getHarvestLevelName(int lvl) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))));
    }

    public static boolean tilePositionMatch(TileEntity tile0, TileEntity tile1) {
        return tile0.field_145851_c == tile1.field_145851_c && tile0.field_145848_d == tile1.field_145848_d && tile0.field_145849_e == tile1.field_145849_e;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityLivingBase living, boolean bool) {
        float f = 1.0f;
        float f1 = living.field_70127_C + (living.field_70125_A - living.field_70127_C) * f;
        float f2 = living.field_70126_B + (living.field_70177_z - living.field_70126_B) * f;
        double d0 = living.field_70169_q + (living.field_70165_t - living.field_70169_q) * (double)f;
        double d1 = living.field_70167_r + (living.field_70163_u - living.field_70167_r) * (double)f + (double)(world.field_72995_K ? living.func_70047_e() - (living instanceof EntityPlayer ? ((EntityPlayer)living).getDefaultEyeHeight() : 0.0f) : living.func_70047_e());
        double d2 = living.field_70166_s + (living.field_70161_v - living.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (living instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)living).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, bool, !bool, false);
    }

    public static boolean canBlocksSeeOther(World world, ChunkCoordinates cc0, ChunkCoordinates cc1, Vec3 pos0, Vec3 pos1) {
        HashSet<ChunkCoordinates> inter = Utils.rayTrace(pos0, pos1, world);
        for (ChunkCoordinates cc : inter) {
            if (cc.equals((Object)cc0) || cc.equals((Object)cc1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("IE_HAMMER");
    }

    public static Vec3 getFlowVector(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) instanceof BlockFluidBase) {
            return ((BlockFluidBase)world.func_147439_a(x, y, z)).getFlowVector((IBlockAccess)world, x, y, z);
        }
        if (!(world.func_147439_a(x, y, z) instanceof BlockLiquid)) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        BlockLiquid block = (BlockLiquid)world.func_147439_a(x, y, z);
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Material mat = block.func_149688_o();
        int l = Utils.getEffectiveFlowDecay((IBlockAccess)world, x, y, z, mat);
        for (int i1 = 0; i1 < 4; ++i1) {
            int i2;
            int l1;
            int j1 = x;
            int k1 = z;
            if (i1 == 0) {
                j1 = x - 1;
            }
            if (i1 == 1) {
                k1 = z - 1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++k1;
            }
            if ((l1 = Utils.getEffectiveFlowDecay((IBlockAccess)world, j1, y, k1, mat)) < 0) {
                if (world.func_147439_a(j1, y, k1).func_149688_o().func_76230_c() || (l1 = Utils.getEffectiveFlowDecay((IBlockAccess)world, j1, y - 1, k1, mat)) < 0) continue;
                i2 = l1 - (l - 8);
                vec3 = vec3.func_72441_c((double)((j1 - x) * i2), (double)((y - y) * i2), (double)((k1 - z) * i2));
                continue;
            }
            if (l1 < 0) continue;
            i2 = l1 - l;
            vec3 = vec3.func_72441_c((double)((j1 - x) * i2), (double)((y - y) * i2), (double)((k1 - z) * i2));
        }
        if (world.func_72805_g(x, y, z) >= 8) {
            boolean flag = false;
            if (flag || block.func_149747_d((IBlockAccess)world, x, y, z - 1, 2)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x, y, z + 1, 3)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x - 1, y, z, 4)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x + 1, y, z, 5)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x, y + 1, z - 1, 2)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x, y + 1, z + 1, 3)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x - 1, y + 1, z, 4)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec3 = vec3.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec3 = vec3.func_72432_b();
        return vec3;
    }

    static int getEffectiveFlowDecay(IBlockAccess world, int x, int y, int z, Material mat) {
        if (world.func_147439_a(x, y, z).func_149688_o() != mat) {
            return -1;
        }
        int l = world.func_72805_g(x, y, z);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public static Vec3 addVectors(Vec3 vec0, Vec3 vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static Vec3 rotateVector(Vec3 vec0, double angleX, double angleY, double angleZ) {
        Vec3 vec1 = Vec3.func_72443_a((double)vec0.field_72450_a, (double)vec0.field_72448_b, (double)vec0.field_72449_c);
        if (angleX != 0.0) {
            vec1.func_72440_a((float)angleX);
        }
        if (angleY != 0.0) {
            vec1.func_72442_b((float)angleY);
        }
        if (angleZ != 0.0) {
            vec1.func_72446_c((float)angleZ);
        }
        return vec1;
    }

    public static boolean isVecInEntityHead(EntityLivingBase entity, Vec3 vec) {
        if (entity.field_70131_O / entity.field_70130_N < 2.0f) {
            return false;
        }
        double d = vec.field_72448_b - (entity.field_70163_u + (double)entity.func_70047_e());
        return Math.abs(d) < 0.25;
    }

    public static NBTTagCompound getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = ItemDye.field_150922_c[j];
        }
        expl.func_74783_a("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.func_74774_a("Type", (byte)type);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)expl);
        tag.func_74782_a("Explosions", (NBTBase)list);
        return tag;
    }

    public static FluidStack drainFluidBlock(World world, int x, int y, int z, boolean doDrain) {
        Block b = world.func_147439_a(x, y, z);
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f != null) {
            if (b instanceof IFluidBlock) {
                if (((IFluidBlock)b).canDrain(world, x, y, z)) {
                    return ((IFluidBlock)b).drain(world, x, y, z, doDrain);
                }
                return null;
            }
            if (world.func_72805_g(x, y, z) == 0) {
                if (doDrain) {
                    world.func_147468_f(x, y, z);
                }
                return new FluidStack(f, 1000);
            }
            return null;
        }
        return null;
    }

    public static boolean placeFluidBlock(World world, int x, int y, int z, FluidStack fluid) {
        boolean canPlace;
        if (fluid == null || fluid.getFluid() == null) {
            return false;
        }
        Block b = world.func_147439_a(x, y, z);
        Block fluidBlock = fluid.getFluid().getBlock();
        if (Blocks.field_150355_j.equals(fluidBlock)) {
            fluidBlock = Blocks.field_150358_i;
        } else if (Blocks.field_150353_l.equals(fluidBlock)) {
            fluidBlock = Blocks.field_150356_k;
        }
        boolean bl = canPlace = b == null || b.isAir((IBlockAccess)world, x, y, z) || b.isReplaceable((IBlockAccess)world, x, y, z);
        if (fluidBlock != null && canPlace && fluid.amount >= 1000) {
            boolean placed = false;
            if (fluidBlock instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)fluidBlock;
                placed = world.func_147465_d(x, y, z, fluidBlock, blockFluid.getMaxRenderHeightMeta(), 3);
            } else {
                placed = world.func_147449_b(x, y, z, fluidBlock);
            }
            if (placed) {
                fluid.amount -= 1000;
            }
            return placed;
        }
        return false;
    }

    public static Collection<ItemStack> getContainersFilledWith(FluidStack fluidStack) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.fluid.containsFluid(fluidStack)) continue;
            containers.add(data.filledContainer);
        }
        return containers;
    }

    public static String nameFromStack(ItemStack stack) {
        if (stack == null) {
            return "";
        }
        try {
            return GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static ItemStack insertStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null || inventory == null) {
            return null;
        }
        int stackSize = stack.field_77994_a;
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                ItemStack existingStack;
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !OreDictionary.itemMatches((ItemStack)(existingStack = inventory.func_70301_a(slots[i])), (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = Utils.addToOccupiedSlot((IInventory)sidedInv, slots[i], stack, existingStack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (inventory.func_70301_a(slots[i]) != null || !sidedInv.func_102007_a(slots[i], stack, side)) continue;
                stack = Utils.addToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                ItemStack existingStack = inventory.func_70301_a(i);
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = Utils.addToOccupiedSlot(inventory, i, stack, existingStack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                stack = Utils.addToEmptyInventorySlot(inventory, i, stack);
            }
        }
        if (stack == null || stack.field_77994_a != stackSize) {
            inventory.func_70296_d();
        }
        return stack;
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, Utils.copyStackWithAmount(stack, Math.min(stack.field_77994_a, stackLimit)));
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack addToOccupiedSlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (stack.field_77994_a + existingStack.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - existingStack.field_77994_a;
            existingStack.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, existingStack);
            return stack;
        }
        existingStack.field_77994_a += Math.min(stack.field_77994_a, stackLimit);
        inventory.func_70299_a(slot, existingStack);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static boolean canInsertStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null || inventory == null) {
            return false;
        }
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return false;
            }
            for (int i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !sidedInv.func_94041_b(slots[i], stack)) continue;
                ItemStack existingStack = inventory.func_70301_a(slots[i]);
                if (existingStack == null) {
                    return true;
                }
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack) || existingStack.field_77994_a + stack.field_77994_a >= inventory.func_70297_j_() || existingStack.field_77994_a + stack.field_77994_a >= existingStack.func_77976_d()) continue;
                return true;
            }
        } else {
            int invSize = inventory.func_70302_i_();
            for (int i = 0; i < invSize && stack != null; ++i) {
                if (!inventory.func_94041_b(i, stack)) continue;
                ItemStack existingStack = inventory.func_70301_a(i);
                if (existingStack == null) {
                    return true;
                }
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack) || existingStack.field_77994_a + stack.field_77994_a >= inventory.func_70297_j_() || existingStack.field_77994_a + stack.field_77994_a >= existingStack.func_77976_d()) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack fillFluidContainer(FluidTank tank, ItemStack containerIn, ItemStack containerOut) {
        if (tank.getFluidAmount() > 0 && containerIn != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)containerIn)) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)containerIn);
                if (filledContainer != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
                    if (fs.amount <= tank.getFluidAmount() && (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true))) {
                        tank.drain(fs.amount, true);
                        return filledContainer;
                    }
                }
            } else if (containerIn.func_77973_b() instanceof IFluidContainerItem) {
                int space;
                IFluidContainerItem iContainer = (IFluidContainerItem)containerIn.func_77973_b();
                int available = tank.getFluidAmount();
                if (available >= (space = iContainer.getCapacity(containerIn) - (iContainer.getFluid(containerIn) == null ? 0 : iContainer.getFluid((ItemStack)containerIn).amount)) && iContainer.fill(containerIn, tank.getFluid(), false) == space) {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.func_77970_a((ItemStack)filledContainer, (ItemStack)containerOut)) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                } else if (containerIn.field_77994_a == 1) {
                    int filled = iContainer.fill(containerIn, tank.getFluid(), true);
                    tank.drain(filled, true);
                } else {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.func_77970_a((ItemStack)filledContainer, (ItemStack)containerOut) && containerOut.field_77994_a + 1 < containerOut.func_77976_d()) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                }
            }
        }
        return null;
    }

    public static ItemStack drainFluidContainer(FluidTank tank, ItemStack containerIn) {
        ItemStack emptyContainer;
        FluidStack fs;
        if (containerIn != null && FluidContainerRegistry.isFilledContainer((ItemStack)containerIn) && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)containerIn)) != null && tank.getFluidAmount() + fs.amount <= tank.getCapacity() && (emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)containerIn)) != null && tank.fill(fs, true) == fs.amount) {
            return emptyContainer;
        }
        return null;
    }

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        if (fluid != null) {
            return fluid;
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        }
        return null;
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return FluidContainerRegistry.isContainer((ItemStack)stack) || stack.func_77973_b() instanceof IFluidContainerItem;
    }

    public static boolean fillPlayerItemFromFluidHandler(World world, IFluidHandler handler, EntityPlayer player, FluidStack tankFluid) {
        IFluidContainerItem container;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)equipped)) {
            ItemStack filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)tankFluid, (ItemStack)equipped);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledStack);
            if (fluid == null || filledStack == null) {
                return false;
            }
            if (world.field_72995_K) {
                return true;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (equipped.field_77994_a == 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledStack);
                    --equipped.field_77994_a;
                    if (equipped.field_77994_a <= 0) {
                        equipped = null;
                    }
                } else {
                    --equipped.field_77994_a;
                    if (!player.field_71071_by.func_70441_a(filledStack)) {
                        player.func_146097_a(filledStack, false, true);
                    }
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
            }
            handler.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            return true;
        }
        if (equipped.func_77973_b() instanceof IFluidContainerItem && (container = (IFluidContainerItem)equipped.func_77973_b()).fill(equipped, tankFluid, false) > 0) {
            if (world.field_72995_K) {
                return true;
            }
            int fill = container.fill(equipped, tankFluid, true);
            handler.drain(ForgeDirection.UNKNOWN, fill, true);
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
            return true;
        }
        return false;
    }

    public static boolean fillFluidHandlerWithPlayerItem(World world, IFluidHandler handler, EntityPlayer player) {
        IFluidContainerItem container;
        ItemStack equipped = player.func_71045_bC();
        if (equipped == null) {
            return false;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)equipped);
        if (fluid != null) {
            if (handler.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount || player.field_71075_bZ.field_75098_d) {
                if (world.field_72995_K) {
                    return true;
                }
                ItemStack filledStack = FluidContainerRegistry.drainFluidContainer((ItemStack)equipped);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (equipped.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        player.field_71071_by.func_70441_a(filledStack);
                    } else {
                        --equipped.field_77994_a;
                        if (filledStack != null && !player.field_71071_by.func_70441_a(filledStack)) {
                            player.func_146097_a(filledStack, false, true);
                        }
                    }
                    player.field_71070_bA.func_75142_b();
                    ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
                }
                handler.fill(ForgeDirection.UNKNOWN, fluid, true);
                return true;
            }
        } else if (equipped.func_77973_b() instanceof IFluidContainerItem && handler.fill(ForgeDirection.UNKNOWN, fluid = (container = (IFluidContainerItem)equipped.func_77973_b()).getFluid(equipped), false) > 0) {
            if (world.field_72995_K) {
                return true;
            }
            int fill = handler.fill(ForgeDirection.UNKNOWN, fluid, true);
            container.drain(equipped, fill, true);
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
            return true;
        }
        return false;
    }

    public static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe irecipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!irecipe.func_77569_a(crafting, world)) continue;
            return irecipe;
        }
        return null;
    }

    public static HashSet<ChunkCoordinates> rayTrace(Vec3 start, Vec3 end, World world) {
        Vec3 tmp;
        HashSet<ChunkCoordinates> ret = new HashSet<ChunkCoordinates>();
        HashSet<ChunkCoordinates> checked = new HashSet<ChunkCoordinates>();
        if (start.field_72450_a > end.field_72450_a) {
            Vec3 tmp2 = start;
            start = end;
            end = tmp2;
        }
        double min = start.field_72450_a;
        double dif = end.field_72450_a - min;
        double lengthAdd = Math.ceil(min) - start.field_72450_a;
        Vec3 mov = start.func_72444_a(end);
        if (mov.field_72450_a != 0.0) {
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72450_a);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.field_150482_ag);
        }
        if (mov.field_72448_b != 0.0) {
            if (start.field_72448_b > end.field_72448_b) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.field_72448_b;
            dif = end.field_72448_b - min;
            lengthAdd = Math.ceil(min) - start.field_72448_b;
            mov = start.func_72444_a(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72448_b);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.field_150366_p);
        }
        if (mov.field_72449_c != 0.0) {
            if (start.field_72449_c > end.field_72449_c) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.field_72449_c;
            dif = end.field_72449_c - min;
            lengthAdd = Math.ceil(min) - start.field_72449_c;
            mov = start.func_72444_a(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72449_c);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, Blocks.field_150352_o);
        }
        return ret;
    }

    private static void ray(double dif, Vec3 mov, Vec3 start, double lengthAdd, HashSet<ChunkCoordinates> ret, World world, HashSet<ChunkCoordinates> checked, Block tmp) {
        boolean place = false;
        double standartOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            int meta;
            Block b;
            Vec3 pos = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd + standartOff));
            Vec3 posNext = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i + 1) + lengthAdd + standartOff));
            Vec3 posPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd - standartOff));
            Vec3 posVeryPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i - 1) + lengthAdd - standartOff));
            ChunkCoordinates cc = new ChunkCoordinates((int)Math.floor(pos.field_72450_a), (int)Math.floor(pos.field_72448_b), (int)Math.floor(pos.field_72449_c));
            if (!checked.contains(cc) && (double)i + lengthAdd + standartOff < dif) {
                b = world.func_147439_a(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                if (b.func_149678_a(meta = world.func_72805_g(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c), false) && b.func_149731_a(world, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, pos, posNext) != null) {
                    ret.add(cc);
                }
                if (place) {
                    world.func_147449_b(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, tmp);
                }
                checked.add(cc);
            }
            if (!checked.contains(cc = new ChunkCoordinates((int)Math.floor(posPrev.field_72450_a), (int)Math.floor(posPrev.field_72448_b), (int)Math.floor(posPrev.field_72449_c))) && (double)i + lengthAdd - standartOff < dif) {
                b = world.func_147439_a(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c);
                if (b.func_149678_a(meta = world.func_72805_g(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c), false) && b.func_149731_a(world, cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, posVeryPrev, posPrev) != null) {
                    ret.add(cc);
                }
                if (place) {
                    world.func_147449_b(cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, tmp);
                }
                checked.add(cc);
            }
            ++i;
        }
    }

    public static Vec3 scalarProd(Vec3 v, double s) {
        return Vec3.func_72443_a((double)(v.field_72450_a * s), (double)(v.field_72448_b * s), (double)(v.field_72449_c * s));
    }

    public static ChunkCoordinates rayTraceForFirst(Vec3 start, Vec3 end, World w, HashSet<ChunkCoordinates> ignore) {
        HashSet<ChunkCoordinates> trace = Utils.rayTrace(start, end, w);
        for (ChunkCoordinates cc : ignore) {
            trace.remove(cc);
        }
        if (start.field_72450_a != end.field_72450_a) {
            trace = Utils.findMinOrMax(trace, start.field_72450_a > end.field_72450_a, 0);
        }
        if (start.field_72448_b != end.field_72448_b) {
            trace = Utils.findMinOrMax(trace, start.field_72448_b > end.field_72448_b, 0);
        }
        if (start.field_72449_c != end.field_72449_c) {
            trace = Utils.findMinOrMax(trace, start.field_72449_c > end.field_72449_c, 0);
        }
        if (trace.size() > 0) {
            ChunkCoordinates ret = trace.iterator().next();
            return ret;
        }
        return null;
    }

    public static HashSet<ChunkCoordinates> findMinOrMax(HashSet<ChunkCoordinates> in, boolean max, int coord) {
        int curr;
        HashSet<ChunkCoordinates> ret = new HashSet<ChunkCoordinates>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (ChunkCoordinates cc : in) {
            curr = coord == 0 ? cc.field_71574_a : (coord == 1 ? cc.field_71572_b : cc.field_71573_c);
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (ChunkCoordinates cc : in) {
            curr = coord == 0 ? cc.field_71574_a : (coord == 1 ? cc.field_71572_b : cc.field_71573_c);
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static class InventoryCraftingFalse
    extends InventoryCrafting {
        private static final Container nullContainer = new Container(){

            public void func_75130_a(IInventory paramIInventory) {
            }

            public boolean func_75145_c(EntityPlayer p_75145_1_) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }
    }
}

