/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.ItemInternalStorage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemUpgradeableTool
extends ItemInternalStorage
implements IUpgradeableTool {
    String upgradeType;

    public ItemUpgradeableTool(String name, int stackSize, String upgradeType, String ... subNames) {
        super(name, stackSize, subNames);
        this.upgradeType = upgradeType;
    }

    @Override
    public NBTTagCompound getUpgrades(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "upgrades");
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        ItemNBTHelper.remove(stack, "upgrades");
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        this.clearUpgrades(stack);
        ItemStack[] inv = this.getContainedItems(stack);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 1; i < inv.length; ++i) {
            IUpgrade upg;
            ItemStack u = inv[i];
            if (u == null || !(u.func_77973_b() instanceof IUpgrade) || !(upg = (IUpgrade)u.func_77973_b()).getUpgradeTypes(u).contains(this.upgradeType) || !upg.canApplyUpgrades(stack, u)) continue;
            upg.applyUpgrades(stack, u, map);
        }
        NBTTagCompound upgradeTag = (NBTTagCompound)this.getUpgradeBase(stack).func_74737_b();
        for (String key : map.keySet()) {
            Object o = map.get(key);
            if (o instanceof Byte) {
                upgradeTag.func_74774_a(key, ((Byte)o).byteValue());
                continue;
            }
            if (o instanceof byte[]) {
                upgradeTag.func_74773_a(key, (byte[])o);
                continue;
            }
            if (o instanceof Boolean) {
                upgradeTag.func_74757_a(key, ((Boolean)o).booleanValue());
                continue;
            }
            if (o instanceof Integer) {
                upgradeTag.func_74768_a(key, ((Integer)o).intValue());
                continue;
            }
            if (o instanceof int[]) {
                upgradeTag.func_74783_a(key, (int[])o);
                continue;
            }
            if (o instanceof Float) {
                upgradeTag.func_74776_a(key, ((Float)o).floatValue());
                continue;
            }
            if (o instanceof Double) {
                upgradeTag.func_74780_a(key, ((Double)o).doubleValue());
                continue;
            }
            if (!(o instanceof String)) continue;
            upgradeTag.func_74778_a(key, (String)o);
        }
        ItemNBTHelper.setTagCompound(stack, "upgrades", upgradeTag);
    }

    public NBTTagCompound getUpgradeBase(ItemStack stack) {
        return new NBTTagCompound();
    }

    @Override
    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public abstract boolean canModify(ItemStack var1);

    @Override
    public abstract Slot[] getWorkbenchSlots(Container var1, ItemStack var2, IInventory var3);
}

