/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDrillhead
extends ItemIEBase
implements IDrillHead {
    DrillHeadPerm[] perms;

    public ItemDrillhead() {
        super("drillhead", 1, "steel", "iron");
        this.perms = new DrillHeadPerm[this.subNames.length];
        this.addPerm(0, new DrillHeadPerm("ingotSteel", 3, 1, 3, 10.0f, 7, 4000, "immersiveengineering:drill_diesel"));
        this.addPerm(1, new DrillHeadPerm("ingotIron", 2, 1, 2, 9.0f, 6, 2000, "immersiveengineering:drill_iron"));
    }

    private void addPerm(int i, DrillHeadPerm perm) {
        if (i < this.perms.length) {
            this.perms[i] = perm;
        }
    }

    private DrillHeadPerm getHeadPerm(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() < this.perms.length) {
            return this.perms[stack.func_77960_j()];
        }
        return new DrillHeadPerm("", 0, 0, 0, 0.0f, 0, 0, "immersiveengineering:textures/models/drill_diesel");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        if (stack.func_77960_j() < this.getSubNames().length) {
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.flavour.drillhead.size", (Object[])new Object[]{this.getMiningSize(stack), this.getMiningDepth(stack)}));
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.flavour.drillhead.level", (Object[])new Object[]{Utils.getHarvestLevelName(this.getMiningLevel(stack))}));
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.flavour.drillhead.speed", (Object[])new Object[]{Utils.formatDouble(this.getMiningSpeed(stack), "0.###")}));
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.flavour.drillhead.damage", (Object[])new Object[]{Utils.formatDouble(this.getAttackDamage(stack), "0.###")}));
            int maxDmg = this.getMaximumHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            String status = "" + ((double)quote < 0.1 ? EnumChatFormatting.RED : ((double)quote < 0.3 ? EnumChatFormatting.GOLD : ((double)quote < 0.6 ? EnumChatFormatting.YELLOW : EnumChatFormatting.GREEN)));
            String s = status + (this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack)) + "/" + this.getMaximumHeadDamage(stack);
            list.add(StatCollector.func_74837_a((String)"desc.ImmersiveEngineering.info.durability", (Object[])new Object[]{s}));
        }
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getSubNames().length; ++i) {
            ItemStack s = new ItemStack((Item)this, 1, i);
            if (OreDictionary.getOres((String)this.getHeadPerm((ItemStack)s).repairMaterial).isEmpty()) continue;
            list.add(s);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        super.func_94581_a(ir);
        for (DrillHeadPerm p : this.perms) {
            p.icon = ir.func_94245_a(p.texture);
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return Utils.compareToOreName(material, this.getHeadPerm((ItemStack)stack).repairMaterial);
    }

    @Override
    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, EntityPlayer player) {
        return false;
    }

    @Override
    public void afterBlockbreak(ItemStack drill, ItemStack head, EntityPlayer player) {
    }

    @Override
    public int getMiningSize(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillSize;
    }

    @Override
    public int getMiningDepth(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillDepth;
    }

    @Override
    public int getMiningLevel(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillLevel;
    }

    @Override
    public float getMiningSpeed(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillSpeed;
    }

    @Override
    public float getAttackDamage(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).drillAttack;
    }

    @Override
    public int getHeadDamage(ItemStack head) {
        return ItemNBTHelper.getInt(head, "headDamage");
    }

    @Override
    public int getMaximumHeadDamage(ItemStack head) {
        return this.getHeadPerm((ItemStack)head).maxDamage;
    }

    @Override
    public void damageHead(ItemStack head, int dmg) {
        ItemNBTHelper.setInt(head, "headDamage", ItemNBTHelper.getInt(head, "headDamage") + dmg);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemNBTHelper.getInt(stack, "headDamage") / (double)this.getMaximumHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, "headDamage") > 0;
    }

    @Override
    public IIcon getDrillTexture(ItemStack drill, ItemStack head) {
        DrillHeadPerm perm = this.getHeadPerm(head);
        return perm.icon != null ? perm.icon : IEContent.itemDrill.icons[0];
    }

    static class DrillHeadPerm {
        final String repairMaterial;
        final int drillSize;
        final int drillDepth;
        final int drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        final String texture;
        public IIcon icon;

        public DrillHeadPerm(String repairMaterial, int drillSize, int drillDepth, int drillLevel, float drillSpeed, int drillAttack, int maxDamage, String texture) {
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
        }
    }
}

