/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityWoodenBarrel
extends TileEntityIEBase
implements IFluidHandler,
IEBlockInterfaces.IBlockOverlayText {
    public int[] sideConfig = new int[]{-1, 0};
    public FluidTank tank = new FluidTank(12000);
    public static final int IGNITION_TEMPERATURE = 573;

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 1) {
            this.sideConfig[side] = -1;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean update = false;
        for (int i = 0; i < 2; ++i) {
            if (this.tank.getFluidAmount() <= 0 || this.sideConfig[i] != 1) continue;
            ForgeDirection f = ForgeDirection.getOrientation((int)i);
            int out = Math.min(40, this.tank.getFluidAmount());
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + f.offsetY, this.field_145849_e);
            if (te == null || !(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(f.getOpposite(), this.tank.getFluid().getFluid())) continue;
            int accepted = ((IFluidHandler)te).fill(f.getOpposite(), new FluidStack(this.tank.getFluid().getFluid(), out), false);
            FluidStack drained = this.tank.drain(accepted, true);
            ((IFluidHandler)te).fill(f.getOpposite(), drained, true);
            update = true;
        }
        if (update) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.func_71045_bC())) {
            String s = null;
            s = this.tank.getFluid() != null ? this.tank.getFluid().getLocalizedName() + ": " + this.tank.getFluidAmount() + "mB" : StatCollector.func_74838_a((String)"gui.ImmersiveEngineering.empty");
            return new String[]{s};
        }
        if (hammer && Config.getBoolean("colourblindSupport") && mop.field_72310_e < 2) {
            int i = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_72310_e)];
            int j = this.sideConfig[Math.min(this.sideConfig.length - 1, ForgeDirection.OPPOSITES[mop.field_72310_e])];
            return new String[]{StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.blockSide.facing") + ": " + StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide.connectFluid." + i)), StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.blockSide.opposite") + ": " + StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide.connectFluid." + j))};
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.func_74759_k("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length < 2) {
            this.sideConfig = new int[]{-1, 0};
        }
        this.readTank(nbt);
    }

    public void readTank(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideConfig", this.sideConfig);
        this.writeTank(nbt, false);
    }

    public void writeTank(NBTTagCompound nbt, boolean toItem) {
        boolean write = this.tank.getFluidAmount() > 0;
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        if (!toItem || write) {
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isFluidValid(resource) && this.canFill(from, resource.getFluid())) {
            int i = this.tank.fill(resource, doFill);
            if (i > 0) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return i;
        }
        return 0;
    }

    public boolean isFluidValid(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getTemperature(fluid) < 573 && !fluid.getFluid().isGaseous(fluid);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource != null ? resource.amount : 0, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            FluidStack f = this.tank.drain(maxDrain, doDrain);
            if (f != null && f.amount > 0) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return f;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UNKNOWN || from.ordinal() < 2 && this.sideConfig[from.ordinal()] == 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UNKNOWN || from.ordinal() < 2 && this.sideConfig[from.ordinal()] == 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

