/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityExcavator;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockBucketWheel;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class MultiblockExcavator
implements MultiblockHandler.IMultiblock {
    public static MultiblockExcavator instance = new MultiblockExcavator();
    static ItemStack[][][] structure = new ItemStack[3][6][3];

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        TileEntityExcavator te = new TileEntityExcavator();
        te.formed = true;
        te.pos = 4;
        te.facing = 3;
        ClientUtils.bindAtlas(0);
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78373_b(-0.5, -0.5, 2.5);
        ClientUtils.handleStaticTileRenderer(te, false);
        ClientUtils.tes().func_78373_b(0.0, 0.0, 0.0);
        ClientUtils.tes().func_78381_a();
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public String getUniqueName() {
        return "IE:Excavator";
    }

    @Override
    public boolean isBlockTrigger(Block b, int meta) {
        return b == IEContent.blockMetalDecoration && meta == 5;
    }

    @Override
    public boolean createStructure(World world, int x, int y, int z, int side, EntityPlayer player) {
        if (side == 0 || side == 1) {
            return false;
        }
        int startX = x;
        int startY = y;
        int startZ = z;
        boolean mirrored = false;
        boolean b = this.structureCheck(world, startX, startY, startZ, side, mirrored);
        if (!b) {
            mirrored = true;
            b = this.structureCheck(world, startX, startY, startZ, side, mirrored);
        }
        if (b) {
            for (int l = 0; l < 6; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int ww;
                        if (l > 0 && w == 0 || (l == 3 || l == 5) && w == -1 && h == 1) continue;
                        int n = ww = mirrored ? -w : w;
                        int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)));
                        int yy = startY + h;
                        int zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww)));
                        world.func_147465_d(xx, yy, zz, (Block)IEContent.blockMetalMultiblocks, 7, 3);
                        TileEntity curr = world.func_147438_o(xx, yy, zz);
                        if (!(curr instanceof TileEntityExcavator)) continue;
                        TileEntityExcavator tile = (TileEntityExcavator)curr;
                        tile.facing = side;
                        tile.formed = true;
                        tile.pos = l * 9 + (h + 1) * 3 + (w + 1);
                        tile.offset = new int[]{side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)), h, side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww))};
                        tile.mirrored = mirrored;
                    }
                }
            }
            player.func_71029_a((StatBase)IEAchievements.mbExcavator);
            int wheelX = startX + (side == 4 ? 4 : (side == 5 ? -4 : 0));
            int wheelZ = startZ + (side == 2 ? 4 : (side == 3 ? -4 : 0));
            if (MultiblockBucketWheel.instance.isBlockTrigger(world.func_147439_a(wheelX, startY, wheelZ), world.func_72805_g(wheelX, startY, wheelZ))) {
                MultiblockBucketWheel.instance.createStructure(world, wheelX, startY, wheelZ, ForgeDirection.ROTATION_MATRIX[0][side], player);
            }
        }
        return b;
    }

    boolean structureCheck(World world, int startX, int startY, int startZ, int side, boolean mirror) {
        for (int l = 0; l < 6; ++l) {
            for (int w = -1; w <= 1; ++w) {
                for (int h = -1; h <= 1; ++h) {
                    int zz;
                    int yy;
                    int ww;
                    if (l > 0 && w == 0 || (l == 3 || l == 5) && w == -1 && h == 1) continue;
                    int n = ww = mirror ? -w : w;
                    int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)));
                    if (world.func_147437_c(xx, yy = startY + h, zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww))))) {
                        return false;
                    }
                    ItemStack checkStack = new ItemStack(world.func_147439_a(xx, yy, zz), 1, world.func_72805_g(xx, yy, zz));
                    if (!(OreDictionary.itemMatches((ItemStack)structure[h + 1][5 - l][w + 1], (ItemStack)new ItemStack((Block)IEContent.blockStorage, 1, 7), (boolean)true) ? !Utils.compareToOreName(checkStack, "blockSteel") : !OreDictionary.itemMatches((ItemStack)structure[h + 1][5 - l][w + 1], (ItemStack)checkStack, (boolean)true))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack((Block)IEContent.blockStorage, 12, 7), new ItemStack((Block)IEContent.blockMetalDecoration, 9, 7), new ItemStack((Block)IEContent.blockMetalDecoration, 13, 5), new ItemStack((Block)IEContent.blockMetalDecoration, 3, 1)};
    }

    static {
        for (int l = 0; l < 6; ++l) {
            for (int w = 0; w < 3; ++w) {
                for (int h = 0; h < 3; ++h) {
                    if (l < 5 && w == 1 || (l == 2 || l == 0) && w == 0 && h == 2) continue;
                    int m = -1;
                    if (l == 5) {
                        if (w != 0 && (h != 1 || w != 1)) {
                            MultiblockExcavator.structure[h][l][w] = new ItemStack((Block)IEContent.blockStorage, 1, 7);
                        } else {
                            m = h == 1 && w == 0 ? 7 : 5;
                        }
                    } else if (l == 4) {
                        if (w == 0 && h == 1) {
                            MultiblockExcavator.structure[h][l][w] = new ItemStack((Block)IEContent.blockStorage, 1, 7);
                        } else {
                            m = w == 2 ? 7 : 5;
                        }
                    } else if (l == 3) {
                        MultiblockExcavator.structure[h][l][w] = new ItemStack((Block)IEContent.blockStorage, 1, 7);
                    } else {
                        m = w == 2 ? (h < 2 ? 5 : 1) : (l != 1 ? (h == 0 ? 5 : 7) : 7);
                    }
                    if (m < 0) continue;
                    MultiblockExcavator.structure[h][l][w] = new ItemStack((Block)IEContent.blockMetalDecoration, 1, m);
                }
            }
        }
    }
}

