/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityConveyorSorter
extends TileEntityIEBase
implements ISidedInventory,
IEBlockInterfaces.IBlockOverlayText {
    public SorterInventory filter;
    public int[] oreDictFilter = new int[]{-1, -1, -1, -1, -1, -1};
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    public static final int filterSlotsPerSide = 8;

    public TileEntityConveyorSorter() {
        this.filter = new SorterInventory(this);
    }

    public boolean canUpdate() {
        return false;
    }

    public void routeItem(int inputSide, ItemStack stack) {
        block6: {
            int i;
            int rand;
            Integer[][] validOutputs;
            block7: {
                if (this.field_145850_b.field_72995_K) break block6;
                validOutputs = this.getValidOutputs(inputSide, stack, true, false);
                if (validOutputs[0].length > 0 && (stack = this.outputItemToInv(stack, validOutputs[0][rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[0].length)])) != null) {
                    for (i = 0; i < validOutputs[0].length; ++i) {
                        if (i == rand || (stack = this.outputItemToInv(stack, validOutputs[0][i])) != null) {
                            continue;
                        }
                        break block6;
                    }
                }
                if (stack == null || validOutputs[1].length <= 0) break block7;
                rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[1].length);
                ForgeDirection fd = ForgeDirection.getOrientation((int)validOutputs[1][rand]);
                EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)fd.offsetX, (double)this.field_145848_d + 0.5 + (double)fd.offsetY, (double)this.field_145849_e + 0.5 + (double)fd.offsetZ, stack.func_77946_l());
                ei.field_70159_w = 0.075f * (float)fd.offsetX;
                ei.field_70181_x = 0.025000000372529;
                ei.field_70179_y = 0.075f * (float)fd.offsetZ;
                this.field_145850_b.func_72838_d((Entity)ei);
                break block6;
            }
            if (validOutputs[2].length > 0 && (stack = this.outputItemToInv(stack, validOutputs[2][rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[2].length)])) != null) {
                for (i = 0; i < validOutputs[2].length; ++i) {
                    if (i == rand || (stack = this.outputItemToInv(stack, validOutputs[2][rand])) != null) {
                        continue;
                    }
                    break block6;
                }
            }
            if (stack == null || validOutputs[3].length <= 0) break block6;
            rand = this.field_145850_b.field_73012_v.nextInt(validOutputs[3].length);
            ForgeDirection fd = ForgeDirection.getOrientation((int)validOutputs[1][rand]);
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)fd.offsetX, (double)this.field_145848_d + 0.5 + (double)fd.offsetY, (double)this.field_145849_e + 0.5 + (double)fd.offsetZ, stack.func_77946_l());
            ei.field_70159_w = 0.075f * (float)fd.offsetX;
            ei.field_70181_x = 0.025000000372529;
            ei.field_70179_y = 0.075f * (float)fd.offsetZ;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    public Integer[][] getValidOutputs(int inputSide, ItemStack stack, boolean allowUnmapped, boolean allowThrowing) {
        ArrayList<Integer> validFilteredInvOuts = new ArrayList<Integer>();
        ArrayList<Integer> validFilteredEntityOuts = new ArrayList<Integer>();
        ArrayList<Integer> validUnfilteredInvOuts = new ArrayList<Integer>();
        ArrayList<Integer> validUnfilteredEntityOuts = new ArrayList<Integer>();
        for (int side = 0; side < 6; ++side) {
            ForgeDirection fd;
            if (side == inputSide || this.sideFilter[side] != 0) continue;
            boolean unmapped = true;
            boolean allowed = false;
            block1: for (ItemStack filterStack : this.filter.filters[side]) {
                if (filterStack == null) continue;
                unmapped = false;
                if (this.oreDictFilter[side] == 0) {
                    for (int allowedOid : OreDictionary.getOreIDs((ItemStack)filterStack)) {
                        for (int oid : OreDictionary.getOreIDs((ItemStack)stack)) {
                            if (oid != allowedOid) continue;
                            allowed = true;
                            break block1;
                        }
                    }
                    continue;
                }
                if (!OreDictionary.itemMatches((ItemStack)filterStack, (ItemStack)stack, (boolean)true)) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                fd = ForgeDirection.getOrientation((int)side);
                TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
                if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side]) && Utils.canInsertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side])) {
                    validFilteredInvOuts.add(side);
                    continue;
                }
                if (!allowThrowing) continue;
                validFilteredEntityOuts.add(side);
                continue;
            }
            if (!allowUnmapped || !unmapped) continue;
            fd = ForgeDirection.getOrientation((int)side);
            TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
            if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side]) && Utils.canInsertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side])) {
                validUnfilteredInvOuts.add(side);
                continue;
            }
            if (!allowThrowing) continue;
            validUnfilteredEntityOuts.add(side);
        }
        return new Integer[][]{validFilteredInvOuts.toArray(new Integer[validFilteredInvOuts.size()]), validFilteredEntityOuts.toArray(new Integer[validFilteredEntityOuts.size()]), validUnfilteredInvOuts.toArray(new Integer[validUnfilteredInvOuts.size()]), validUnfilteredEntityOuts.toArray(new Integer[validUnfilteredEntityOuts.size()])};
    }

    public void outputItem(ItemStack stack, int side) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)side);
        TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
        if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side]) && Utils.canInsertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side])) {
            stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side]);
        }
        if (stack != null) {
            EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)fd.offsetX, (double)this.field_145848_d + 0.5 + (double)fd.offsetY, (double)this.field_145849_e + 0.5 + (double)fd.offsetZ, stack.func_77946_l());
            ei.field_70159_w = 0.075f * (float)fd.offsetX;
            ei.field_70181_x = 0.025000000372529;
            ei.field_70179_y = 0.075f * (float)fd.offsetZ;
            this.field_145850_b.func_72838_d((Entity)ei);
        }
    }

    public ItemStack outputItemToInv(ItemStack stack, int side) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)side);
        TileEntity inventory = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
        if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side])) {
            stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side]);
        }
        return stack;
    }

    boolean isInventory(TileEntity tile, int side) {
        if (tile instanceof ISidedInventory && ((ISidedInventory)tile).func_94128_d(side).length > 0) {
            return true;
        }
        return tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0;
    }

    public int func_70302_i_() {
        return 6;
    }

    public ItemStack func_70301_a(int slot) {
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.routeItem(slot, stack);
    }

    public String func_145825_b() {
        return "IERouter";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        Integer[][] outputs = this.getValidOutputs(slot, stack, true, false);
        return outputs[0].length > 0 || outputs[1].length > 0 || outputs[2].length > 0 || outputs[3].length > 0;
    }

    public int[] func_94128_d(int side) {
        return new int[]{side};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return side == slot;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideFilter = nbt.func_74759_k("sideFilter");
        if (!descPacket) {
            NBTTagList filterList = nbt.func_150295_c("filter", 10);
            this.filter = new SorterInventory(this);
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74783_a("sideFilter", this.sideFilter);
        if (!descPacket) {
            NBTTagList filterList = new NBTTagList();
            this.filter.writeToNBT(filterList);
            nbt.func_74782_a("filter", (NBTBase)filterList);
        }
    }

    public void toggleSide(int side) {
        int n = side;
        this.oreDictFilter[n] = this.oreDictFilter[n] + 1;
        if (this.oreDictFilter[side] > 0) {
            this.oreDictFilter[side] = -1;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean hammer) {
        if (hammer) {
            return new String[]{StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.blockSide." + ForgeDirection.getOrientation((int)mop.field_72310_e))), StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.oreDict." + (this.oreDictFilter[mop.field_72310_e] == -1 ? "off" : "on")))};
        }
        return null;
    }

    public static class SorterInventory
    implements IInventory {
        public ItemStack[][] filters = new ItemStack[6][8];
        final TileEntityConveyorSorter tile;

        public SorterInventory(TileEntityConveyorSorter tile) {
            this.tile = tile;
        }

        public int func_70302_i_() {
            return 48;
        }

        public ItemStack func_70301_a(int slot) {
            return this.filters[slot / 8][slot % 8];
        }

        public ItemStack func_70298_a(int slot, int amount) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                if (stack.field_77994_a <= amount) {
                    this.func_70299_a(slot, null);
                } else {
                    stack = stack.func_77979_a(amount);
                    if (stack.field_77994_a == 0) {
                        this.func_70299_a(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack func_70304_b(int slot) {
            ItemStack stack = this.func_70301_a(slot);
            if (stack != null) {
                this.func_70299_a(slot, null);
            }
            return stack;
        }

        public void func_70299_a(int slot, ItemStack stack) {
            this.filters[slot / 8][slot % 8] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }

        public String func_145825_b() {
            return "IESorterLayout";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer player) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack stack) {
            return true;
        }

        public void func_70296_d() {
            this.tile.func_70296_d();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    if (this.filters[i][j] == null) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.func_74774_a("Slot", (byte)(i * 8 + j));
                    this.filters[i][j].func_77955_b(itemTag);
                    list.func_74742_a((NBTBase)itemTag);
                }
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.filters[slot / 8][slot % 8] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
        }
    }
}

