/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.util.IESound;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import codechicken.lib.gui.GuiDraw;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class ClientUtils {
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static void renderAttachedConnections(TileEntity tile) {
        Set<ImmersiveNetHandler.Connection> outputs;
        if (tile.func_145831_w() != null && tile instanceof IImmersiveConnectable && (outputs = ImmersiveNetHandler.INSTANCE.getConnections(tile.func_145831_w(), Utils.toCC(tile))) != null) {
            for (ImmersiveNetHandler.Connection con : outputs) {
                TileEntity tileEnd = tile.func_145831_w().func_147438_o(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c);
                if (!(tileEnd instanceof IImmersiveConnectable)) continue;
                ClientUtils.drawConnection(con, (IImmersiveConnectable)tile, Utils.toIIC(tileEnd, tile.func_145831_w()), con.cableType.getIcon(con));
            }
        }
    }

    public static void drawConnection(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, IIcon icon) {
        if (connection == null || start == null || end == null) {
            return;
        }
        int col = connection.cableType.getColour(connection);
        double r = connection.cableType.getRenderDiameter() / 2.0;
        ClientUtils.drawConnection(connection, start, end, col, 255, r, icon);
    }

    public static void drawConnection(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, int colour, int alpha, double radius, IIcon icon) {
        boolean b;
        if (connection == null || start == null || end == null || connection.end == null || connection.start == null) {
            return;
        }
        Vec3 startOffset = start.getConnectionOffset(connection);
        Vec3 endOffset = end.getConnectionOffset(connection);
        if (startOffset == null) {
            startOffset = Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
        }
        if (endOffset == null) {
            endOffset = Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
        }
        double dx = (double)connection.end.field_71574_a + endOffset.field_72450_a - ((double)connection.start.field_71574_a + startOffset.field_72450_a);
        double dy = (double)connection.end.field_71572_b + endOffset.field_72448_b - ((double)connection.start.field_71572_b + startOffset.field_72448_b);
        double dz = (double)connection.end.field_71573_c + endOffset.field_72449_c - ((double)connection.start.field_71573_c + startOffset.field_72449_c);
        double dw = Math.sqrt(dx * dx + dz * dz);
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        World world = ((TileEntity)start).func_145831_w();
        Tessellator tes = ClientUtils.tes();
        double rmodx = dz / dw;
        double rmodz = dx / dw;
        Vec3[] vertex = connection.getSubVertices(world);
        Vec3 initPos = Vec3.func_72443_a((double)((double)connection.start.field_71574_a + startOffset.field_72450_a), (double)((double)connection.start.field_71572_b + startOffset.field_72448_b), (double)((double)connection.start.field_71573_c + startOffset.field_72449_c));
        double uMin = icon.func_94209_e();
        double uMax = icon.func_94212_f();
        double vMin = icon.func_94206_g();
        double vMax = icon.func_94210_h();
        double uD = uMax - uMin;
        boolean vertical = connection.end.field_71574_a == connection.start.field_71574_a && connection.end.field_71573_c == connection.start.field_71573_c;
        boolean bl = b = dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0;
        if (vertical) {
            tes.func_78372_c((float)initPos.field_72450_a, (float)initPos.field_72448_b, (float)initPos.field_72449_c);
            tes.func_78384_a(colour, alpha);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a - radius, connection.start.field_71572_b, connection.start.field_71573_c));
            tes.func_78374_a(0.0 - radius, 0.0, 0.0, uMin, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a - radius, (double)connection.start.field_71572_b + dy, connection.start.field_71573_c));
            tes.func_78374_a(dx - radius, dy, dz, uMax, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a + radius, (double)connection.start.field_71572_b + dy, connection.start.field_71573_c));
            tes.func_78374_a(dx + radius, dy, dz, uMax, vMax);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a + radius, connection.start.field_71572_b, connection.start.field_71573_c));
            tes.func_78374_a(0.0 + radius, 0.0, 0.0, uMin, vMax);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a - radius, (double)connection.start.field_71572_b + dy, connection.start.field_71573_c));
            tes.func_78374_a(dx - radius, dy, dz, uMax, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a - radius, connection.start.field_71572_b, connection.start.field_71573_c));
            tes.func_78374_a(0.0 - radius, 0.0, 0.0, uMin, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a + radius, connection.start.field_71572_b, connection.start.field_71573_c));
            tes.func_78374_a(0.0 + radius, 0.0, 0.0, uMin, vMax);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.field_71574_a + radius, (double)connection.start.field_71572_b + dy, connection.start.field_71573_c));
            tes.func_78374_a(dx + radius, dy, dz, uMax, vMax);
            tes.func_78384_a(colour, alpha);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, connection.start.field_71572_b, (double)connection.start.field_71573_c - radius));
            tes.func_78374_a(0.0, 0.0, 0.0 - radius, uMin, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, (double)connection.start.field_71572_b + dy, (double)connection.start.field_71573_c - radius));
            tes.func_78374_a(dx, dy, dz - radius, uMax, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, (double)connection.start.field_71572_b + dy, (double)connection.start.field_71573_c + radius));
            tes.func_78374_a(dx, dy, dz + radius, uMax, vMax);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, connection.start.field_71572_b, (double)connection.start.field_71573_c + radius));
            tes.func_78374_a(0.0, 0.0, 0.0 + radius, uMin, vMax);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, (double)connection.start.field_71572_b + dy, (double)connection.start.field_71573_c - radius));
            tes.func_78374_a(dx, dy, dz - radius, uMax, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, connection.start.field_71572_b, (double)connection.start.field_71573_c - radius));
            tes.func_78374_a(0.0, 0.0, 0.0 - radius, uMin, vMin);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, connection.start.field_71572_b, (double)connection.start.field_71573_c + radius));
            tes.func_78374_a(0.0, 0.0, 0.0 + radius, uMin, vMax);
            tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.field_71574_a, (double)connection.start.field_71572_b + dy, (double)connection.start.field_71573_c + radius));
            tes.func_78374_a(dx, dy, dz + radius, uMax, vMax);
            tes.func_78372_c((float)(-initPos.field_72450_a), (float)(-initPos.field_72448_b), (float)(-initPos.field_72449_c));
        } else {
            int i;
            double u0 = uMin;
            double u1 = uMin;
            int n = i = b ? vertex.length - 1 : 0;
            while (b ? i >= 0 : i < vertex.length) {
                Vec3 v0 = i > 0 ? vertex[i - 1] : initPos;
                Vec3 v1 = vertex[i];
                u0 = u1;
                u1 = u0 + v0.func_72438_d(v1) / d * uD;
                if (dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0) {
                    u1 = uMin;
                    u0 = uMax;
                }
                tes.func_78384_a(colour, alpha);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c));
                tes.func_78374_a(v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c, u0, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c));
                tes.func_78374_a(v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c, u1, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c));
                tes.func_78374_a(v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c, u1, vMin);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c));
                tes.func_78374_a(v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c, u0, vMin);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c));
                tes.func_78374_a(v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c, u1, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c));
                tes.func_78374_a(v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c, u0, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c));
                tes.func_78374_a(v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c, u0, vMin);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c));
                tes.func_78374_a(v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c, u1, vMin);
                tes.func_78384_a(colour, alpha);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz));
                tes.func_78374_a(v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz, u0, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz));
                tes.func_78374_a(v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz, u1, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz));
                tes.func_78374_a(v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz, u1, vMin);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz));
                tes.func_78374_a(v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz, u0, vMin);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz));
                tes.func_78374_a(v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz, u1, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz));
                tes.func_78374_a(v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz, u0, vMax);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz));
                tes.func_78374_a(v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz, u0, vMin);
                tes.func_78380_c(ClientUtils.calcBrightness((IBlockAccess)world, v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz));
                tes.func_78374_a(v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz, u1, vMin);
                i += b ? -1 : 1;
            }
        }
        tes.func_78384_a(0xFFFFFF, 255);
    }

    public static int calcBrightness(IBlockAccess world, double x, double y, double z) {
        return world.func_72802_i((int)Math.round(x), (int)Math.round(y), (int)Math.round(z), 0);
    }

    public static void tessellateBox(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, IIcon icon) {
        ClientUtils.tes().func_78374_a(xMin, yMin, zMax, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(zMax * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMin, zMin, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(zMin * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMin, zMin, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(zMin * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMin, zMax, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(zMax * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMax, zMin, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(zMin * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMax, zMax, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(zMax * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMax, zMax, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(zMax * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMax, zMin, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(zMin * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMin, zMin, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMin, zMin, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMax, zMin, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMax, zMin, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMin, zMax, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMin, zMax, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMax, zMax, (double)icon.func_94214_a(xMin * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMax, zMax, (double)icon.func_94214_a(xMax * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMin, zMin, (double)icon.func_94214_a(zMin * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMin, zMax, (double)icon.func_94214_a(zMax * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMax, zMax, (double)icon.func_94214_a(zMax * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMin, yMax, zMin, (double)icon.func_94214_a(zMin * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMin, zMax, (double)icon.func_94214_a(zMax * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMin, zMin, (double)icon.func_94214_a(zMin * 16.0), (double)icon.func_94207_b(yMax * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMax, zMin, (double)icon.func_94214_a(zMin * 16.0), (double)icon.func_94207_b(yMin * 16.0));
        ClientUtils.tes().func_78374_a(xMax, yMax, zMax, (double)icon.func_94214_a(zMax * 16.0), (double)icon.func_94207_b(yMin * 16.0));
    }

    public static Tessellator tes() {
        return Tessellator.field_78398_a;
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(String path) {
        ClientUtils.mc().func_110434_K().func_110577_a(ClientUtils.getResource(path));
    }

    public static void bindAtlas(int i) {
        ClientUtils.mc().func_110434_K().func_110577_a(i == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static WavefrontObject getModel(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)rl);
    }

    public static FontRenderer font() {
        return ClientUtils.mc().field_71466_p;
    }

    public static String getResourceNameForItemStack(ItemStack stack) {
        if (stack != null) {
            IIcon ic = null;
            Block b = Block.func_149634_a((Item)stack.func_77973_b());
            ic = b != null && b != Blocks.field_150350_a ? b.func_149691_a(2, stack.func_77960_j()) : stack.func_77954_c();
            if (ic != null) {
                String name = ic.func_94215_i();
                String resource = "";
                String icon = "";
                if (name.indexOf(":") > 0) {
                    String[] split = name.split(":", 2);
                    resource = split[0] + ":";
                    icon = split[1];
                } else {
                    icon = name;
                }
                return resource + "textures/" + (stack.func_94608_d() == 0 ? "blocks" : "items") + "/" + icon + ".png";
            }
        }
        return "";
    }

    public static IESound generatePositionedIESound(String soundName, float volume, float pitch, boolean repeat, int delay, double x, double y, double z) {
        IESound sound = new IESound(new ResourceLocation(soundName), volume, pitch, repeat, delay, x, y, z, ISound.AttenuationType.LINEAR);
        sound.evaluateVolume();
        ClientUtils.mc().func_147118_V().func_147682_a((ISound)sound);
        return sound;
    }

    public static void handleStaticTileRenderer(TileEntity tile) {
        ClientUtils.handleStaticTileRenderer(tile, true);
    }

    public static void handleStaticTileRenderer(TileEntity tile, boolean translate) {
        TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile);
        if (tesr instanceof TileRenderIE) {
            Matrix4 matrixT = new Matrix4();
            if (translate) {
                matrixT.translate(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            }
            ((TileRenderIE)tesr).renderStatic(tile, Tessellator.field_78398_a, matrixT, new Matrix4());
        }
    }

    public static void renderStaticWavefrontModel(TileEntity tile, WavefrontObject model, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, int offsetLighting, boolean invertFaces, String ... renderedParts) {
        if (tile.func_145831_w() != null) {
            int lb = tile.func_145831_w().func_72802_i(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 0);
            int lb_j = lb % 65536;
            int lb_k = lb / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lb_j / 1.0f), (float)((float)lb_k / 1.0f));
        }
        Vertex vertexCopy = new Vertex(0.0f, 0.0f, 0.0f);
        Vertex normalCopy = new Vertex(0.0f, 0.0f, 0.0f);
        for (GroupObject groupObject : model.groupObjects) {
            boolean render = false;
            if (renderedParts == null || renderedParts.length < 1) {
                render = true;
            } else {
                for (String s : renderedParts) {
                    if (!groupObject.name.equalsIgnoreCase(s)) continue;
                    render = true;
                }
            }
            if (!render) continue;
            for (Face face : groupObject.faces) {
                if (face.faceNormal == null) {
                    face.faceNormal = face.calculateFaceNormal();
                }
                normalCopy.x = face.faceNormal.x;
                normalCopy.y = face.faceNormal.y;
                normalCopy.z = face.faceNormal.z;
                rotationMatrix.apply(normalCopy);
                float biggestNormal = Math.max(Math.abs(normalCopy.y), Math.max(Math.abs(normalCopy.x), Math.abs(normalCopy.z)));
                int side = biggestNormal == Math.abs(normalCopy.y) ? (normalCopy.y < 0.0f ? 0 : 1) : (biggestNormal == Math.abs(normalCopy.z) ? (normalCopy.z < 0.0f ? 2 : 3) : (normalCopy.x < 0.0f ? 4 : 5));
                HashMap<String, BlockLightingInfo> light = new HashMap<String, BlockLightingInfo>();
                BlockLightingInfo completeLight = null;
                if (offsetLighting == 0 && tile.func_145831_w() != null) {
                    completeLight = ClientUtils.calculateBlockLighting(side, (IBlockAccess)tile.func_145831_w(), tile.func_145838_q(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, 1.0f, 1.0f, 1.0f);
                }
                tes.func_78375_b(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
                for (int i = 0; i < face.vertices.length; ++i) {
                    int target = !invertFaces ? i : face.vertices.length - 1 - i;
                    int corner = (int)((float)target / (float)face.vertices.length * 4.0f);
                    Vertex vertex = face.vertices[target];
                    vertexCopy.x = vertex.x;
                    vertexCopy.y = vertex.y;
                    vertexCopy.z = vertex.z;
                    rotationMatrix.apply(vertexCopy);
                    translationMatrix.apply(vertexCopy);
                    if (offsetLighting == 1 && tile.func_145831_w() != null) {
                        float g;
                        float r;
                        String key = Math.round((float)tile.field_145851_c + vertex.x) + ";" + Math.round((float)tile.field_145848_d + vertex.y) + ";" + Math.round((float)tile.field_145849_e + vertex.z);
                        BlockLightingInfo info = (BlockLightingInfo)light.get(key);
                        if (info == null) {
                            info = ClientUtils.calculateBlockLighting(side, (IBlockAccess)tile.func_145831_w(), tile.func_145838_q(), Math.round((float)tile.field_145851_c + vertex.x), Math.round((float)tile.field_145848_d + vertex.y), Math.round((float)tile.field_145849_e + vertex.z), 1.0f, 1.0f, 1.0f);
                            light.put(key, info);
                        }
                        tes.func_78380_c(corner == 0 ? info.brightnessTopLeft : (corner == 1 ? info.brightnessBottomLeft : (corner == 2 ? info.brightnessBottomRight : info.brightnessTopRight)));
                        float f = corner == 0 ? info.colorRedTopLeft : (corner == 1 ? info.colorRedBottomLeft : (r = corner == 2 ? info.colorRedBottomRight : info.colorRedTopRight));
                        float f2 = corner == 0 ? info.colorGreenTopLeft : (corner == 1 ? info.colorGreenBottomLeft : (g = corner == 2 ? info.colorGreenBottomRight : info.colorGreenTopRight));
                        float b = corner == 0 ? info.colorBlueTopLeft : (corner == 1 ? info.colorBlueBottomLeft : (corner == 2 ? info.colorBlueBottomRight : info.colorBlueTopRight));
                        tes.func_78386_a(r, g, b);
                    } else if (offsetLighting == 0 && tile.func_145831_w() != null && completeLight != null) {
                        float g;
                        float r;
                        tes.func_78380_c(corner == 0 ? completeLight.brightnessTopLeft : (corner == 1 ? completeLight.brightnessBottomLeft : (corner == 2 ? completeLight.brightnessBottomRight : completeLight.brightnessTopRight)));
                        float f = corner == 0 ? completeLight.colorRedTopLeft : (corner == 1 ? completeLight.colorRedBottomLeft : (r = corner == 2 ? completeLight.colorRedBottomRight : completeLight.colorRedTopRight));
                        float f3 = corner == 0 ? completeLight.colorGreenTopLeft : (corner == 1 ? completeLight.colorGreenBottomLeft : (g = corner == 2 ? completeLight.colorGreenBottomRight : completeLight.colorGreenTopRight));
                        float b = corner == 0 ? completeLight.colorBlueTopLeft : (corner == 1 ? completeLight.colorBlueBottomLeft : (corner == 2 ? completeLight.colorBlueBottomRight : completeLight.colorBlueTopRight));
                        tes.func_78386_a(r, g, b);
                    }
                    if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                        TextureCoordinate textureCoordinate = face.textureCoordinates[target];
                        tes.func_78374_a((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z, (double)textureCoordinate.u, (double)textureCoordinate.v);
                        continue;
                    }
                    tes.func_78377_a((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z);
                }
            }
        }
    }

    public static void renderWavefrontModelWithModifications(WavefrontObject model, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, boolean flipTextureU, String ... renderedParts) {
        Vertex vertexCopy = new Vertex(0.0f, 0.0f, 0.0f);
        Vertex normalCopy = new Vertex(0.0f, 0.0f, 0.0f);
        for (GroupObject groupObject : model.groupObjects) {
            boolean render = false;
            if (renderedParts == null || renderedParts.length < 1) {
                render = true;
            } else {
                for (String s : renderedParts) {
                    if (!groupObject.name.equalsIgnoreCase(s)) continue;
                    render = true;
                }
            }
            if (!render) continue;
            for (Face face : groupObject.faces) {
                if (face.faceNormal == null) {
                    face.faceNormal = face.calculateFaceNormal();
                }
                normalCopy.x = face.faceNormal.x;
                normalCopy.y = face.faceNormal.y;
                normalCopy.z = face.faceNormal.z;
                rotationMatrix.apply(normalCopy);
                tes.func_78375_b(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
                for (int i = 0; i < face.vertices.length; ++i) {
                    Vertex vertex = face.vertices[i];
                    vertexCopy.x = vertex.x;
                    vertexCopy.y = vertex.y;
                    vertexCopy.z = vertex.z;
                    rotationMatrix.apply(vertexCopy);
                    translationMatrix.apply(vertexCopy);
                    if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                        TextureCoordinate textureCoordinate = face.textureCoordinates[flipTextureU ? face.textureCoordinates.length - 1 - i : i];
                        tes.func_78374_a((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z, (double)textureCoordinate.u, (double)textureCoordinate.v);
                        continue;
                    }
                    tes.func_78377_a((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z);
                }
            }
        }
    }

    public static void renderWavefrontWithIconUVs(WavefrontObject model, IIcon icon, String ... parts) {
        ClientUtils.renderWavefrontWithIconUVs(model, 7, icon, parts);
        ClientUtils.renderWavefrontWithIconUVs(model, 4, icon, parts);
    }

    public static void renderWavefrontWithIconUVs(WavefrontObject model, int glDrawingMode, IIcon icon, String ... parts) {
        if (icon == null) {
            return;
        }
        List<String> renderParts = Arrays.asList(parts);
        ClientUtils.tes().func_78371_b(glDrawingMode);
        for (GroupObject go : model.groupObjects) {
            if (go.glDrawingMode != glDrawingMode || !renderParts.contains(go.name)) continue;
            ClientUtils.tessellateWavefrontGroupObjectWithIconUVs(go, icon);
        }
        ClientUtils.tes().func_78381_a();
    }

    public static void tessellateWavefrontGroupObjectWithIconUVs(GroupObject object, IIcon icon) {
        if (icon == null) {
            return;
        }
        float minU = icon.func_94214_a(0.0);
        float sizeU = icon.func_94214_a(16.0) - minU;
        float minV = icon.func_94207_b(0.0);
        float sizeV = icon.func_94207_b(16.0) - minV;
        float baseOffsetU = 16.0f / (float)icon.func_94211_a() * 5.0E-4f;
        float baseOffsetV = 16.0f / (float)icon.func_94216_b() * 5.0E-4f;
        for (Face face : object.faces) {
            int v;
            float averageU = 0.0f;
            float averageV = 0.0f;
            if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                for (int i = 0; i < face.textureCoordinates.length; ++i) {
                    averageU += face.textureCoordinates[i].u;
                    averageV += face.textureCoordinates[i].v;
                }
                averageU /= (float)face.textureCoordinates.length;
                averageV /= (float)face.textureCoordinates.length;
            }
            TextureCoordinate[] oldUVs = new TextureCoordinate[face.textureCoordinates.length];
            for (v = 0; v < face.vertices.length; ++v) {
                float offsetU = baseOffsetU;
                float offsetV = baseOffsetV;
                if (face.textureCoordinates[v].u > averageU) {
                    offsetU = -offsetU;
                }
                if (face.textureCoordinates[v].v > averageV) {
                    offsetV = -offsetV;
                }
                oldUVs[v] = face.textureCoordinates[v];
                TextureCoordinate textureCoordinate = face.textureCoordinates[v];
                face.textureCoordinates[v] = new TextureCoordinate(minU + sizeU * (textureCoordinate.u + offsetU), minV + sizeV * (textureCoordinate.v + offsetV));
            }
            face.addFaceForRender(ClientUtils.tes(), 0.0f);
            for (v = 0; v < face.vertices.length; ++v) {
                face.textureCoordinates[v] = new TextureCoordinate(oldUVs[v].u, oldUVs[v].v);
            }
        }
    }

    public static void renderItemIn2D(IIcon icon, double[] uv, int width, int height, float depth) {
        double f9;
        double f8;
        double f7;
        int k;
        double uMin = icon.func_94214_a(uv[0] * 16.0);
        double uMax = icon.func_94214_a(uv[1] * 16.0);
        double vMin = icon.func_94207_b(uv[2] * 16.0);
        double vMax = icon.func_94207_b(uv[3] * 16.0);
        double w = (double)width / 16.0 / 2.0;
        double h = (double)height / 16.0;
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78375_b(0.0f, 0.0f, 1.0f);
        ClientUtils.tes().func_78374_a(-w, 0.0, 0.0, uMin, vMax);
        ClientUtils.tes().func_78374_a(w, 0.0, 0.0, uMax, vMax);
        ClientUtils.tes().func_78374_a(w, h, 0.0, uMax, vMin);
        ClientUtils.tes().func_78374_a(-w, h, 0.0, uMin, vMin);
        ClientUtils.tes().func_78381_a();
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78375_b(0.0f, 0.0f, -1.0f);
        ClientUtils.tes().func_78374_a(-w, h, (double)(0.0f - depth), uMin, vMin);
        ClientUtils.tes().func_78374_a(w, h, (double)(0.0f - depth), uMax, vMin);
        ClientUtils.tes().func_78374_a(w, 0.0, (double)(0.0f - depth), uMax, vMax);
        ClientUtils.tes().func_78374_a(-w, 0.0, (double)(0.0f - depth), uMin, vMax);
        ClientUtils.tes().func_78381_a();
        double f5 = 0.5 * (uMin - uMax) / (double)width;
        double f6 = 0.5 * (vMax - vMin) / (double)height;
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (double)k / (double)width;
            f8 = uMin + (uMax - uMin) * f7 - f5;
            f9 = (double)k / (double)icon.func_94211_a();
            ClientUtils.tes().func_78374_a(-w + f9, 0.0, (double)(-depth), f8, vMax);
            ClientUtils.tes().func_78374_a(-w + f9, 0.0, 0.0, f8, vMax);
            ClientUtils.tes().func_78374_a(-w + f9, h, 0.0, f8, vMin);
            ClientUtils.tes().func_78374_a(-w + f9, h, (double)(-depth), f8, vMin);
        }
        ClientUtils.tes().func_78381_a();
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78375_b(1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (double)k / (double)width;
            f8 = uMin + (uMax - uMin) * f7 - f5;
            f9 = (double)(k + 1) / (double)icon.func_94211_a();
            ClientUtils.tes().func_78374_a(-w + f9, h, (double)(-depth), f8, vMin);
            ClientUtils.tes().func_78374_a(-w + f9, h, 0.0, f8, vMin);
            ClientUtils.tes().func_78374_a(-w + f9, 0.0, 0.0, f8, vMax);
            ClientUtils.tes().func_78374_a(-w + f9, 0.0, (double)(-depth), f8, vMax);
        }
        ClientUtils.tes().func_78381_a();
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (double)k / (double)height;
            f8 = vMax + (vMin - vMax) * f7 - f6;
            f9 = (double)(k + 1) / (double)icon.func_94216_b();
            ClientUtils.tes().func_78374_a(-w, f9, 0.0, uMin, f8);
            ClientUtils.tes().func_78374_a(w, f9, 0.0, uMax, f8);
            ClientUtils.tes().func_78374_a(w, f9, (double)(-depth), uMax, f8);
            ClientUtils.tes().func_78374_a(-w, f9, (double)(-depth), uMin, f8);
        }
        ClientUtils.tes().func_78381_a();
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78375_b(0.0f, -1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (double)k / (double)height;
            f8 = vMax + (vMin - vMax) * f7 - f6;
            f9 = (double)k / (double)icon.func_94216_b();
            ClientUtils.tes().func_78374_a(w, f9, 0.0, uMax, f8);
            ClientUtils.tes().func_78374_a(-w, f9, 0.0, uMin, f8);
            ClientUtils.tes().func_78374_a(-w, f9, (double)(-depth), uMin, f8);
            ClientUtils.tes().func_78374_a(w, f9, (double)(-depth), uMax, f8);
        }
        ClientUtils.tes().func_78381_a();
    }

    public static void drawInventoryBlock(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tes = ClientUtils.tes();
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tes.func_78382_b();
        tes.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.field_147840_d != null ? renderer.field_147840_d : renderer.func_147787_a(block, 0, metadata));
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.field_147840_d != null ? renderer.field_147840_d : renderer.func_147787_a(block, 1, metadata));
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.field_147840_d != null ? renderer.field_147840_d : renderer.func_147787_a(block, 2, metadata));
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.field_147840_d != null ? renderer.field_147840_d : renderer.func_147787_a(block, 3, metadata));
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.field_147840_d != null ? renderer.field_147840_d : renderer.func_147787_a(block, 4, metadata));
        tes.func_78381_a();
        tes.func_78382_b();
        tes.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.field_147840_d != null ? renderer.field_147840_d : renderer.func_147787_a(block, 5, metadata));
        tes.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void drawColouredRect(int x, int y, int w, int h, int colour) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78384_a(colour, colour >> 24 & 0xFF);
        ClientUtils.tes().func_78377_a((double)x, (double)(y + h), 0.0);
        ClientUtils.tes().func_78377_a((double)(x + w), (double)(y + h), 0.0);
        ClientUtils.tes().func_78377_a((double)(x + w), (double)y, 0.0);
        ClientUtils.tes().func_78377_a((double)x, (double)y, 0.0);
        ClientUtils.tes().func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawGradientRect(int x0, int y0, int x1, int y1, int colour0, int colour1) {
        float f = (float)(colour0 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colour0 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour0 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour0 & 0xFF) / 255.0f;
        float f4 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)x1, (double)y0, 0.0);
        tessellator.func_78377_a((double)x0, (double)y0, 0.0);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)x0, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedRect(float x, float y, float w, float h, double ... uv) {
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78374_a((double)x, (double)(y + h), 0.0, uv[0], uv[3]);
        ClientUtils.tes().func_78374_a((double)(x + w), (double)(y + h), 0.0, uv[1], uv[3]);
        ClientUtils.tes().func_78374_a((double)(x + w), (double)y, 0.0, uv[1], uv[2]);
        ClientUtils.tes().func_78374_a((double)x, (double)y, 0.0, uv[0], uv[2]);
        ClientUtils.tes().func_78381_a();
    }

    public static void drawTexturedRect(int x, int y, int w, int h, float picSize, int ... uv) {
        double[] d_uv = new double[]{(float)uv[0] / picSize, (float)uv[1] / picSize, (float)uv[2] / picSize, (float)uv[3] / picSize};
        ClientUtils.drawTexturedRect((float)x, (float)y, (float)w, (float)h, d_uv);
    }

    public static void drawRepeatedFluidIcon(Fluid fluid, float x, float y, float w, float h) {
        ClientUtils.bindTexture(TextureMap.field_110575_b.toString());
        IIcon icon = fluid.getIcon();
        if (icon != null) {
            int iW = icon.func_94211_a();
            int iH = icon.func_94216_b();
            if (iW > 0 && iH > 0) {
                ClientUtils.drawRepeatedIcon(x, y, w, h, iW, iH, icon.func_94209_e(), icon.func_94212_f(), icon.func_94206_g(), icon.func_94210_h());
            }
        }
    }

    public static void drawRepeatedIcon(float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), (float)iconWidth, (float)iconHeight, uMin, uMax, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), (float)iconWidth, leftoverH, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, (float)iconHeight, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h) {
        ClientUtils.drawSlot(x, y, w, h, 255);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha) {
        GuiDraw.drawRect((int)(x + 8 - w / 2), (int)(y + 8 - h / 2 - 1), (int)w, (int)1, (int)((alpha << 24) + 0x373737));
        GuiDraw.drawRect((int)(x + 8 - w / 2 - 1), (int)(y + 8 - h / 2 - 1), (int)1, (int)(h + 1), (int)((alpha << 24) + 0x373737));
        GuiDraw.drawRect((int)(x + 8 - w / 2), (int)(y + 8 - h / 2), (int)w, (int)h, (int)((alpha << 24) + 0x8B8B8B));
        GuiDraw.drawRect((int)(x + 8 - w / 2), (int)(y + 8 + h / 2), (int)(w + 1), (int)1, (int)((alpha << 24) + 0xFFFFFF));
        GuiDraw.drawRect((int)(x + 8 + w / 2), (int)(y + 8 - h / 2), (int)1, (int)h, (int)((alpha << 24) + 0xFFFFFF));
    }

    public static void renderToolTip(ItemStack stack, int x, int y) {
        List list = stack.func_82840_a((EntityPlayer)ClientUtils.mc().field_71439_g, ClientUtils.mc().field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        ClientUtils.drawHoveringText(list, x, y, font == null ? ClientUtils.font() : font);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer font) {
        ClientUtils.drawHoveringText(list, x, y, font, -1, -1);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer font, int xSize, int ySize) {
        if (!list.isEmpty()) {
            boolean uni = ClientUtils.font().func_82883_a();
            ClientUtils.font().func_78264_a(false);
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            boolean shift = false;
            if (xSize > 0 && j2 + k > xSize) {
                j2 -= 28 + k;
                shift = true;
            }
            if (ySize > 0 && k2 + i1 + 6 > ySize) {
                k2 = ySize - i1 - 6;
                shift = true;
            }
            if (!shift && ClientUtils.mc().field_71462_r != null) {
                if (j2 + k > ClientUtils.mc().field_71462_r.field_146294_l) {
                    j2 -= 28 + k;
                }
                if (k2 + i1 + 6 > ClientUtils.mc().field_71462_r.field_146295_m) {
                    k2 = ClientUtils.mc().field_71462_r.field_146295_m - i1 - 6;
                }
            }
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            int j1 = -267386864;
            ClientUtils.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            ClientUtils.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            ClientUtils.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            ClientUtils.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            ClientUtils.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            ClientUtils.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = list.get(i2);
                font.func_78261_a(s1, j2, k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
            ClientUtils.font().func_78264_a(uni);
        }
    }

    public static void handleGuiTank(FluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, ArrayList<String> tooltip) {
        if (tooltip == null) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() != null) {
                int fluidHeight = (int)((float)h * ((float)tank.getFluid().amount / (float)tank.getCapacity()));
                ClientUtils.drawRepeatedFluidIcon(tank.getFluid().getFluid(), x, y + h - fluidHeight, w, fluidHeight);
                ClientUtils.bindTexture(originalTexture);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            ClientUtils.drawTexturedRect(x + xOff, y + yOff, oW, oH, 256.0f, oX, oX + oW, oY, oY + oH);
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() != null) {
                tooltip.add(tank.getFluid().getLocalizedName());
            } else {
                tooltip.add(StatCollector.func_74838_a((String)"gui.ImmersiveEngineering.empty"));
            }
            tooltip.add(tank.getFluidAmount() + "/" + tank.getCapacity() + "mB");
        }
    }

    public static BlockLightingInfo calculateBlockLighting(int side, IBlockAccess world, Block block, int x, int y, int z, float colR, float colG, float colB) {
        int i2;
        int l1;
        int k1;
        int j1;
        float f11;
        float f10;
        float f9;
        float f8;
        float f7;
        int i1;
        boolean flag5;
        boolean flag4;
        boolean flag3;
        boolean flag2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int l = block.func_149677_c(world, x, y, z);
        BlockLightingInfo lightingInfo = new BlockLightingInfo();
        if (side == 0) {
            lightingInfo.aoBrightnessXYNN = block.func_149677_c(world, x - 1, y, z);
            lightingInfo.aoBrightnessYZNN = block.func_149677_c(world, x, y, z - 1);
            lightingInfo.aoBrightnessYZNP = block.func_149677_c(world, x, y, z + 1);
            lightingInfo.aoBrightnessXYPN = block.func_149677_c(world, x + 1, y, z);
            lightingInfo.aoLightValueScratchXYNN = world.func_147439_a(x - 1, y, z).func_149685_I();
            lightingInfo.aoLightValueScratchYZNN = world.func_147439_a(x, y, z - 1).func_149685_I();
            lightingInfo.aoLightValueScratchYZNP = world.func_147439_a(x, y, z + 1).func_149685_I();
            lightingInfo.aoLightValueScratchXYPN = world.func_147439_a(x + 1, y, z).func_149685_I();
            flag2 = world.func_147439_a(x + 1, y - 1, z).func_149751_l();
            flag3 = world.func_147439_a(x - 1, y - 1, z).func_149751_l();
            flag4 = world.func_147439_a(x, y - 1, z + 1).func_149751_l();
            flag5 = world.func_147439_a(x, y - 1, z - 1).func_149751_l();
            if (!flag5 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNN = lightingInfo.aoLightValueScratchXYNN;
                lightingInfo.aoBrightnessXYZNNN = lightingInfo.aoBrightnessXYNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNN = world.func_147439_a(x - 1, y, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNNN = block.func_149677_c(world, x - 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNP = lightingInfo.aoLightValueScratchXYNN;
                lightingInfo.aoBrightnessXYZNNP = lightingInfo.aoBrightnessXYNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNP = world.func_147439_a(x - 1, y, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNNP = block.func_149677_c(world, x - 1, y, z + 1);
            }
            if (!flag5 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPNN = lightingInfo.aoLightValueScratchXYPN;
                lightingInfo.aoBrightnessXYZPNN = lightingInfo.aoBrightnessXYPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNN = world.func_147439_a(x + 1, y, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPNN = block.func_149677_c(world, x + 1, y, z - 1);
            }
            if (!flag4 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPNP = lightingInfo.aoLightValueScratchXYPN;
                lightingInfo.aoBrightnessXYZPNP = lightingInfo.aoBrightnessXYPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNP = world.func_147439_a(x + 1, y, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPNP = block.func_149677_c(world, x + 1, y, z + 1);
            }
            if (RenderBlocks.getInstance().field_147855_j <= 0.0) {
                ++y;
            }
            i1 = l;
            if (RenderBlocks.getInstance().field_147855_j <= 0.0 || !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                i1 = block.func_149677_c(world, x, y - 1, z);
            }
            f7 = world.func_147439_a(x, y - 1, z).func_149685_I();
            f3 = (lightingInfo.aoLightValueScratchXYZNNP + lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchYZNP + f7) / 4.0f;
            f6 = (lightingInfo.aoLightValueScratchYZNP + f7 + lightingInfo.aoLightValueScratchXYZPNP + lightingInfo.aoLightValueScratchXYPN) / 4.0f;
            f5 = (f7 + lightingInfo.aoLightValueScratchYZNN + lightingInfo.aoLightValueScratchXYPN + lightingInfo.aoLightValueScratchXYZPNN) / 4.0f;
            f4 = (lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchXYZNNN + f7 + lightingInfo.aoLightValueScratchYZNN) / 4.0f;
            lightingInfo.brightnessTopLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNP, lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessYZNP, i1);
            lightingInfo.brightnessTopRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNP, lightingInfo.aoBrightnessXYZPNP, lightingInfo.aoBrightnessXYPN, i1);
            lightingInfo.brightnessBottomRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNN, lightingInfo.aoBrightnessXYPN, lightingInfo.aoBrightnessXYZPNN, i1);
            lightingInfo.brightnessBottomLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessXYZNNN, lightingInfo.aoBrightnessYZNN, i1);
            lightingInfo.colorRedTopRight = 0.5f;
            lightingInfo.colorRedBottomRight = 0.5f;
            lightingInfo.colorRedBottomLeft = 0.5f;
            lightingInfo.colorRedTopLeft = 0.5f;
            lightingInfo.colorGreenTopRight = 0.5f;
            lightingInfo.colorGreenBottomRight = 0.5f;
            lightingInfo.colorGreenBottomLeft = 0.5f;
            lightingInfo.colorGreenTopLeft = 0.5f;
            lightingInfo.colorBlueTopRight = 0.5f;
            lightingInfo.colorBlueBottomRight = 0.5f;
            lightingInfo.colorBlueBottomLeft = 0.5f;
            lightingInfo.colorBlueTopLeft = 0.5f;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 1) {
            lightingInfo.aoBrightnessXYNP = block.func_149677_c(world, x - 1, y, z);
            lightingInfo.aoBrightnessXYPP = block.func_149677_c(world, x + 1, y, z);
            lightingInfo.aoBrightnessYZPN = block.func_149677_c(world, x, y, z - 1);
            lightingInfo.aoBrightnessYZPP = block.func_149677_c(world, x, y, z + 1);
            lightingInfo.aoLightValueScratchXYNP = world.func_147439_a(x - 1, y, z).func_149685_I();
            lightingInfo.aoLightValueScratchXYPP = world.func_147439_a(x + 1, y, z).func_149685_I();
            lightingInfo.aoLightValueScratchYZPN = world.func_147439_a(x, y, z - 1).func_149685_I();
            lightingInfo.aoLightValueScratchYZPP = world.func_147439_a(x, y, z + 1).func_149685_I();
            flag2 = world.func_147439_a(x + 1, y + 1, z).func_149751_l();
            flag3 = world.func_147439_a(x - 1, y + 1, z).func_149751_l();
            flag4 = world.func_147439_a(x, y + 1, z + 1).func_149751_l();
            flag5 = world.func_147439_a(x, y + 1, z - 1).func_149751_l();
            if (!flag5 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNPN = lightingInfo.aoLightValueScratchXYNP;
                lightingInfo.aoBrightnessXYZNPN = lightingInfo.aoBrightnessXYNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPN = world.func_147439_a(x - 1, y, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNPN = block.func_149677_c(world, x - 1, y, z - 1);
            }
            if (!flag5 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPPN = lightingInfo.aoLightValueScratchXYPP;
                lightingInfo.aoBrightnessXYZPPN = lightingInfo.aoBrightnessXYPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPN = world.func_147439_a(x + 1, y, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPPN = block.func_149677_c(world, x + 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNPP = lightingInfo.aoLightValueScratchXYNP;
                lightingInfo.aoBrightnessXYZNPP = lightingInfo.aoBrightnessXYNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPP = world.func_147439_a(x - 1, y, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNPP = block.func_149677_c(world, x - 1, y, z + 1);
            }
            if (!flag4 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPPP = lightingInfo.aoLightValueScratchXYPP;
                lightingInfo.aoBrightnessXYZPPP = lightingInfo.aoBrightnessXYPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPP = world.func_147439_a(x + 1, y, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPPP = block.func_149677_c(world, x + 1, y, z + 1);
            }
            if (RenderBlocks.getInstance().field_147857_k >= 1.0) {
                --y;
            }
            i1 = l;
            if (RenderBlocks.getInstance().field_147857_k >= 1.0 || !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                i1 = block.func_149677_c(world, x, y + 1, z);
            }
            f7 = world.func_147439_a(x, y + 1, z).func_149685_I();
            f6 = (lightingInfo.aoLightValueScratchXYZNPP + lightingInfo.aoLightValueScratchXYNP + lightingInfo.aoLightValueScratchYZPP + f7) / 4.0f;
            f3 = (lightingInfo.aoLightValueScratchYZPP + f7 + lightingInfo.aoLightValueScratchXYZPPP + lightingInfo.aoLightValueScratchXYPP) / 4.0f;
            f4 = (f7 + lightingInfo.aoLightValueScratchYZPN + lightingInfo.aoLightValueScratchXYPP + lightingInfo.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (lightingInfo.aoLightValueScratchXYNP + lightingInfo.aoLightValueScratchXYZNPN + f7 + lightingInfo.aoLightValueScratchYZPN) / 4.0f;
            lightingInfo.brightnessTopRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNPP, lightingInfo.aoBrightnessXYNP, lightingInfo.aoBrightnessYZPP, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPP, lightingInfo.aoBrightnessXYZPPP, lightingInfo.aoBrightnessXYPP, i1);
            lightingInfo.brightnessBottomLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPN, lightingInfo.aoBrightnessXYPP, lightingInfo.aoBrightnessXYZPPN, i1);
            lightingInfo.brightnessBottomRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYNP, lightingInfo.aoBrightnessXYZNPN, lightingInfo.aoBrightnessYZPN, i1);
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 2) {
            lightingInfo.aoLightValueScratchXZNN = world.func_147439_a(x - 1, y, z).func_149685_I();
            lightingInfo.aoLightValueScratchYZNN = world.func_147439_a(x, y - 1, z).func_149685_I();
            lightingInfo.aoLightValueScratchYZPN = world.func_147439_a(x, y + 1, z).func_149685_I();
            lightingInfo.aoLightValueScratchXZPN = world.func_147439_a(x + 1, y, z).func_149685_I();
            lightingInfo.aoBrightnessXZNN = block.func_149677_c(world, x - 1, y, z);
            lightingInfo.aoBrightnessYZNN = block.func_149677_c(world, x, y - 1, z);
            lightingInfo.aoBrightnessYZPN = block.func_149677_c(world, x, y + 1, z);
            lightingInfo.aoBrightnessXZPN = block.func_149677_c(world, x + 1, y, z);
            flag2 = world.func_147439_a(x + 1, y, z - 1).func_149751_l();
            flag3 = world.func_147439_a(x - 1, y, z - 1).func_149751_l();
            flag4 = world.func_147439_a(x, y + 1, z - 1).func_149751_l();
            flag5 = world.func_147439_a(x, y - 1, z - 1).func_149751_l();
            if (!flag3 && !flag5) {
                lightingInfo.aoLightValueScratchXYZNNN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNNN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNN = world.func_147439_a(x - 1, y - 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZNNN = block.func_149677_c(world, x - 1, y - 1, z);
            }
            if (!flag3 && !flag4) {
                lightingInfo.aoLightValueScratchXYZNPN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNPN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNPN = world.func_147439_a(x - 1, y + 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZNPN = block.func_149677_c(world, x - 1, y + 1, z);
            }
            if (!flag2 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPNN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPNN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNN = world.func_147439_a(x + 1, y - 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZPNN = block.func_149677_c(world, x + 1, y - 1, z);
            }
            if (!flag2 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPPN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPPN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPPN = world.func_147439_a(x + 1, y + 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZPPN = block.func_149677_c(world, x + 1, y + 1, z);
            }
            if (RenderBlocks.getInstance().field_147851_l <= 0.0) {
                ++z;
            }
            i1 = l;
            if (RenderBlocks.getInstance().field_147851_l <= 0.0 || !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                i1 = block.func_149677_c(world, x, y, z - 1);
            }
            f7 = world.func_147439_a(x, y, z - 1).func_149685_I();
            f8 = (lightingInfo.aoLightValueScratchXZNN + lightingInfo.aoLightValueScratchXYZNPN + f7 + lightingInfo.aoLightValueScratchYZPN) / 4.0f;
            f9 = (f7 + lightingInfo.aoLightValueScratchYZPN + lightingInfo.aoLightValueScratchXZPN + lightingInfo.aoLightValueScratchXYZPPN) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchYZNN + f7 + lightingInfo.aoLightValueScratchXYZPNN + lightingInfo.aoLightValueScratchXZPN) / 4.0f;
            f11 = (lightingInfo.aoLightValueScratchXYZNNN + lightingInfo.aoLightValueScratchXZNN + lightingInfo.aoLightValueScratchYZNN + f7) / 4.0f;
            f3 = (float)((double)f8 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147859_h) + (double)f9 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147859_h + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147859_h + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147859_h));
            f4 = (float)((double)f8 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147861_i) + (double)f9 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147861_i + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147861_i + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147861_i));
            f5 = (float)((double)f8 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147861_i) + (double)f9 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147861_i + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147861_i + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147861_i));
            f6 = (float)((double)f8 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147859_h) + (double)f9 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147859_h + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147859_h + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147859_h));
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNN, lightingInfo.aoBrightnessXYZNPN, lightingInfo.aoBrightnessYZPN, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPN, lightingInfo.aoBrightnessXZPN, lightingInfo.aoBrightnessXYZPPN, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNN, lightingInfo.aoBrightnessXYZPNN, lightingInfo.aoBrightnessXZPN, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNN, lightingInfo.aoBrightnessXZNN, lightingInfo.aoBrightnessYZNN, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(j1, k1, l1, i2, RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147859_h), RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147859_h, (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147859_h, (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147859_h));
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(j1, k1, l1, i2, RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147861_i), RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147861_i, (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147861_i, (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147861_i));
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(j1, k1, l1, i2, RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147861_i), RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147861_i, (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147861_i, (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147861_i));
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(j1, k1, l1, i2, RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147859_h), RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147859_h, (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147859_h, (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147859_h));
            lightingInfo.colorRedTopRight = 0.8f;
            lightingInfo.colorRedBottomRight = 0.8f;
            lightingInfo.colorRedBottomLeft = 0.8f;
            lightingInfo.colorRedTopLeft = 0.8f;
            lightingInfo.colorGreenTopRight = 0.8f;
            lightingInfo.colorGreenBottomRight = 0.8f;
            lightingInfo.colorGreenBottomLeft = 0.8f;
            lightingInfo.colorGreenTopLeft = 0.8f;
            lightingInfo.colorBlueTopRight = 0.8f;
            lightingInfo.colorBlueBottomRight = 0.8f;
            lightingInfo.colorBlueBottomLeft = 0.8f;
            lightingInfo.colorBlueTopLeft = 0.8f;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 3) {
            if (RenderBlocks.getInstance().field_147853_m >= 1.0) {
                ++z;
            }
            lightingInfo.aoLightValueScratchXZNP = world.func_147439_a(x - 1, y, z).func_149685_I();
            lightingInfo.aoLightValueScratchXZPP = world.func_147439_a(x + 1, y, z).func_149685_I();
            lightingInfo.aoLightValueScratchYZNP = world.func_147439_a(x, y - 1, z).func_149685_I();
            lightingInfo.aoLightValueScratchYZPP = world.func_147439_a(x, y + 1, z).func_149685_I();
            lightingInfo.aoBrightnessXZNP = block.func_149677_c(world, x - 1, y, z);
            lightingInfo.aoBrightnessXZPP = block.func_149677_c(world, x + 1, y, z);
            lightingInfo.aoBrightnessYZNP = block.func_149677_c(world, x, y - 1, z);
            lightingInfo.aoBrightnessYZPP = block.func_149677_c(world, x, y + 1, z);
            flag2 = world.func_147439_a(x + 1, y, z + 1).func_149751_l();
            flag3 = world.func_147439_a(x - 1, y, z + 1).func_149751_l();
            flag4 = world.func_147439_a(x, y + 1, z + 1).func_149751_l();
            flag5 = world.func_147439_a(x, y - 1, z + 1).func_149751_l();
            if (!flag3 && !flag5) {
                lightingInfo.aoLightValueScratchXYZNNP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNNP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNNP = world.func_147439_a(x - 1, y - 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZNNP = block.func_149677_c(world, x - 1, y - 1, z);
            }
            if (!flag3 && !flag4) {
                lightingInfo.aoLightValueScratchXYZNPP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNPP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPP = world.func_147439_a(x - 1, y + 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZNPP = block.func_149677_c(world, x - 1, y + 1, z);
            }
            if (!flag2 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPNP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPNP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPNP = world.func_147439_a(x + 1, y - 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZPNP = block.func_149677_c(world, x + 1, y - 1, z);
            }
            if (!flag2 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPPP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPPP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPP = world.func_147439_a(x + 1, y + 1, z).func_149685_I();
                lightingInfo.aoBrightnessXYZPPP = block.func_149677_c(world, x + 1, y + 1, z);
            }
            if (RenderBlocks.getInstance().field_147853_m >= 1.0) {
                --z;
            }
            i1 = l;
            if (RenderBlocks.getInstance().field_147853_m >= 1.0 || !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                i1 = block.func_149677_c(world, x, y, z + 1);
            }
            f7 = world.func_147439_a(x, y, z + 1).func_149685_I();
            f8 = (lightingInfo.aoLightValueScratchXZNP + lightingInfo.aoLightValueScratchXYZNPP + f7 + lightingInfo.aoLightValueScratchYZPP) / 4.0f;
            f9 = (f7 + lightingInfo.aoLightValueScratchYZPP + lightingInfo.aoLightValueScratchXZPP + lightingInfo.aoLightValueScratchXYZPPP) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchYZNP + f7 + lightingInfo.aoLightValueScratchXYZPNP + lightingInfo.aoLightValueScratchXZPP) / 4.0f;
            f11 = (lightingInfo.aoLightValueScratchXYZNNP + lightingInfo.aoLightValueScratchXZNP + lightingInfo.aoLightValueScratchYZNP + f7) / 4.0f;
            f3 = (float)((double)f8 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147859_h) + (double)f9 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147859_h + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147859_h + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147859_h));
            f4 = (float)((double)f8 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147859_h) + (double)f9 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147859_h + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147859_h + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147859_h));
            f5 = (float)((double)f8 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147861_i) + (double)f9 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147861_i + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147861_i + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147861_i));
            f6 = (float)((double)f8 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147861_i) + (double)f9 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147861_i + (double)f10 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147861_i + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147861_i));
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNP, lightingInfo.aoBrightnessXYZNPP, lightingInfo.aoBrightnessYZPP, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPP, lightingInfo.aoBrightnessXZPP, lightingInfo.aoBrightnessXYZPPP, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNP, lightingInfo.aoBrightnessXYZPNP, lightingInfo.aoBrightnessXZPP, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNP, lightingInfo.aoBrightnessXZNP, lightingInfo.aoBrightnessYZNP, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147859_h), (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147859_h), (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147859_h, RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147859_h);
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147859_h), (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147859_h), (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147859_h, RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147859_h);
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147861_i), (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147861_i), (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147861_i, RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147861_i);
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147861_i), (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147861_i), (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147861_i, RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147861_i);
            lightingInfo.colorRedTopRight = 0.8f;
            lightingInfo.colorRedBottomRight = 0.8f;
            lightingInfo.colorRedBottomLeft = 0.8f;
            lightingInfo.colorRedTopLeft = 0.8f;
            lightingInfo.colorGreenTopRight = 0.8f;
            lightingInfo.colorGreenBottomRight = 0.8f;
            lightingInfo.colorGreenBottomLeft = 0.8f;
            lightingInfo.colorGreenTopLeft = 0.8f;
            lightingInfo.colorBlueTopRight = 0.8f;
            lightingInfo.colorBlueBottomRight = 0.8f;
            lightingInfo.colorBlueBottomLeft = 0.8f;
            lightingInfo.colorBlueTopLeft = 0.8f;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 4) {
            if (RenderBlocks.getInstance().field_147859_h <= 0.0) {
                --x;
            }
            lightingInfo.aoLightValueScratchXYNN = world.func_147439_a(x, y - 1, z).func_149685_I();
            lightingInfo.aoLightValueScratchXZNN = world.func_147439_a(x, y, z - 1).func_149685_I();
            lightingInfo.aoLightValueScratchXZNP = world.func_147439_a(x, y, z + 1).func_149685_I();
            lightingInfo.aoLightValueScratchXYNP = world.func_147439_a(x, y + 1, z).func_149685_I();
            lightingInfo.aoBrightnessXYNN = block.func_149677_c(world, x, y - 1, z);
            lightingInfo.aoBrightnessXZNN = block.func_149677_c(world, x, y, z - 1);
            lightingInfo.aoBrightnessXZNP = block.func_149677_c(world, x, y, z + 1);
            lightingInfo.aoBrightnessXYNP = block.func_149677_c(world, x, y + 1, z);
            flag2 = world.func_147439_a(x - 1, y + 1, z).func_149751_l();
            flag3 = world.func_147439_a(x - 1, y - 1, z).func_149751_l();
            flag4 = world.func_147439_a(x - 1, y, z - 1).func_149751_l();
            flag5 = world.func_147439_a(x - 1, y, z + 1).func_149751_l();
            if (!flag4 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNNN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNN = world.func_147439_a(x, y - 1, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNNN = block.func_149677_c(world, x, y - 1, z - 1);
            }
            if (!flag5 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNNP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNNP = world.func_147439_a(x, y - 1, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNNP = block.func_149677_c(world, x, y - 1, z + 1);
            }
            if (!flag4 && !flag2) {
                lightingInfo.aoLightValueScratchXYZNPN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNPN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNPN = world.func_147439_a(x, y + 1, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNPN = block.func_149677_c(world, x, y + 1, z - 1);
            }
            if (!flag5 && !flag2) {
                lightingInfo.aoLightValueScratchXYZNPP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNPP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPP = world.func_147439_a(x, y + 1, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZNPP = block.func_149677_c(world, x, y + 1, z + 1);
            }
            if (RenderBlocks.getInstance().field_147859_h <= 0.0) {
                ++x;
            }
            i1 = l;
            if (RenderBlocks.getInstance().field_147859_h <= 0.0 || !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                i1 = block.func_149677_c(world, x - 1, y, z);
            }
            f7 = world.func_147439_a(x - 1, y, z).func_149685_I();
            f8 = (lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchXYZNNP + f7 + lightingInfo.aoLightValueScratchXZNP) / 4.0f;
            f9 = (f7 + lightingInfo.aoLightValueScratchXZNP + lightingInfo.aoLightValueScratchXYNP + lightingInfo.aoLightValueScratchXYZNPP) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchXZNN + f7 + lightingInfo.aoLightValueScratchXYZNPN + lightingInfo.aoLightValueScratchXYNP) / 4.0f;
            f11 = (lightingInfo.aoLightValueScratchXYZNNN + lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchXZNN + f7) / 4.0f;
            f3 = (float)((double)f9 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147853_m + (double)f10 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f8 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147853_m);
            f4 = (float)((double)f9 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147851_l + (double)f10 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f8 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147851_l);
            f5 = (float)((double)f9 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147851_l + (double)f10 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f8 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147851_l);
            f6 = (float)((double)f9 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147853_m + (double)f10 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f11 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f8 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147853_m);
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessXYZNNP, lightingInfo.aoBrightnessXZNP, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNP, lightingInfo.aoBrightnessXYNP, lightingInfo.aoBrightnessXYZNPP, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNN, lightingInfo.aoBrightnessXYZNPN, lightingInfo.aoBrightnessXYNP, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNN, lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessXZNN, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(k1, l1, i2, j1, RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147853_m, RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147853_m), (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147853_m), (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147853_m);
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(k1, l1, i2, j1, RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147851_l, RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147851_l), (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147851_l), (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147851_l);
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(k1, l1, i2, j1, RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147851_l, RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147851_l), (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147851_l), (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147851_l);
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(k1, l1, i2, j1, RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147853_m, RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147853_m), (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147853_m), (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147853_m);
            lightingInfo.colorRedTopRight = 0.6f;
            lightingInfo.colorRedBottomRight = 0.6f;
            lightingInfo.colorRedBottomLeft = 0.6f;
            lightingInfo.colorRedTopLeft = 0.6f;
            lightingInfo.colorGreenTopRight = 0.6f;
            lightingInfo.colorGreenBottomRight = 0.6f;
            lightingInfo.colorGreenBottomLeft = 0.6f;
            lightingInfo.colorGreenTopLeft = 0.6f;
            lightingInfo.colorBlueTopRight = 0.6f;
            lightingInfo.colorBlueBottomRight = 0.6f;
            lightingInfo.colorBlueBottomLeft = 0.6f;
            lightingInfo.colorBlueTopLeft = 0.6f;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 5) {
            if (RenderBlocks.getInstance().field_147861_i >= 1.0) {
                ++x;
            }
            lightingInfo.aoLightValueScratchXYPN = world.func_147439_a(x, y - 1, z).func_149685_I();
            lightingInfo.aoLightValueScratchXZPN = world.func_147439_a(x, y, z - 1).func_149685_I();
            lightingInfo.aoLightValueScratchXZPP = world.func_147439_a(x, y, z + 1).func_149685_I();
            lightingInfo.aoLightValueScratchXYPP = world.func_147439_a(x, y + 1, z).func_149685_I();
            lightingInfo.aoBrightnessXYPN = block.func_149677_c(world, x, y - 1, z);
            lightingInfo.aoBrightnessXZPN = block.func_149677_c(world, x, y, z - 1);
            lightingInfo.aoBrightnessXZPP = block.func_149677_c(world, x, y, z + 1);
            lightingInfo.aoBrightnessXYPP = block.func_149677_c(world, x, y + 1, z);
            flag2 = world.func_147439_a(x + 1, y + 1, z).func_149751_l();
            flag3 = world.func_147439_a(x + 1, y - 1, z).func_149751_l();
            flag4 = world.func_147439_a(x + 1, y, z + 1).func_149751_l();
            flag5 = world.func_147439_a(x + 1, y, z - 1).func_149751_l();
            if (!flag3 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPNN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPNN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNN = world.func_147439_a(x, y - 1, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPNN = block.func_149677_c(world, x, y - 1, z - 1);
            }
            if (!flag3 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPNP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPNP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPNP = world.func_147439_a(x, y - 1, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPNP = block.func_149677_c(world, x, y - 1, z + 1);
            }
            if (!flag2 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPPN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPPN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPPN = world.func_147439_a(x, y + 1, z - 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPPN = block.func_149677_c(world, x, y + 1, z - 1);
            }
            if (!flag2 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPPP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPPP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPP = world.func_147439_a(x, y + 1, z + 1).func_149685_I();
                lightingInfo.aoBrightnessXYZPPP = block.func_149677_c(world, x, y + 1, z + 1);
            }
            if (RenderBlocks.getInstance().field_147861_i >= 1.0) {
                --x;
            }
            i1 = l;
            if (RenderBlocks.getInstance().field_147861_i >= 1.0 || !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                i1 = block.func_149677_c(world, x + 1, y, z);
            }
            f7 = world.func_147439_a(x + 1, y, z).func_149685_I();
            f8 = (lightingInfo.aoLightValueScratchXYPN + lightingInfo.aoLightValueScratchXYZPNP + f7 + lightingInfo.aoLightValueScratchXZPP) / 4.0f;
            f9 = (lightingInfo.aoLightValueScratchXYZPNN + lightingInfo.aoLightValueScratchXYPN + lightingInfo.aoLightValueScratchXZPN + f7) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchXZPN + f7 + lightingInfo.aoLightValueScratchXYZPPN + lightingInfo.aoLightValueScratchXYPP) / 4.0f;
            f11 = (f7 + lightingInfo.aoLightValueScratchXZPP + lightingInfo.aoLightValueScratchXYPP + lightingInfo.aoLightValueScratchXYZPPP) / 4.0f;
            f3 = (float)((double)f8 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147853_m + (double)f9 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f10 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f11 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147853_m);
            f4 = (float)((double)f8 * (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147851_l + (double)f9 * (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f10 * RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f11 * RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147851_l);
            f5 = (float)((double)f8 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147851_l + (double)f9 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f10 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147851_l) + (double)f11 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147851_l);
            f6 = (float)((double)f8 * (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147853_m + (double)f9 * (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f10 * RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147853_m) + (double)f11 * RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147853_m);
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYPN, lightingInfo.aoBrightnessXYZPNP, lightingInfo.aoBrightnessXZPP, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZPP, lightingInfo.aoBrightnessXYPP, lightingInfo.aoBrightnessXYZPPP, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZPN, lightingInfo.aoBrightnessXYZPPN, lightingInfo.aoBrightnessXYPP, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZPNN, lightingInfo.aoBrightnessXYPN, lightingInfo.aoBrightnessXZPN, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147853_m, (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147853_m), RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147853_m), RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147853_m);
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - RenderBlocks.getInstance().field_147855_j) * RenderBlocks.getInstance().field_147851_l, (1.0 - RenderBlocks.getInstance().field_147855_j) * (1.0 - RenderBlocks.getInstance().field_147851_l), RenderBlocks.getInstance().field_147855_j * (1.0 - RenderBlocks.getInstance().field_147851_l), RenderBlocks.getInstance().field_147855_j * RenderBlocks.getInstance().field_147851_l);
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147851_l, (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147851_l), RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147851_l), RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147851_l);
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - RenderBlocks.getInstance().field_147857_k) * RenderBlocks.getInstance().field_147853_m, (1.0 - RenderBlocks.getInstance().field_147857_k) * (1.0 - RenderBlocks.getInstance().field_147853_m), RenderBlocks.getInstance().field_147857_k * (1.0 - RenderBlocks.getInstance().field_147853_m), RenderBlocks.getInstance().field_147857_k * RenderBlocks.getInstance().field_147853_m);
            lightingInfo.colorRedTopRight = 0.6f;
            lightingInfo.colorRedBottomRight = 0.6f;
            lightingInfo.colorRedBottomLeft = 0.6f;
            lightingInfo.colorRedTopLeft = 0.6f;
            lightingInfo.colorGreenTopRight = 0.6f;
            lightingInfo.colorGreenBottomRight = 0.6f;
            lightingInfo.colorGreenBottomLeft = 0.6f;
            lightingInfo.colorGreenTopLeft = 0.6f;
            lightingInfo.colorBlueTopRight = 0.6f;
            lightingInfo.colorBlueBottomRight = 0.6f;
            lightingInfo.colorBlueBottomLeft = 0.6f;
            lightingInfo.colorBlueTopLeft = 0.6f;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        return lightingInfo;
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, int meta) {
        return ClientUtils.drawWorldBlock(world, block, x, y, z, meta, AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72325_c((double)x, (double)y, (double)z));
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, int meta, AxisAlignedBB aabb) {
        IIcon iBot = block.func_149691_a(0, meta);
        IIcon iTop = block.func_149691_a(1, meta);
        IIcon iNorth = block.func_149691_a(2, meta);
        IIcon iSouth = block.func_149691_a(3, meta);
        IIcon iWest = block.func_149691_a(4, meta);
        IIcon iEast = block.func_149691_a(5, meta);
        double[][] uv = new double[][]{{iBot.func_94209_e(), iBot.func_94212_f(), iBot.func_94206_g(), iBot.func_94210_h()}, {iTop.func_94209_e(), iTop.func_94212_f(), iTop.func_94206_g(), iTop.func_94210_h()}, {iNorth.func_94209_e(), iNorth.func_94212_f(), iNorth.func_94206_g(), iNorth.func_94210_h()}, {iSouth.func_94209_e(), iSouth.func_94212_f(), iSouth.func_94206_g(), iSouth.func_94210_h()}, {iWest.func_94209_e(), iWest.func_94212_f(), iWest.func_94206_g(), iWest.func_94210_h()}, {iEast.func_94209_e(), iEast.func_94212_f(), iEast.func_94206_g(), iEast.func_94210_h()}};
        return ClientUtils.drawWorldBlock(world, block, x, y, z, uv, aabb);
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, double[][] uv) {
        return ClientUtils.drawWorldBlock(world, block, x, y, z, uv, AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).func_72325_c((double)x, (double)y, (double)z));
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, double[][] uv, AxisAlignedBB bounds) {
        BlockLightingInfo info;
        Tessellator tes = ClientUtils.tes();
        boolean flag = false;
        if (block.func_149646_a(world, x, y, z, 0)) {
            info = ClientUtils.calculateBlockLighting(0, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.func_78380_c(info.brightnessTopLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f, uv[0][0], uv[0][3]);
            tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.func_78380_c(info.brightnessBottomLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, uv[0][0], uv[0][2]);
            tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.func_78380_c(info.brightnessBottomRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c, uv[0][1], uv[0][2]);
            tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.func_78380_c(info.brightnessTopRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f, uv[0][1], uv[0][3]);
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 1)) {
            info = ClientUtils.calculateBlockLighting(1, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.func_78380_c(info.brightnessTopLeft);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f, uv[1][1], uv[1][3]);
            tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.func_78380_c(info.brightnessBottomLeft);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c, uv[1][1], uv[1][2]);
            tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.func_78380_c(info.brightnessBottomRight);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c, uv[1][0], uv[1][2]);
            tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.func_78380_c(info.brightnessTopRight);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f, uv[1][0], uv[1][3]);
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 2)) {
            info = ClientUtils.calculateBlockLighting(2, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.func_78380_c(info.brightnessTopLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c, uv[2][1], uv[2][2]);
            tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.func_78380_c(info.brightnessBottomLeft);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c, uv[2][0], uv[2][2]);
            tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.func_78380_c(info.brightnessBottomRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c, uv[2][0], uv[2][3]);
            tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.func_78380_c(info.brightnessTopRight);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, uv[2][1], uv[2][3]);
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 3)) {
            info = ClientUtils.calculateBlockLighting(3, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.func_78380_c(info.brightnessTopLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f, uv[3][0], uv[3][2]);
            tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.func_78380_c(info.brightnessBottomLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f, uv[3][0], uv[3][3]);
            tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.func_78380_c(info.brightnessBottomRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f, uv[3][1], uv[3][3]);
            tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.func_78380_c(info.brightnessTopRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f, uv[3][1], uv[3][2]);
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 4)) {
            info = ClientUtils.calculateBlockLighting(4, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.func_78380_c(info.brightnessTopLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f, uv[4][1], uv[4][2]);
            tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.func_78380_c(info.brightnessBottomLeft);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c, uv[4][0], uv[4][2]);
            tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.func_78380_c(info.brightnessBottomRight);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, uv[4][0], uv[4][3]);
            tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.func_78380_c(info.brightnessTopRight);
            tes.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f, uv[4][1], uv[4][3]);
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 5)) {
            info = ClientUtils.calculateBlockLighting(5, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.func_78380_c(info.brightnessTopLeft);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f, uv[5][0], uv[5][3]);
            tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.func_78380_c(info.brightnessBottomLeft);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c, uv[5][1], uv[5][3]);
            tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.func_78380_c(info.brightnessBottomRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c, uv[5][1], uv[5][2]);
            tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.func_78380_c(info.brightnessTopRight);
            tes.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f, uv[5][0], uv[5][2]);
            flag = true;
        }
        return flag;
    }

    public static boolean drawWorldSubBlock(RenderBlocks renderer, IBlockAccess world, Block block, int x, int y, int z, Vec3[] vs) {
        double d10;
        double d9;
        double d8;
        double d7;
        double d6;
        double d5;
        double d4;
        double d3;
        BlockLightingInfo info;
        IIcon icon;
        Tessellator tes = ClientUtils.tes();
        boolean flag = false;
        if (block.func_149646_a(world, x, y, z, 0)) {
            icon = renderer.func_147744_b() ? renderer.field_147840_d : block.func_149673_e(world, x, y, z, 0);
            info = ClientUtils.calculateBlockLighting(0, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
            d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
            d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[0].field_72449_c * 16.0)));
            d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[3].field_72449_c * 16.0)));
            d7 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[2].field_72450_a * 16.0)));
            d8 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[1].field_72450_a * 16.0)));
            d9 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[2].field_72449_c * 16.0)));
            d10 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[1].field_72449_c * 16.0)));
            if (renderer.field_147865_v == 2) {
                d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[0].field_72449_c * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[3].field_72449_c * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.field_147865_v == 1) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72449_c * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72449_c * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.field_147865_v == 3) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72449_c * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72449_c * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.field_147863_w) {
                tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.func_78380_c(info.brightnessTopLeft);
                tes.func_78374_a((double)x + vs[1].field_72450_a, (double)y + vs[1].field_72448_b, (double)z + vs[1].field_72449_c, d8, d10);
                tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.func_78380_c(info.brightnessBottomLeft);
                tes.func_78374_a((double)x + vs[0].field_72450_a, (double)y + vs[0].field_72448_b, (double)z + vs[0].field_72449_c, d3, d5);
                tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.func_78380_c(info.brightnessBottomRight);
                tes.func_78374_a((double)x + vs[2].field_72450_a, (double)y + vs[2].field_72448_b, (double)z + vs[2].field_72449_c, d7, d9);
                tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.func_78380_c(info.brightnessTopRight);
                tes.func_78374_a((double)x + vs[3].field_72450_a, (double)y + vs[3].field_72448_b, (double)z + vs[3].field_72449_c, d4, d6);
            } else {
                tes.func_78378_d(0xFFFFFF);
                tes.func_78374_a((double)x + vs[1].field_72450_a, (double)y + vs[1].field_72448_b, (double)z + vs[1].field_72449_c, d8, d10);
                tes.func_78374_a((double)x + vs[0].field_72450_a, (double)y + vs[0].field_72448_b, (double)z + vs[0].field_72449_c, d3, d5);
                tes.func_78374_a((double)x + vs[2].field_72450_a, (double)y + vs[2].field_72448_b, (double)z + vs[2].field_72449_c, d7, d9);
                tes.func_78374_a((double)x + vs[3].field_72450_a, (double)y + vs[3].field_72448_b, (double)z + vs[3].field_72449_c, d4, d6);
            }
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 1)) {
            icon = renderer.func_147744_b() ? renderer.field_147840_d : block.func_149673_e(world, x, y, z, 1);
            info = ClientUtils.calculateBlockLighting(1, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78380_c(983055);
            d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[4].field_72450_a * 16.0)));
            d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[7].field_72450_a * 16.0)));
            d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
            d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
            d7 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[6].field_72450_a * 16.0)));
            d8 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[5].field_72450_a * 16.0)));
            d9 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[6].field_72449_c * 16.0)));
            d10 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[5].field_72449_c * 16.0)));
            if (renderer.field_147867_u == 1) {
                d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72450_a * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.field_147867_u == 2) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[4].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[7].field_72450_a * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.field_147867_u == 3) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72450_a * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.field_147863_w) {
                tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.func_78380_c(info.brightnessTopLeft);
                tes.func_78374_a((double)x + vs[7].field_72450_a, (double)y + vs[7].field_72448_b, (double)z + vs[7].field_72449_c, d4, d6);
                tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.func_78380_c(info.brightnessBottomLeft);
                tes.func_78374_a((double)x + vs[6].field_72450_a, (double)y + vs[6].field_72448_b, (double)z + vs[6].field_72449_c, d7, d9);
                tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.func_78380_c(info.brightnessBottomRight);
                tes.func_78374_a((double)x + vs[4].field_72450_a, (double)y + vs[4].field_72448_b, (double)z + vs[4].field_72449_c, d3, d5);
                tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.func_78380_c(info.brightnessTopRight);
                tes.func_78374_a((double)x + vs[5].field_72450_a, (double)y + vs[5].field_72448_b, (double)z + vs[5].field_72449_c, d8, d10);
            } else {
                tes.func_78378_d(0xFFFFFF);
                tes.func_78374_a((double)x + vs[7].field_72450_a, (double)y + vs[7].field_72448_b, (double)z + vs[7].field_72449_c, d4, d6);
                tes.func_78374_a((double)x + vs[6].field_72450_a, (double)y + vs[6].field_72448_b, (double)z + vs[6].field_72449_c, d7, d9);
                tes.func_78374_a((double)x + vs[4].field_72450_a, (double)y + vs[4].field_72448_b, (double)z + vs[4].field_72449_c, d3, d5);
                tes.func_78374_a((double)x + vs[5].field_72450_a, (double)y + vs[5].field_72448_b, (double)z + vs[5].field_72449_c, d8, d10);
            }
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 2)) {
            icon = renderer.func_147744_b() ? renderer.field_147840_d : block.func_149673_e(world, x, y, z, 2);
            info = ClientUtils.calculateBlockLighting(2, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78380_c(983055);
            d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
            d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[6].field_72450_a * 16.0)));
            d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[6].field_72448_b * 16.0)));
            d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72448_b * 16.0)));
            d7 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[2].field_72450_a * 16.0)));
            d8 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[4].field_72450_a * 16.0)));
            d9 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72448_b * 16.0)));
            d10 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[2].field_72448_b * 16.0)));
            if (renderer.field_147875_q == 2) {
                d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[0].field_72448_b * 16.0)));
                d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[6].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[6].field_72450_a * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.field_147875_q == 1) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[6].field_72448_b * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[6].field_72450_a * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.field_147875_q == 3) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[6].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72450_a * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[0].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[6].field_72448_b * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.field_147863_w) {
                tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.func_78380_c(info.brightnessTopLeft);
                tes.func_78374_a((double)x + vs[4].field_72450_a, (double)y + vs[4].field_72448_b, (double)z + vs[4].field_72449_c, d7, d9);
                tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.func_78380_c(info.brightnessBottomLeft);
                tes.func_78374_a((double)x + vs[6].field_72450_a, (double)y + vs[6].field_72448_b, (double)z + vs[6].field_72449_c, d3, d5);
                tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.func_78380_c(info.brightnessBottomRight);
                tes.func_78374_a((double)x + vs[2].field_72450_a, (double)y + vs[2].field_72448_b, (double)z + vs[2].field_72449_c, d8, d10);
                tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.func_78380_c(info.brightnessTopRight);
                tes.func_78374_a((double)x + vs[0].field_72450_a, (double)y + vs[0].field_72448_b, (double)z + vs[0].field_72449_c, d4, d6);
            } else {
                tes.func_78378_d(0xFFFFFF);
                tes.func_78374_a((double)x + vs[4].field_72450_a, (double)y + vs[4].field_72448_b, (double)z + vs[4].field_72449_c, d7, d9);
                tes.func_78374_a((double)x + vs[6].field_72450_a, (double)y + vs[6].field_72448_b, (double)z + vs[6].field_72449_c, d3, d5);
                tes.func_78374_a((double)x + vs[2].field_72450_a, (double)y + vs[2].field_72448_b, (double)z + vs[2].field_72449_c, d8, d10);
                tes.func_78374_a((double)x + vs[0].field_72450_a, (double)y + vs[0].field_72448_b, (double)z + vs[0].field_72449_c, d4, d6);
            }
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 3)) {
            icon = renderer.func_147744_b() ? renderer.field_147840_d : block.func_149673_e(world, x, y, z, 3);
            info = ClientUtils.calculateBlockLighting(3, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78380_c(983055);
            d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[5].field_72450_a * 16.0)));
            d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
            d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[5].field_72448_b * 16.0)));
            d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72448_b * 16.0)));
            d7 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[7].field_72450_a * 16.0)));
            d8 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[1].field_72450_a * 16.0)));
            d9 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72448_b * 16.0)));
            d10 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[1].field_72448_b * 16.0)));
            if (renderer.field_147873_r == 1) {
                d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[3].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[5].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[5].field_72448_b * 16.0)));
                d9 = d5 = (double)icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.field_147873_r == 2) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[5].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[5].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.field_147873_r == 3) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[5].field_72450_a * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72450_a * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[5].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[3].field_72448_b * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.field_147863_w) {
                tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.func_78380_c(info.brightnessTopLeft);
                tes.func_78374_a((double)x + vs[5].field_72450_a, (double)y + vs[5].field_72448_b, (double)z + vs[5].field_72449_c, d3, d5);
                tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.func_78380_c(info.brightnessBottomLeft);
                tes.func_78374_a((double)x + vs[1].field_72450_a, (double)y + vs[1].field_72448_b, (double)z + vs[1].field_72449_c, d8, d10);
                tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.func_78380_c(info.brightnessBottomRight);
                tes.func_78374_a((double)x + vs[3].field_72450_a, (double)y + vs[3].field_72448_b, (double)z + vs[3].field_72449_c, d4, d6);
                tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.func_78380_c(info.brightnessTopRight);
                tes.func_78374_a((double)x + vs[7].field_72450_a, (double)y + vs[7].field_72448_b, (double)z + vs[7].field_72449_c, d7, d9);
            } else {
                tes.func_78378_d(0xFFFFFF);
                tes.func_78374_a((double)x + vs[5].field_72450_a, (double)y + vs[5].field_72448_b, (double)z + vs[5].field_72449_c, d3, d5);
                tes.func_78374_a((double)x + vs[1].field_72450_a, (double)y + vs[1].field_72448_b, (double)z + vs[1].field_72449_c, d8, d10);
                tes.func_78374_a((double)x + vs[3].field_72450_a, (double)y + vs[3].field_72448_b, (double)z + vs[3].field_72449_c, d4, d6);
                tes.func_78374_a((double)x + vs[7].field_72450_a, (double)y + vs[7].field_72448_b, (double)z + vs[7].field_72449_c, d7, d9);
            }
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 4)) {
            icon = renderer.func_147744_b() ? renderer.field_147840_d : block.func_149673_e(world, x, y, z, 4);
            info = ClientUtils.calculateBlockLighting(4, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78380_c(983055);
            d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
            d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[1].field_72449_c * 16.0)));
            d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72448_b * 16.0)));
            d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[1].field_72448_b * 16.0)));
            d7 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[5].field_72449_c * 16.0)));
            d8 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[0].field_72449_c * 16.0)));
            d9 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[5].field_72448_b * 16.0)));
            d10 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[0].field_72448_b * 16.0)));
            if (renderer.field_147869_t == 1) {
                d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[1].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[1].field_72449_c * 16.0)));
                d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[4].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.field_147869_t == 2) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[1].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[1].field_72449_c * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.field_147869_t == 3) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[4].field_72449_c * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[1].field_72449_c * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[4].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[1].field_72448_b * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.field_147863_w) {
                tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.func_78380_c(info.brightnessTopLeft);
                tes.func_78374_a((double)x + vs[5].field_72450_a, (double)y + vs[5].field_72448_b, (double)z + vs[5].field_72449_c, d7, d9);
                tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.func_78380_c(info.brightnessBottomLeft);
                tes.func_78374_a((double)x + vs[4].field_72450_a, (double)y + vs[4].field_72448_b, (double)z + vs[4].field_72449_c, d3, d5);
                tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.func_78380_c(info.brightnessBottomRight);
                tes.func_78374_a((double)x + vs[0].field_72450_a, (double)y + vs[0].field_72448_b, (double)z + vs[0].field_72449_c, d8, d10);
                tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.func_78380_c(info.brightnessTopRight);
                tes.func_78374_a((double)x + vs[1].field_72450_a, (double)y + vs[1].field_72448_b, (double)z + vs[1].field_72449_c, d4, d6);
            } else {
                tes.func_78378_d(0xFFFFFF);
                tes.func_78374_a((double)x + vs[5].field_72450_a, (double)y + vs[5].field_72448_b, (double)z + vs[5].field_72449_c, d7, d9);
                tes.func_78374_a((double)x + vs[4].field_72450_a, (double)y + vs[4].field_72448_b, (double)z + vs[4].field_72449_c, d3, d5);
                tes.func_78374_a((double)x + vs[0].field_72450_a, (double)y + vs[0].field_72448_b, (double)z + vs[0].field_72449_c, d8, d10);
                tes.func_78374_a((double)x + vs[1].field_72450_a, (double)y + vs[1].field_72448_b, (double)z + vs[1].field_72449_c, d4, d6);
            }
            flag = true;
        }
        if (block.func_149646_a(world, x, y, z, 5)) {
            icon = renderer.func_147744_b() ? renderer.field_147840_d : block.func_149673_e(world, x, y, z, 5);
            info = ClientUtils.calculateBlockLighting(5, world, block, x, y, z, 1.0f, 1.0f, 1.0f);
            tes.func_78380_c(983055);
            d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
            d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[2].field_72449_c * 16.0)));
            d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72448_b * 16.0)));
            d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[2].field_72448_b * 16.0)));
            d7 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[6].field_72449_c * 16.0)));
            d8 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[3].field_72449_c * 16.0)));
            d9 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[6].field_72448_b * 16.0)));
            d10 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[3].field_72448_b * 16.0)));
            if (renderer.field_147871_s == 2) {
                d3 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[2].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
                d4 = icon.func_94214_a(Math.min(16.0, Math.max(0.0, vs[7].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(16.0 - Math.min(16.0, Math.max(0.0, vs[2].field_72449_c * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.field_147871_s == 1) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72448_b * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[2].field_72449_c * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[2].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.field_147871_s == 3) {
                d3 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[7].field_72449_c * 16.0)));
                d4 = icon.func_94214_a(16.0 - Math.min(16.0, Math.max(0.0, vs[2].field_72449_c * 16.0)));
                d5 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[7].field_72448_b * 16.0)));
                d6 = icon.func_94207_b(Math.min(16.0, Math.max(0.0, vs[2].field_72448_b * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.field_147863_w) {
                tes.func_78386_a(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.func_78380_c(info.brightnessTopLeft);
                tes.func_78374_a((double)x + vs[3].field_72450_a, (double)y + vs[3].field_72448_b, (double)z + vs[3].field_72449_c, d8, d10);
                tes.func_78386_a(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.func_78380_c(info.brightnessBottomLeft);
                tes.func_78374_a((double)x + vs[2].field_72450_a, (double)y + vs[2].field_72448_b, (double)z + vs[2].field_72449_c, d4, d6);
                tes.func_78386_a(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.func_78380_c(info.brightnessBottomRight);
                tes.func_78374_a((double)x + vs[6].field_72450_a, (double)y + vs[6].field_72448_b, (double)z + vs[6].field_72449_c, d7, d9);
                tes.func_78386_a(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.func_78380_c(info.brightnessTopRight);
                tes.func_78374_a((double)x + vs[7].field_72450_a, (double)y + vs[7].field_72448_b, (double)z + vs[7].field_72449_c, d3, d5);
            } else {
                tes.func_78378_d(0xFFFFFF);
                tes.func_78374_a((double)x + vs[3].field_72450_a, (double)y + vs[3].field_72448_b, (double)z + vs[3].field_72449_c, d8, d10);
                tes.func_78374_a((double)x + vs[2].field_72450_a, (double)y + vs[2].field_72448_b, (double)z + vs[2].field_72449_c, d4, d6);
                tes.func_78374_a((double)x + vs[6].field_72450_a, (double)y + vs[6].field_72448_b, (double)z + vs[6].field_72449_c, d7, d9);
                tes.func_78374_a((double)x + vs[7].field_72450_a, (double)y + vs[7].field_72448_b, (double)z + vs[7].field_72449_c, d3, d5);
            }
            flag = true;
        }
        return flag;
    }

    public static class BlockLightingInfo {
        public int aoBrightnessXYNN;
        public int aoBrightnessYZNN;
        public int aoBrightnessYZNP;
        public int aoBrightnessXYPN;
        public float aoLightValueScratchXYNN;
        public float aoLightValueScratchYZNN;
        public float aoLightValueScratchYZNP;
        public float aoLightValueScratchXYPN;
        public float aoLightValueScratchXYZNNN;
        public int aoBrightnessXYZNNN;
        public float aoLightValueScratchXYZNNP;
        public int aoBrightnessXYZNNP;
        public float aoLightValueScratchXYZPNN;
        public int aoBrightnessXYZPNN;
        public float aoLightValueScratchXYZPNP;
        public int aoBrightnessXYZPNP;
        public int brightnessTopLeft;
        public int brightnessTopRight;
        public int brightnessBottomRight;
        public int brightnessBottomLeft;
        public float colorRedTopLeft;
        public float colorGreenTopLeft;
        public float colorBlueTopLeft;
        public float colorRedBottomLeft;
        public float colorRedBottomRight;
        public float colorRedTopRight;
        public float colorGreenTopRight;
        public float colorBlueTopRight;
        public float colorGreenBottomRight;
        public float colorBlueBottomRight;
        public float colorGreenBottomLeft;
        public float colorBlueBottomLeft;
        public int aoBrightnessXYNP;
        public int aoBrightnessXYPP;
        public int aoBrightnessYZPN;
        public int aoBrightnessYZPP;
        public float aoLightValueScratchXYNP;
        public float aoLightValueScratchXYPP;
        public float aoLightValueScratchYZPN;
        public float aoLightValueScratchYZPP;
        public float aoLightValueScratchXYZNPN;
        public int aoBrightnessXYZNPN;
        public float aoLightValueScratchXYZPPN;
        public int aoBrightnessXYZPPN;
        public float aoLightValueScratchXYZNPP;
        public int aoBrightnessXYZNPP;
        public float aoLightValueScratchXYZPPP;
        public int aoBrightnessXYZPPP;
        public float aoLightValueScratchXZNN;
        public float aoLightValueScratchXZPN;
        public int aoBrightnessXZNN;
        public int aoBrightnessXZPN;
        public float aoLightValueScratchXZNP;
        public float aoLightValueScratchXZPP;
        public int aoBrightnessXZNP;
        public int aoBrightnessXZPP;

        public int getAoBrightness(int par0, int par1, int par2, int par3) {
            if (par0 == 0) {
                par0 = par3;
            }
            if (par1 == 0) {
                par1 = par3;
            }
            if (par2 == 0) {
                par2 = par3;
            }
            return par0 + par1 + par2 + par3 >> 2 & 0xFF00FF;
        }

        public int mixAoBrightness(int par0, int par1, int par2, int par3, double par4, double par5, double par6, double par7) {
            int i1 = (int)((double)(par0 >> 16 & 0xFF) * par4 + (double)(par1 >> 16 & 0xFF) * par5 + (double)(par2 >> 16 & 0xFF) * par6 + (double)(par3 >> 16 & 0xFF) * par7) & 0xFF;
            int j1 = (int)((double)(par0 & 0xFF) * par4 + (double)(par1 & 0xFF) * par5 + (double)(par2 & 0xFF) * par6 + (double)(par3 & 0xFF) * par7) & 0xFF;
            return i1 << 16 | j1;
        }
    }
}

