/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ImmersiveNetHandler {
    public static ImmersiveNetHandler INSTANCE;
    public ConcurrentHashMap<Integer, ConcurrentHashMap<ChunkCoordinates, Set<Connection>>> directConnections = new ConcurrentHashMap();
    public ConcurrentHashMap<ChunkCoordinates, Set<AbstractConnection>> indirectConnections = new ConcurrentHashMap();
    public HashMap<Integer, HashMap<Connection, Integer>> transferPerTick = new HashMap();

    private ConcurrentHashMap<ChunkCoordinates, Set<Connection>> getMultimap(int dimension) {
        if (this.directConnections.get(dimension) == null) {
            ConcurrentHashMap mm = new ConcurrentHashMap();
            this.directConnections.put(dimension, mm);
        }
        return this.directConnections.get(dimension);
    }

    public HashMap<Connection, Integer> getTransferedRates(int dimension) {
        if (!this.transferPerTick.containsKey(dimension)) {
            this.transferPerTick.put(dimension, new HashMap());
        }
        return this.transferPerTick.get(dimension);
    }

    public void addConnection(World world, ChunkCoordinates node, ChunkCoordinates connection, int distance, WireType cableType) {
        if (!this.getMultimap(world.field_73011_w.field_76574_g).containsKey(node)) {
            this.getMultimap(world.field_73011_w.field_76574_g).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.field_73011_w.field_76574_g).get(node).add(new Connection(node, connection, cableType, distance));
        if (!this.getMultimap(world.field_73011_w.field_76574_g).containsKey(connection)) {
            this.getMultimap(world.field_73011_w.field_76574_g).put(connection, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.field_73011_w.field_76574_g).get(connection).add(new Connection(connection, node, cableType, distance));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
        if (world.func_72899_e(node.field_71574_a, node.field_71572_b, node.field_71573_c)) {
            world.func_147452_c(node.field_71574_a, node.field_71572_b, node.field_71573_c, world.func_147439_a(node.field_71574_a, node.field_71572_b, node.field_71573_c), -1, 0);
        }
        if (world.func_72899_e(connection.field_71574_a, connection.field_71572_b, connection.field_71573_c)) {
            world.func_147452_c(connection.field_71574_a, connection.field_71572_b, connection.field_71573_c, world.func_147439_a(connection.field_71574_a, connection.field_71572_b, connection.field_71573_c), -1, 0);
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
    }

    public void addConnection(World world, ChunkCoordinates node, Connection con) {
        if (!this.getMultimap(world.field_73011_w.field_76574_g).containsKey(node)) {
            this.getMultimap(world.field_73011_w.field_76574_g).put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
        this.getMultimap(world.field_73011_w.field_76574_g).get(node).add(con);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
    }

    public void removeConnection(World world, Connection con) {
        if (con == null || world == null) {
            return;
        }
        for (Set<Connection> conl : this.getMultimap(world.field_73011_w.field_76574_g).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection itCon = it.next();
                if (!con.hasSameConnectors(itCon)) continue;
                it.remove();
                IImmersiveConnectable iic = ApiUtils.toIIC(itCon.end, world);
                if (iic != null) {
                    iic.removeCable(itCon);
                }
                if ((iic = ApiUtils.toIIC(itCon.start, world)) != null) {
                    iic.removeCable(itCon);
                }
                if (world.func_72899_e(itCon.start.field_71574_a, itCon.start.field_71572_b, itCon.start.field_71573_c)) {
                    world.func_147452_c(itCon.start.field_71574_a, itCon.start.field_71572_b, itCon.start.field_71573_c, world.func_147439_a(itCon.start.field_71574_a, itCon.start.field_71572_b, itCon.start.field_71573_c), -1, 0);
                }
                if (!world.func_72899_e(itCon.end.field_71574_a, itCon.end.field_71572_b, itCon.end.field_71573_c)) continue;
                world.func_147452_c(itCon.end.field_71574_a, itCon.end.field_71572_b, itCon.end.field_71573_c, world.func_147439_a(itCon.end.field_71574_a, itCon.end.field_71572_b, itCon.end.field_71573_c), -1, 0);
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
    }

    public Set<Integer> getRelevantDimensions() {
        return this.directConnections.keySet();
    }

    public Collection<Connection> getAllConnections(World world) {
        Set<Connection> ret = Collections.newSetFromMap(new ConcurrentHashMap());
        for (Set<Connection> conlist : this.getMultimap(world.field_73011_w.field_76574_g).values()) {
            ret.addAll(conlist);
        }
        return ret;
    }

    public synchronized Set<Connection> getConnections(World world, ChunkCoordinates node) {
        ConcurrentHashMap<ChunkCoordinates, Set<Connection>> map = this.getMultimap(world.field_73011_w.field_76574_g);
        if (map.containsKey(node)) {
            return map.get(node);
        }
        return null;
    }

    public void clearAllConnections(World world) {
        this.getMultimap(world.field_73011_w.field_76574_g).clear();
    }

    public void clearConnectionsOriginatingFrom(ChunkCoordinates node, World world) {
        if (this.getMultimap(world.field_73011_w.field_76574_g).containsKey(node)) {
            this.getMultimap(world.field_73011_w.field_76574_g).get(node).clear();
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public void resetCachedIndirectConnections() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public void clearAllConnectionsFor(ChunkCoordinates node, World world) {
        IImmersiveConnectable iic;
        if (this.getMultimap(world.field_73011_w.field_76574_g).containsKey(node)) {
            this.getMultimap(world.field_73011_w.field_76574_g).get(node).clear();
        }
        if ((iic = ApiUtils.toIIC(node, world)) != null) {
            iic.removeCable(null);
        }
        for (Set<Connection> conl : this.getMultimap(world.field_73011_w.field_76574_g).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (!node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
                it.remove();
                IImmersiveConnectable other = node.equals((Object)con.start) ? ApiUtils.toIIC(con.end, world) : ApiUtils.toIIC(con.start, world);
                if (iic != null) {
                    iic.removeCable(con);
                }
                if (other != null) {
                    other.removeCable(con);
                }
                if (node.equals((Object)con.end)) {
                    double dx = (double)node.field_71574_a + 0.5 + (double)Math.signum(con.start.field_71574_a - con.end.field_71574_a);
                    double dy = (double)node.field_71572_b + 0.5 + (double)Math.signum(con.start.field_71572_b - con.end.field_71572_b);
                    double dz = (double)node.field_71573_c + 0.5 + (double)Math.signum(con.start.field_71573_c - con.end.field_71573_c);
                    if (world.func_82736_K().func_82766_b("doTileDrops")) {
                        world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil()));
                    }
                    if (!world.func_72899_e(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c)) continue;
                    world.func_147452_c(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c, world.func_147439_a(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c), -1, 0);
                    continue;
                }
                if (!world.func_72899_e(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c)) continue;
                world.func_147452_c(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c, world.func_147439_a(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c), -1, 0);
            }
        }
        if (world.func_72899_e(node.field_71574_a, node.field_71572_b, node.field_71573_c)) {
            world.func_147452_c(node.field_71574_a, node.field_71572_b, node.field_71573_c, world.func_147439_a(node.field_71574_a, node.field_71572_b, node.field_71573_c), -1, 0);
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public void clearAllConnectionsFor(ChunkCoordinates node, World world, TargetingInfo target) {
        WireType type;
        IImmersiveConnectable iic = ApiUtils.toIIC(node, world);
        WireType wireType = type = target == null ? null : iic.getCableLimiter(target);
        if (type == null) {
            return;
        }
        for (Set<Connection> conl : this.getMultimap(world.field_73011_w.field_76574_g).values()) {
            Iterator<Connection> it = conl.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (con.cableType != type || !node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
                it.remove();
                IImmersiveConnectable other = node.equals((Object)con.start) ? ApiUtils.toIIC(con.end, world) : ApiUtils.toIIC(con.start, world);
                if (iic != null) {
                    iic.removeCable(con);
                }
                if (other != null) {
                    other.removeCable(con);
                }
                if (node.equals((Object)con.end)) {
                    double dx = (double)node.field_71574_a + 0.5 + (double)Math.signum(con.start.field_71574_a - con.end.field_71574_a);
                    double dy = (double)node.field_71572_b + 0.5 + (double)Math.signum(con.start.field_71572_b - con.end.field_71572_b);
                    double dz = (double)node.field_71573_c + 0.5 + (double)Math.signum(con.start.field_71573_c - con.end.field_71573_c);
                    if (world.func_82736_K().func_82766_b("doTileDrops")) {
                        world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil()));
                    }
                    if (!world.func_72899_e(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c)) continue;
                    world.func_147452_c(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c, world.func_147439_a(con.start.field_71574_a, con.start.field_71572_b, con.start.field_71573_c), -1, 0);
                    continue;
                }
                if (!world.func_72899_e(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c)) continue;
                world.func_147452_c(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c, world.func_147439_a(con.end.field_71574_a, con.end.field_71572_b, con.end.field_71573_c), -1, 0);
            }
        }
        if (world.func_72899_e(node.field_71574_a, node.field_71572_b, node.field_71573_c)) {
            world.func_147452_c(node.field_71574_a, node.field_71572_b, node.field_71573_c, world.func_147439_a(node.field_71574_a, node.field_71572_b, node.field_71573_c), -1, 0);
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public Set<AbstractConnection> getIndirectEnergyConnections(ChunkCoordinates node, World world) {
        if (this.indirectConnections.containsKey(node)) {
            return this.indirectConnections.get(node);
        }
        ArrayList<IImmersiveConnectable> openList = new ArrayList<IImmersiveConnectable>();
        Set<AbstractConnection> closedList = Collections.newSetFromMap(new ConcurrentHashMap());
        ArrayList<ChunkCoordinates> checked = new ArrayList<ChunkCoordinates>();
        HashMap<ChunkCoordinates, ChunkCoordinates> backtracker = new HashMap<ChunkCoordinates, ChunkCoordinates>();
        checked.add(node);
        Set<Connection> conL = this.getConnections(world, node);
        if (conL != null) {
            for (Connection con : conL) {
                IImmersiveConnectable end = ApiUtils.toIIC(con.end, world);
                if (end == null) continue;
                openList.add(end);
                backtracker.put(con.end, node);
            }
        }
        IImmersiveConnectable next = null;
        int closedListMax = 1200;
        while (closedList.size() < 1200 && !openList.isEmpty()) {
            next = (IImmersiveConnectable)openList.get(0);
            if (!checked.contains(ApiUtils.toCC(next))) {
                Set<Connection> conLN;
                if (next.isEnergyOutput()) {
                    ChunkCoordinates last = ApiUtils.toCC(next);
                    WireType averageType = null;
                    int distance = 0;
                    ArrayList<Connection> connectionParts = new ArrayList<Connection>();
                    block2: while (last != null) {
                        Set<Connection> conLB;
                        ChunkCoordinates prev = last;
                        if ((last = (ChunkCoordinates)backtracker.get(last)) == null || (conLB = this.getConnections(world, prev)) == null) continue;
                        for (Connection conB : conLB) {
                            if (!conB.end.equals((Object)last)) continue;
                            connectionParts.add(conB);
                            distance += conB.length;
                            if (averageType != null && conB.cableType.getTransferRate() >= averageType.getTransferRate()) continue block2;
                            averageType = conB.cableType;
                            continue block2;
                        }
                    }
                    closedList.add(new AbstractConnection(ApiUtils.toCC(node), ApiUtils.toCC(next), averageType, distance, connectionParts.toArray(new Connection[connectionParts.size()])));
                }
                if ((conLN = this.getConnections(world, ApiUtils.toCC(next))) != null) {
                    for (Connection con : conLN) {
                        IImmersiveConnectable end;
                        if (!next.allowEnergyToPass(con) || (end = ApiUtils.toIIC(con.end, world)) == null || checked.contains(con.end) || openList.contains(end)) continue;
                        openList.add(end);
                        backtracker.put(con.end, ApiUtils.toCC(next));
                    }
                }
                checked.add(ApiUtils.toCC(next));
            }
            openList.remove(0);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (!this.indirectConnections.containsKey(node)) {
                this.indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            }
            this.indirectConnections.get(node).addAll(closedList);
        }
        return closedList;
    }

    public static class AbstractConnection
    extends Connection {
        public Connection[] subConnections;

        public AbstractConnection(ChunkCoordinates start, ChunkCoordinates end, WireType cableType, int length, Connection ... subConnections) {
            super(start, end, cableType, length);
            this.subConnections = subConnections;
        }

        public float getPreciseLossRate(int energyInput, int connectorMaxInput) {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float length = (float)c.length / (float)c.cableType.getMaxLength();
                float baseLoss = (float)c.cableType.getLossRatio();
                float mod = (float)(connectorMaxInput - energyInput) / (float)connectorMaxInput / 0.25f * 0.1f;
                f += length * (baseLoss + baseLoss * mod);
            }
            return Math.min(f, 1.0f);
        }

        public float getAverageLossRate() {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                float length = (float)c.length / (float)c.cableType.getMaxLength();
                float baseLoss = (float)c.cableType.getLossRatio();
                f += length * baseLoss;
            }
            return Math.min(f, 1.0f);
        }
    }

    public static class Connection
    implements Comparable<Connection> {
        public ChunkCoordinates start;
        public ChunkCoordinates end;
        public WireType cableType;
        public int length;
        public Vec3[] catenaryVertices;

        public Connection(ChunkCoordinates start, ChunkCoordinates end, WireType cableType, int length) {
            this.start = start;
            this.end = end;
            this.cableType = cableType;
            this.length = length;
        }

        public boolean hasSameConnectors(Connection o) {
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection con = o;
            boolean n0 = this.start.equals((Object)con.start) && this.end.equals((Object)con.end);
            boolean n1 = this.start.equals((Object)con.end) && this.end.equals((Object)con.start);
            return n0 || n1;
        }

        public Vec3[] getSubVertices(World world) {
            if (this.catenaryVertices == null) {
                Vec3 vStart = Vec3.func_72443_a((double)this.start.field_71574_a, (double)this.start.field_71572_b, (double)this.start.field_71573_c);
                Vec3 vEnd = Vec3.func_72443_a((double)this.end.field_71574_a, (double)this.end.field_71572_b, (double)this.end.field_71573_c);
                IImmersiveConnectable iicStart = ApiUtils.toIIC(this.start, world);
                IImmersiveConnectable iicEnd = ApiUtils.toIIC(this.end, world);
                if (iicStart != null) {
                    vStart = ApiUtils.addVectors(vStart, iicStart.getConnectionOffset(this));
                }
                if (iicEnd != null) {
                    vEnd = ApiUtils.addVectors(vEnd, iicEnd.getConnectionOffset(this));
                }
                this.catenaryVertices = ApiUtils.getConnectionCatenary(this, vStart, vEnd);
            }
            return this.catenaryVertices;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.start != null) {
                tag.func_74783_a("start", new int[]{this.start.field_71574_a, this.start.field_71572_b, this.start.field_71573_c});
            }
            if (this.end != null) {
                tag.func_74783_a("end", new int[]{this.end.field_71574_a, this.end.field_71572_b, this.end.field_71573_c});
            }
            tag.func_74778_a("cableType", this.cableType.getUniqueName());
            tag.func_74768_a("length", this.length);
            return tag;
        }

        public static Connection readFromNBT(NBTTagCompound tag) {
            if (tag == null) {
                return null;
            }
            int[] iStart = tag.func_74759_k("start");
            ChunkCoordinates start = new ChunkCoordinates(iStart[0], iStart[1], iStart[2]);
            int[] iEnd = tag.func_74759_k("end");
            ChunkCoordinates end = new ChunkCoordinates(iEnd[0], iEnd[1], iEnd[2]);
            WireType type = ApiUtils.getWireTypeFromNBT(tag, "cableType");
            if (start != null && end != null && type != null) {
                return new Connection(start, end, type, tag.func_74762_e("length"));
            }
            return null;
        }

        @Override
        public int compareTo(Connection o) {
            if (this.equals(o)) {
                return 0;
            }
            int distComp = Integer.compare(this.length, o.length);
            int cableComp = -1 * Integer.compare(this.cableType.getTransferRate(), o.cableType.getTransferRate());
            if (cableComp != 0) {
                return cableComp;
            }
            if (distComp != 0) {
                return distComp;
            }
            if (this.start.field_71574_a != o.start.field_71574_a) {
                return this.start.field_71574_a > o.start.field_71574_a ? 1 : -1;
            }
            if (this.start.field_71572_b != o.start.field_71572_b) {
                return this.start.field_71572_b > o.start.field_71572_b ? 1 : -1;
            }
            if (this.start.field_71573_c != o.start.field_71573_c) {
                return this.start.field_71573_c > o.start.field_71573_c ? 1 : -1;
            }
            if (this.end.field_71574_a != o.end.field_71574_a) {
                return this.end.field_71574_a > o.end.field_71574_a ? 1 : -1;
            }
            if (this.end.field_71572_b != o.end.field_71572_b) {
                return this.end.field_71572_b > o.end.field_71572_b ? 1 : -1;
            }
            if (this.end.field_71573_c != o.end.field_71573_c) {
                return this.end.field_71573_c > o.end.field_71573_c ? 1 : -1;
            }
            return 0;
        }
    }
}

