/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.packs.misc.core;

import com.jaquadro.minecraft.storagedrawers.api.IStorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.config.IBlockConfig;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.misc.StorageDrawersPack;
import com.jaquadro.minecraft.storagedrawers.packs.misc.core.DataResolver;
import com.jaquadro.minecraft.storagedrawers.packs.misc.core.ModBlocks;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    public void init() {
        IStorageDrawersApi api = StorageDrawersApi.instance();
        if (api == null) {
            return;
        }
        IBlockConfig blockConfig = api.userConfig().blockConfig();
        String nameFull1 = blockConfig.getBlockConfigName(BlockConfiguration.BasicFull1);
        String nameFull2 = blockConfig.getBlockConfigName(BlockConfiguration.BasicFull2);
        String nameFull4 = blockConfig.getBlockConfigName(BlockConfiguration.BasicFull4);
        String nameHalf2 = blockConfig.getBlockConfigName(BlockConfiguration.BasicHalf2);
        String nameHalf4 = blockConfig.getBlockConfigName(BlockConfiguration.BasicHalf4);
        String nameTrim = blockConfig.getBlockConfigName(BlockConfiguration.Trim);
        Block[] planks = new Block[]{GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"planks"), GameRegistry.findBlock((String)"Highlands", (String)"hl_woodPlanks"), GameRegistry.findBlock((String)"Thaumcraft", (String)"blockWoodenDevice"), GameRegistry.findBlock((String)"witchery", (String)"witchwood"), GameRegistry.findBlock((String)"ImmersiveEngineering", (String)"treatedWood"), GameRegistry.findBlock((String)"Botania", (String)"livingwood"), GameRegistry.findBlock((String)"Botania", (String)"dreamwood")};
        Block[][] slabs = new Block[][]{{GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"woodslab"), GameRegistry.findBlock((String)"ExtrabiomesXL", (String)"woodslab2")}, {GameRegistry.findBlock((String)"Highlands", (String)"hl_woodSlab"), null}, {GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCosmeticSlabWood"), null}, {GameRegistry.findBlock((String)"witchery", (String)"witchwoodslab"), null}, {GameRegistry.findBlock((String)"ImmersiveEngineering", (String)"woodenDecoration"), null}, {GameRegistry.findBlock((String)"Botania", (String)"livingwood1Slab"), null}, {GameRegistry.findBlock((String)"Botania", (String)"dreamwood1Slab"), null}};
        IPackDataResolver[] resolvers = StorageDrawersPack.instance.resolvers;
        for (int p = 0; p < resolvers.length; ++p) {
            IPackDataResolver resolver = resolvers[p];
            for (int i = 0; i < 16; ++i) {
                Block slab;
                if (!resolver.isValidMetaValue(i)) continue;
                int bank = DataResolver.modBankMap[p][i];
                int meta = DataResolver.modMetaMap[p][i];
                int slabMeta = DataResolver.modSlabMetaMap[p][i];
                Block plank = planks[bank];
                if (plank != null) {
                    if (blockConfig.isBlockEnabled(nameFull1)) {
                        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.fullDrawers1[p], blockConfig.getBlockRecipeOutput(nameFull1), i), new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), new ItemStack(plank, 1, meta), Character.valueOf('y'), "chestWood"}));
                    }
                    if (blockConfig.isBlockEnabled(nameFull2)) {
                        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.fullDrawers2[p], blockConfig.getBlockRecipeOutput(nameFull2), i), new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack(plank, 1, meta), Character.valueOf('y'), "chestWood"}));
                    }
                    if (blockConfig.isBlockEnabled(nameFull4)) {
                        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.fullDrawers4[p], blockConfig.getBlockRecipeOutput(nameFull4), i), new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack(plank, 1, meta), Character.valueOf('y'), "chestWood"}));
                    }
                    if (blockConfig.isBlockEnabled(nameTrim)) {
                        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.trim[p], blockConfig.getBlockRecipeOutput(nameTrim), i), new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack(plank, 1, meta)}));
                    }
                }
                Block block = slab = slabMeta < 8 ? slabs[bank][0] : slabs[bank][1];
                if (slab == null) continue;
                if (blockConfig.isBlockEnabled(nameHalf2)) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.halfDrawers2[p], blockConfig.getBlockRecipeOutput(nameHalf2), i), new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack(slab, 1, slabMeta), Character.valueOf('y'), "chestWood"}));
                }
                if (!blockConfig.isBlockEnabled(nameHalf4)) continue;
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ModBlocks.halfDrawers4[p], blockConfig.getBlockRecipeOutput(nameHalf4), i), new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack(slab, 1, slabMeta), Character.valueOf('y'), "chestWood"}));
            }
        }
    }
}

