/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalfoundation.fluid.TFFluids;
import cofh.thermalfoundation.item.TFItems;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TransposerManager {
    private static Map<List<Integer>, RecipeTransposer> recipeMapFill = new THashMap();
    private static Map<ComparableItemStack, RecipeTransposer> recipeMapExtraction = new THashMap();
    private static Set<ComparableItemStack> validationSet = new THashSet();
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 1600;

    public static RecipeTransposer getFillRecipe(ItemStack itemStack, FluidStack fluidStack) {
        return itemStack == null || fluidStack == null || fluidStack.getFluid() == null ? null : recipeMapFill.get(Arrays.asList(new ComparableItemStack(itemStack).hashCode(), fluidStack.getFluid().hashCode()));
    }

    public static RecipeTransposer getExtractionRecipe(ItemStack itemStack) {
        return itemStack == null ? null : recipeMapExtraction.get(new ComparableItemStack(itemStack));
    }

    public static boolean fillRecipeExists(ItemStack itemStack, FluidStack fluidStack) {
        return TransposerManager.getFillRecipe(itemStack, fluidStack) != null;
    }

    public static boolean extractionRecipeExists(ItemStack itemStack, FluidStack fluidStack) {
        return TransposerManager.getExtractionRecipe(itemStack) != null;
    }

    public static RecipeTransposer[] getFillRecipeList() {
        return recipeMapFill.values().toArray(new RecipeTransposer[0]);
    }

    public static RecipeTransposer[] getExtractionRecipeList() {
        return recipeMapExtraction.values().toArray(new RecipeTransposer[0]);
    }

    public static boolean isItemValid(ItemStack itemStack) {
        return itemStack == null ? false : validationSet.contains(new ComparableItemStack(itemStack));
    }

    public static void addDefaultRecipes() {
        String string = "RecipeManagers.Transposer.Recipes";
        boolean bl = ThermalExpansion.config.get(string, "MossyCobblestone", true);
        boolean bl2 = ThermalExpansion.config.get(string, "MossyStoneBrick", true);
        boolean bl3 = ThermalExpansion.config.get(string, "EndStone", true);
        boolean bl4 = ThermalExpansion.config.get(string, "PackedIce", true);
        boolean bl5 = ThermalExpansion.config.get(string, "NetherBrick", false);
        if (bl) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y), new FluidStack(FluidRegistry.WATER, 250), false);
        }
        if (bl2) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150417_aV), new ItemStack(Blocks.field_150417_aV, 1, 1), new FluidStack(FluidRegistry.WATER, 250), false);
        }
        if (bl3) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150322_A), new ItemStack(Blocks.field_150377_bs), new FluidStack(TFFluids.fluidEnder, 250), false);
        }
        if (bl4) {
            TransposerManager.addFillRecipe(8000, new ItemStack(Blocks.field_150432_aD), new ItemStack(Blocks.field_150403_cj), new FluidStack(TFFluids.fluidCryotheum, 250), false);
        }
        if (bl5) {
            TransposerManager.addFillRecipe(4000, new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151130_bT), new FluidStack(FluidRegistry.LAVA, 250), false);
        }
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Items.field_151114_aO), new ItemStack(Items.field_151065_br), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Items.field_151126_ay), ItemHelper.cloneStack((ItemStack)TFItems.dustBlizz, (int)1), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack((Block)Blocks.field_150354_m), ItemHelper.cloneStack((ItemStack)TFItems.dustBlitz), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, ItemHelper.cloneStack((ItemStack)TFItems.dustObsidian, (int)1), ItemHelper.cloneStack((ItemStack)TFItems.dustBasalz, (int)1), new FluidStack(TFFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketRedstone, (int)1), new FluidStack(TFFluids.fluidRedstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketGlowstone, (int)1), new FluidStack(TFFluids.fluidGlowstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketEnder, (int)1), new FluidStack(TFFluids.fluidEnder, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketPyrotheum, (int)1), new FluidStack(TFFluids.fluidPyrotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketCryotheum, (int)1), new FluidStack(TFFluids.fluidCryotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketAerotheum, (int)1), new FluidStack(TFFluids.fluidAerotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketPetrotheum, (int)1), new FluidStack(TFFluids.fluidPetrotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Items.field_151133_ar), ItemHelper.cloneStack((ItemStack)TFItems.bucketCoal, (int)1), new FluidStack(TFFluids.fluidCoal, 1000), true);
    }

    public static void loadRecipes() {
        TransposerManager.addFillRecipe(1600, ItemHelper.getOre((String)"oreCinnabar"), ItemHelper.cloneStack((ItemStack)TFItems.crystalCinnabar, (int)1), new FluidStack(TFFluids.fluidCryotheum, 200), false);
        for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (FluidContainerRegistry.isBucket((ItemStack)fluidContainerData.emptyContainer)) {
                TransposerManager.addFillRecipe(800, fluidContainerData, true);
                continue;
            }
            TransposerManager.addFillRecipe(1600, fluidContainerData, true);
        }
    }

    public static void refreshRecipes() {
        ComparableItemStack comparableItemStack;
        RecipeTransposer recipeTransposer;
        THashMap tHashMap = new THashMap(recipeMapFill.size());
        THashMap tHashMap2 = new THashMap(recipeMapExtraction.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<List<Integer>, RecipeTransposer> entry : recipeMapFill.entrySet()) {
            recipeTransposer = entry.getValue();
            comparableItemStack = new ComparableItemStack(recipeTransposer.input);
            FluidStack fluidStack = recipeTransposer.fluid.copy();
            tHashMap.put(Arrays.asList(comparableItemStack.hashCode(), fluidStack.getFluid().hashCode()), recipeTransposer);
            tHashSet.add(comparableItemStack);
        }
        for (Map.Entry<List<Integer>, RecipeTransposer> entry : recipeMapExtraction.entrySet()) {
            recipeTransposer = entry.getValue();
            comparableItemStack = new ComparableItemStack(recipeTransposer.input);
            tHashMap2.put(comparableItemStack, recipeTransposer);
            tHashSet.add(comparableItemStack);
        }
        recipeMapFill.clear();
        recipeMapFill = tHashMap;
        recipeMapExtraction.clear();
        recipeMapExtraction = tHashMap2;
        validationSet.clear();
        validationSet = tHashSet;
    }

    public static boolean addTEFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl) {
        if (itemStack == null || itemStack2 == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, 100);
        ComparableItemStack comparableItemStack = new ComparableItemStack(itemStack);
        recipeMapFill.put(Arrays.asList(comparableItemStack.hashCode(), fluidStack.getFluid().hashCode()), recipeTransposer);
        validationSet.add(comparableItemStack);
        if (bl) {
            TransposerManager.addTEExtractionRecipe(n, itemStack2, itemStack, fluidStack, 100, false);
        }
        return true;
    }

    public static boolean addTEExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl) {
        if (itemStack == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (itemStack2 == null && (bl || n2 != 0)) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, n2);
        ComparableItemStack comparableItemStack = new ComparableItemStack(itemStack);
        recipeMapExtraction.put(comparableItemStack, recipeTransposer);
        validationSet.add(comparableItemStack);
        if (bl) {
            TransposerManager.addTEFillRecipe(n, itemStack2, itemStack, fluidStack, false);
        }
        return true;
    }

    public static boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl, boolean bl2) {
        if (itemStack == null || itemStack2 == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (!(allowOverwrite & bl2) && TransposerManager.fillRecipeExists(itemStack, fluidStack)) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStack(itemStack).hashCode(), fluidStack.getFluid().hashCode()), recipeTransposer);
        validationSet.add(new ComparableItemStack(itemStack));
        if (bl) {
            TransposerManager.addExtractionRecipe(n, itemStack2, itemStack, fluidStack, 100, false, bl2);
        }
        return true;
    }

    public static boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl, boolean bl2) {
        if (itemStack == null || fluidStack == null || fluidStack.getFluid() == null || fluidStack.amount <= 0 || n <= 0) {
            return false;
        }
        if (!bl2 && TransposerManager.extractionRecipeExists(itemStack, fluidStack)) {
            return false;
        }
        if (itemStack2 == null && bl || itemStack2 == null && n2 != 0) {
            return false;
        }
        RecipeTransposer recipeTransposer = new RecipeTransposer(itemStack, itemStack2, fluidStack, n, n2);
        recipeMapExtraction.put(new ComparableItemStack(itemStack), recipeTransposer);
        validationSet.add(new ComparableItemStack(itemStack));
        if (bl) {
            TransposerManager.addFillRecipe(n, itemStack2, itemStack, fluidStack, false, bl2);
        }
        return true;
    }

    public static boolean removeFillRecipe(ItemStack itemStack, FluidStack fluidStack) {
        return recipeMapFill.remove(Arrays.asList(new ComparableItemStack(itemStack).hashCode(), fluidStack.getFluid().hashCode())) != null;
    }

    public static boolean removeExtractionRecipe(ItemStack itemStack) {
        return recipeMapExtraction.remove(new ComparableItemStack(itemStack)) != null;
    }

    public static boolean addFillRecipe(int n, FluidContainerRegistry.FluidContainerData fluidContainerData, boolean bl) {
        return TransposerManager.addFillRecipe(n, fluidContainerData.emptyContainer, fluidContainerData.filledContainer, fluidContainerData.fluid, bl, false);
    }

    public static boolean addFillRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, boolean bl) {
        return TransposerManager.addFillRecipe(n, itemStack, itemStack2, fluidStack, bl, false);
    }

    public static boolean addExtractionRecipe(int n, ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n2, boolean bl) {
        return TransposerManager.addExtractionRecipe(n, itemStack, itemStack2, fluidStack, n2, bl, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Transposer", "AllowRecipeOverwrite", false);
    }

    public static class RecipeTransposer {
        final ItemStack input;
        final ItemStack output;
        final FluidStack fluid;
        final int energy;
        final int chance;

        RecipeTransposer(ItemStack itemStack, ItemStack itemStack2, FluidStack fluidStack, int n, int n2) {
            this.input = itemStack;
            this.output = itemStack2;
            this.fluid = fluidStack;
            this.energy = n;
            this.chance = n2;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            if (this.output != null) {
                return this.output.func_77946_l();
            }
            return null;
        }

        public FluidStack getFluid() {
            return this.fluid.copy();
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

