/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.crafting;

import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.ComparableItem;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.item.TEItems;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InsolatorManager {
    private static Map<List<ComparableItemStackInsolator>, RecipeInsolator> recipeMap = new THashMap();
    private static Set<ComparableItemStackInsolator> validationSet = new THashSet();
    private static Set<ComparableItemStackInsolator> lockSet = new THashSet();
    private static boolean allowOverwrite = false;
    private static int cropMultiplierSpecial = 3;
    public static final int DEFAULT_ENERGY = 7200;
    public static final int DEFAULT_ENERGY_SPECIAL = 9600;

    public static boolean isRecipeReversed(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        ComparableItemStackInsolator comparableItemStackInsolator = new ComparableItemStackInsolator(itemStack);
        ComparableItemStackInsolator comparableItemStackInsolator2 = new ComparableItemStackInsolator(itemStack2);
        RecipeInsolator recipeInsolator = recipeMap.get(Arrays.asList(comparableItemStackInsolator, comparableItemStackInsolator2));
        return recipeInsolator != null ? false : recipeMap.get(Arrays.asList(comparableItemStackInsolator2, comparableItemStackInsolator)) != null;
    }

    public static RecipeInsolator getRecipe(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return null;
        }
        ComparableItemStackInsolator comparableItemStackInsolator = new ComparableItemStackInsolator(itemStack);
        ComparableItemStackInsolator comparableItemStackInsolator2 = new ComparableItemStackInsolator(itemStack2);
        RecipeInsolator recipeInsolator = recipeMap.get(Arrays.asList(comparableItemStackInsolator, comparableItemStackInsolator2));
        if (recipeInsolator == null) {
            recipeInsolator = recipeMap.get(Arrays.asList(comparableItemStackInsolator2, comparableItemStackInsolator));
        }
        if (recipeInsolator == null) {
            return null;
        }
        return recipeInsolator;
    }

    public static boolean recipeExists(ItemStack itemStack, ItemStack itemStack2) {
        return InsolatorManager.getRecipe(itemStack, itemStack2) != null;
    }

    public static RecipeInsolator[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeInsolator[0]);
    }

    public static boolean isItemValid(ItemStack itemStack) {
        return itemStack == null ? false : validationSet.contains((Object)new ComparableItemStackInsolator(itemStack));
    }

    public static boolean isItemFertilizer(ItemStack itemStack) {
        return itemStack == null ? false : lockSet.contains((Object)new ComparableItemStackInsolator(itemStack));
    }

    public static void addDefaultRecipes() {
        String string = "RecipeManagers.Insolator.Recipes";
        boolean bl = ThermalExpansion.config.get(string, "CocoaBean", true);
        boolean bl2 = ThermalExpansion.config.get(string, "Reeds", true);
        boolean bl3 = ThermalExpansion.config.get(string, "Cactus", true);
        boolean bl4 = ThermalExpansion.config.get(string, "Vine", true);
        boolean bl5 = ThermalExpansion.config.get(string, "LilyPad", true);
        boolean bl6 = ThermalExpansion.config.get(string, "Pumpkin", true);
        boolean bl7 = ThermalExpansion.config.get(string, "Melon", true);
        InsolatorManager.addFertilizer(TEItems.fertilizer);
        InsolatorManager.addFertilizer(TEItems.fertilizerRich);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N), 150);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151174_bG, 3), new ItemStack(Items.field_151170_bI), 2);
        InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151172_bF, 3), null, 0);
        if (bl) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack(Items.field_151100_aR, 3, 3), null, 0);
        }
        if (bl2) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151120_aE, 2), null, 0);
        }
        if (bl3) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150434_aF), new ItemStack(Blocks.field_150434_aF, 2), null, 0);
        }
        if (bl4) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150395_bd), new ItemStack(Blocks.field_150395_bd, 2), null, 0);
        }
        if (bl5) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150392_bi, 2), null, 0);
        }
        if (bl6) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151080_bb), new ItemStack(Blocks.field_150423_aK), null, 0);
        }
        if (bl7) {
            InsolatorManager.addDefaultRecipe(new ItemStack(Items.field_151081_bc), new ItemStack(Blocks.field_150440_ba), null, 0);
        }
    }

    public static void loadRecipes() {
        String[] stringArray = OreDictionary.getOreNames();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("seed")) continue;
            string = stringArray[i].substring(4, stringArray[i].length());
            InsolatorManager.addDefaultOreDictionaryRecipe(string);
        }
    }

    public static void refreshRecipes() {
        ComparableItemStackInsolator comparableItemStackInsolator;
        THashMap tHashMap = new THashMap(recipeMap.size());
        THashSet tHashSet = new THashSet();
        for (Map.Entry<List<ComparableItemStackInsolator>, RecipeInsolator> object : recipeMap.entrySet()) {
            RecipeInsolator recipeInsolator = object.getValue();
            ComparableItemStackInsolator comparableItemStackInsolator2 = new ComparableItemStackInsolator(recipeInsolator.primaryInput);
            comparableItemStackInsolator = new ComparableItemStackInsolator(recipeInsolator.secondaryInput);
            tHashMap.put(Arrays.asList(comparableItemStackInsolator2, comparableItemStackInsolator), recipeInsolator);
            tHashSet.add(comparableItemStackInsolator2);
            tHashSet.add(comparableItemStackInsolator);
        }
        recipeMap.clear();
        recipeMap = tHashMap;
        validationSet.clear();
        validationSet = tHashSet;
        THashSet tHashSet2 = new THashSet();
        for (ComparableItemStackInsolator comparableItemStackInsolator2 : lockSet) {
            comparableItemStackInsolator = new ComparableItemStackInsolator(new ItemStack(((ComparableItem)comparableItemStackInsolator2).item, comparableItemStackInsolator2.stackSize, ((ComparableItem)comparableItemStackInsolator2).metadata));
            tHashSet2.add(comparableItemStackInsolator);
        }
        lockSet.clear();
        lockSet = tHashSet2;
    }

    protected static boolean addTERecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2) {
        if (itemStack == null || itemStack2 == null || n <= 0) {
            return false;
        }
        RecipeInsolator recipeInsolator = new RecipeInsolator(itemStack, itemStack2, itemStack3, itemStack4, n2, n);
        recipeMap.put(Arrays.asList(new ComparableItemStackInsolator(itemStack), new ComparableItemStackInsolator(itemStack2)), recipeInsolator);
        validationSet.add(new ComparableItemStackInsolator(itemStack));
        validationSet.add(new ComparableItemStackInsolator(itemStack2));
        return true;
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2, boolean bl) {
        if (itemStack == null || itemStack2 == null || n <= 0 || !(allowOverwrite & bl) && InsolatorManager.recipeExists(itemStack, itemStack2)) {
            return false;
        }
        RecipeInsolator recipeInsolator = new RecipeInsolator(itemStack, itemStack2, itemStack3, itemStack4, n2, n);
        recipeMap.put(Arrays.asList(new ComparableItemStackInsolator(itemStack), new ComparableItemStackInsolator(itemStack2)), recipeInsolator);
        validationSet.add(new ComparableItemStackInsolator(itemStack));
        validationSet.add(new ComparableItemStackInsolator(itemStack2));
        return true;
    }

    public static boolean removeRecipe(ItemStack itemStack, ItemStack itemStack2) {
        return recipeMap.remove(Arrays.asList(new ComparableItemStackInsolator(itemStack), new ComparableItemStackInsolator(itemStack2))) != null;
    }

    private static void addFertilizer(ItemStack itemStack) {
        lockSet.add(new ComparableItemStackInsolator(itemStack));
    }

    public static void addDefaultOreDictionaryRecipe(String string) {
        if (string.length() <= 0) {
            return;
        }
        String string2 = "seed" + StringHelper.titleCase((String)string);
        String string3 = "crop" + StringHelper.titleCase((String)string);
        ArrayList arrayList = OreDictionary.getOres((String)string2);
        ArrayList arrayList2 = OreDictionary.getOres((String)string3);
        if (arrayList.isEmpty() || arrayList2.isEmpty()) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList2.size(); ++j) {
                if (!ItemHelper.itemsEqualWithMetadata((ItemStack)((ItemStack)arrayList.get(i)), (ItemStack)((ItemStack)arrayList2.get(j)))) continue;
                bl = true;
            }
        }
        if (ItemHelper.isBlock((ItemStack)((ItemStack)arrayList2.get(0)))) {
            bl2 = true;
        }
        ItemStack itemStack = ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList.get(0)), (int)1);
        ItemStack itemStack2 = ItemHelper.cloneStack((ItemStack)((ItemStack)arrayList2.get(0)), (int)(bl ? 3 : 1));
        if (bl2 || bl) {
            InsolatorManager.addDefaultRecipe(itemStack, itemStack2, null, 0);
        } else {
            InsolatorManager.addDefaultRecipe(itemStack, itemStack2, itemStack, 150);
        }
    }

    public static void addDefaultRecipe(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, int n) {
        if (itemStack3 != null) {
            InsolatorManager.addRecipe(7200, itemStack, TEItems.fertilizer, itemStack2, itemStack3, n);
            if (n < 100) {
                n = Math.min(100, n * cropMultiplierSpecial);
            }
            InsolatorManager.addRecipe(9600, itemStack, TEItems.fertilizerRich, ItemHelper.cloneStack((ItemStack)itemStack2, (int)(itemStack2.field_77994_a * cropMultiplierSpecial)), itemStack3, n);
        } else {
            InsolatorManager.addRecipe(7200, itemStack, TEItems.fertilizer, itemStack2);
            InsolatorManager.addRecipe(9600, itemStack, TEItems.fertilizerRich, ItemHelper.cloneStack((ItemStack)itemStack2, (int)(itemStack2.field_77994_a * cropMultiplierSpecial)));
        }
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3) {
        return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, boolean bl) {
        return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, null, 0, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4) {
        return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, false);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, boolean bl) {
        return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, 100, bl);
    }

    public static boolean addRecipe(int n, ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n2) {
        return InsolatorManager.addRecipe(n, itemStack, itemStack2, itemStack3, itemStack4, n2, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("RecipeManagers.Insolator", "AllowRecipeOverwrite", false);
        String string = "RecipeManagers.Insolator.Crop";
        String string2 = "This sets the boosted rate for Crop growth - when Rich Phyto-Gro is used. This number is used in all automatically generated recipes.";
        cropMultiplierSpecial = MathHelper.clampI((int)ThermalExpansion.config.get(string, "DefaultMultiplier", cropMultiplierSpecial, string2), (int)1, (int)64);
    }

    public static class ComparableItemStackInsolator
    extends ComparableItemStack {
        static final String SEED = "seed";
        static final String CROP = "crop";

        public static boolean safeOreType(String string) {
            return string.startsWith(SEED) || string.startsWith(CROP);
        }

        public static int getOreID(ItemStack itemStack) {
            int n = ItemHelper.oreProxy.getOreID(itemStack);
            if (n == -1 || !ComparableItemStackInsolator.safeOreType(ItemHelper.oreProxy.getOreName(n))) {
                return -1;
            }
            return n;
        }

        public static int getOreID(String string) {
            if (!ComparableItemStackInsolator.safeOreType(string)) {
                return -1;
            }
            return ItemHelper.oreProxy.getOreID(string);
        }

        public ComparableItemStackInsolator(ItemStack itemStack) {
            super(itemStack);
            this.oreID = ComparableItemStackInsolator.getOreID(itemStack);
        }

        public ComparableItemStackInsolator(Item item, int n, int n2) {
            super(item, n, n2);
            this.oreID = ComparableItemStackInsolator.getOreID(this.toItemStack());
        }

        public ComparableItemStackInsolator set(ItemStack itemStack) {
            super.set(itemStack);
            this.oreID = ComparableItemStackInsolator.getOreID(itemStack);
            return this;
        }
    }

    public static class RecipeInsolator {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeInsolator(ItemStack itemStack, ItemStack itemStack2, ItemStack itemStack3, ItemStack itemStack4, int n, int n2) {
            this.primaryInput = itemStack;
            this.secondaryInput = itemStack2;
            this.primaryOutput = itemStack3;
            this.secondaryOutput = itemStack4;
            this.secondaryChance = n;
            this.energy = n2;
            if (itemStack.field_77994_a <= 0) {
                itemStack.field_77994_a = 1;
            }
            if (itemStack2.field_77994_a <= 0) {
                itemStack2.field_77994_a = 1;
            }
            if (itemStack3.field_77994_a <= 0) {
                itemStack3.field_77994_a = 1;
            }
            if (itemStack4 != null && itemStack4.field_77994_a <= 0) {
                itemStack4.field_77994_a = 1;
            }
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput.func_77946_l();
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

