/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.device;

import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabSecurity;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.thermalexpansion.block.device.TileWorkbench;
import cofh.thermalexpansion.gui.container.device.ContainerWorkbench;
import cofh.thermalexpansion.network.PacketTEBase;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiWorkbench
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/device/Workbench.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/device/Workbench.png");
    public TileWorkbench myTile;
    UUID playerName;
    ElementButton setSchematic;
    ElementButton getSchematic;

    public GuiWorkbench(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new ContainerWorkbench(inventoryPlayer, tileEntity), TEXTURE);
        this.myTile = (TileWorkbench)tileEntity;
        ((GuiBase)this).name = this.myTile.func_145825_b();
        this.playerName = SecurityHelper.getID((EntityPlayer)inventoryPlayer.field_70458_d);
        ((GuiContainer)this).field_147000_g = 210;
        this.generateInfo("tab.thermalexpansion.device.workbench", 3);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerName));
        }
        this.setSchematic = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, 98, 55, "Set", 176, 32, 176, 48, 176, 64, 16, 16, TEX_PATH));
        this.getSchematic = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, 98, 19, "Get", 192, 32, 192, 48, 192, 64, 16, 16, TEX_PATH));
    }

    protected void func_146976_a(float f, int n, int n2) {
        super.func_146976_a(f, n, n2);
        ((GuiScreen)this).field_146297_k.field_71446_o.func_110577_a(((GuiBase)this).texture);
        this.drawCurSelection();
        this.drawCurMissing();
    }

    protected void updateElementInformation() {
        if (this.gridNotEmpty()) {
            this.getSchematic.setToolTip("info.thermalexpansion.gridClear");
            this.getSchematic.setSheetX(208);
            this.getSchematic.setHoverX(208);
            this.getSchematic.setActive();
        } else if (this.hasValidSchematic()) {
            this.getSchematic.setToolTip("info.thermalexpansion.gridSet");
            this.getSchematic.setSheetX(192);
            this.getSchematic.setHoverX(192);
            this.getSchematic.setActive();
        } else {
            this.getSchematic.clearToolTip();
            this.getSchematic.setDisabled();
        }
        if (((ContainerWorkbench)((GuiContainer)this).field_147002_h).canWriteSchematic()) {
            this.setSchematic.setToolTip("info.thermalexpansion.writeSchematic");
            this.setSchematic.setActive();
        } else if (this.hasSchematic()) {
            this.setSchematic.setToolTip("info.thermalexpansion.noSchematic");
            this.setSchematic.setDisabled();
        } else {
            this.setSchematic.setToolTip("info.thermalexpansion.noRecipe");
            this.setSchematic.setDisabled();
        }
        if (this.myTile.updateClient) {
            this.myTile.createItemClient(false, ((ContainerWorkbench)((GuiContainer)this).field_147002_h).myOutput.getStackNoUpdate());
            this.myTile.updateClient = false;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        if (string.equals("Set")) {
            if (((ContainerWorkbench)((GuiContainer)this).field_147002_h).canWriteSchematic()) {
                PacketTEBase.sendTabSchematicPacketToServer();
                GuiWorkbench.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            }
        } else if (string.equals("Get")) {
            if (this.gridNotEmpty()) {
                this.myTile.clearCraftingGrid();
                GuiWorkbench.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            } else if (this.hasValidSchematic()) {
                this.myTile.setCraftingGrid();
                GuiWorkbench.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            }
        }
    }

    public void overlayRecipe() {
        if (!this.gridNotEmpty()) {
            this.getSchematic.setToolTip("info.thermalexpansion.gridSet");
            this.getSchematic.setSheetX(192);
            this.getSchematic.setHoverX(192);
        } else {
            this.getSchematic.setToolTip("info.thermalexpansion.gridClear");
            this.getSchematic.setSheetX(208);
            this.getSchematic.setHoverX(208);
        }
    }

    protected boolean gridNotEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.myTile.getInventorySlots(0)[i] == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSchematic() {
        return this.myTile.inventory[this.myTile.getCurrentSchematicSlot()] != null;
    }

    protected boolean hasValidSchematic() {
        return this.myTile.inventory[this.myTile.getCurrentSchematicSlot()] != null && this.myTile.inventory[this.myTile.getCurrentSchematicSlot()].field_77990_d != null;
    }

    protected void drawCurMissing() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!this.myTile.missingItem[j + i * 3]) continue;
                this.func_73729_b(((GuiContainer)this).field_147003_i + 44 + j * 18, ((GuiContainer)this).field_147009_r + 19 + i * 18, 176, 80, 16, 16);
            }
        }
    }

    protected void drawCurSelection() {
        int n = 0;
        if (!this.hasSchematic()) {
            n = 32;
        }
        switch (this.myTile.selectedSchematic) {
            case 0: {
                this.func_73729_b(((GuiContainer)this).field_147003_i + 15, ((GuiContainer)this).field_147009_r + 15, 176 + n, 0, 20, 20);
                break;
            }
            case 1: {
                this.func_73729_b(((GuiContainer)this).field_147003_i + 15, ((GuiContainer)this).field_147009_r + 35, 176 + n, 0, 20, 20);
                break;
            }
            case 2: {
                this.func_73729_b(((GuiContainer)this).field_147003_i + 15, ((GuiContainer)this).field_147009_r + 55, 176 + n, 0, 20, 20);
            }
        }
    }
}

