/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.network.PacketCoFHBase;
import cofh.core.util.CoreUtils;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiInsolator;
import cofh.thermalexpansion.gui.container.machine.ContainerInsolator;
import cofh.thermalexpansion.util.crafting.InsolatorManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileInsolator
extends TileMachineBase
implements IFluidHandler {
    static final int TYPE = BlockMachine.Types.INSOLATOR.ordinal();
    int inputTrackerPrimary;
    int inputTrackerSecondary;
    int outputTrackerPrimary;
    int outputTrackerSecondary;
    public boolean lockPrimary = false;
    FluidTankAdv tank = new FluidTankAdv(10000);

    public static void initialize() {
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].numConfig = 8;
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}, {0, 1, 2, 3}};
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].allowInsertionSide = new boolean[]{false, true, false, false, false, true, true, true};
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].allowExtractionSide = new boolean[]{false, true, true, true, true, false, false, true};
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false};
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, false};
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].sideTex = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        TileMachineBase.defaultSideConfig[TileInsolator.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        String string = "Machine.Insolator";
        int n = MathHelper.clampI((int)ThermalExpansion.config.get(string, "BasePower", 20), (int)10, (int)500);
        ThermalExpansion.config.set(string, "BasePower", n);
        TileMachineBase.defaultEnergyConfig[TileInsolator.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(n);
        TileMachineBase.sounds[TileInsolator.TYPE] = CoreUtils.getSoundName((String)"ThermalExpansion", (String)"blockMachineInsolator");
        GameRegistry.registerTileEntity(TileInsolator.class, (String)"thermalexpansion.Insolator");
    }

    public TileInsolator() {
        this.inventory = new ItemStack[5];
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        if (this.isActive) {
            if (this.processRem > 0) {
                int n = this.calcEnergy();
                this.energyStorage.modifyEnergyStored(-n * this.energyMod);
                this.processRem -= n * this.processMod;
                this.tank.drain(n * this.processMod / 10, true);
            }
            if (this.canFinish()) {
                this.processFinish();
                this.transferOutput();
                this.transferInput();
                this.energyStorage.modifyEnergyStored(-this.processRem * this.energyMod / this.processMod);
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(((TileEntity)this).field_145850_b);
                } else {
                    this.processStart();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                int n = this.calcEnergy();
                this.energyStorage.modifyEnergyStored(-n * this.energyMod);
                this.processRem -= n * this.processMod;
                this.tank.drain(n * this.processMod / 10, true);
                this.isActive = true;
            }
        }
        this.updateIfChanged(bl);
        this.chargeEnergy();
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null && this.inventory[1] == null) {
            return false;
        }
        InsolatorManager.RecipeInsolator recipeInsolator = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipeInsolator == null || this.energyStorage.getEnergyStored() < recipeInsolator.getEnergy() * this.energyMod / this.processMod || this.tank.getFluidAmount() < recipeInsolator.getEnergy() / 10) {
            return false;
        }
        if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipeInsolator.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipeInsolator.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipeInsolator.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipeInsolator.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a) {
            return false;
        }
        ItemStack itemStack = recipeInsolator.getPrimaryOutput();
        ItemStack itemStack2 = recipeInsolator.getSecondaryOutput();
        if (!this.augmentSecondaryNull && itemStack2 != null && this.inventory[3] != null) {
            if (!this.inventory[3].func_77969_a(itemStack2)) {
                return false;
            }
            if (this.inventory[3].field_77994_a + itemStack2.field_77994_a > itemStack2.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(itemStack)) {
            return false;
        }
        return this.inventory[2].field_77994_a + itemStack.field_77994_a <= itemStack.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        InsolatorManager.RecipeInsolator recipeInsolator = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipeInsolator == null) {
            return false;
        }
        return !(InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipeInsolator.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipeInsolator.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipeInsolator.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipeInsolator.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]).getEnergy();
    }

    @Override
    protected void processFinish() {
        int n;
        InsolatorManager.RecipeInsolator recipeInsolator = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipeInsolator == null) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(((TileEntity)this).field_145850_b);
            this.processRem = 0;
            return;
        }
        ItemStack itemStack = recipeInsolator.getPrimaryOutput();
        ItemStack itemStack2 = recipeInsolator.getSecondaryOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = itemStack;
        } else {
            this.inventory[2].field_77994_a += itemStack.field_77994_a;
        }
        if (itemStack2 != null && ((n = recipeInsolator.getSecondaryOutputChance()) >= 100 || ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n)) {
            if (this.inventory[3] == null) {
                this.inventory[3] = itemStack2;
                if (this.secondaryChance < n && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n - this.secondaryChance) {
                    this.inventory[3].field_77994_a += itemStack2.field_77994_a;
                }
            } else if (this.inventory[3].func_77969_a(itemStack2)) {
                this.inventory[3].field_77994_a += itemStack2.field_77994_a;
                if (this.secondaryChance < n && ((TileEntity)this).field_145850_b.field_73012_v.nextInt(this.secondaryChance) < n - this.secondaryChance) {
                    this.inventory[3].field_77994_a += itemStack2.field_77994_a;
                }
            }
            if (this.inventory[3].field_77994_a > this.inventory[3].func_77976_d()) {
                this.inventory[3].field_77994_a = this.inventory[3].func_77976_d();
            }
        }
        if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            this.inventory[1].field_77994_a -= recipeInsolator.getPrimaryInput().field_77994_a;
            this.inventory[0].field_77994_a -= recipeInsolator.getSecondaryInput().field_77994_a;
        } else {
            this.inventory[0].field_77994_a -= recipeInsolator.getPrimaryInput().field_77994_a;
            this.inventory[1].field_77994_a -= recipeInsolator.getSecondaryInput().field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
    }

    @Override
    protected void transferInput() {
        int n;
        int n2;
        if (!this.augmentAutoInput) {
            return;
        }
        for (n2 = this.inputTrackerPrimary + 1; n2 <= this.inputTrackerPrimary + 6; ++n2) {
            n = n2 % 6;
            if (this.sideCache[n] != 1 && this.sideCache[n] != 5 || !this.extractItem(0, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.inputTrackerPrimary = n;
            break;
        }
        for (n2 = this.inputTrackerPrimary + 1; n2 <= this.inputTrackerPrimary + 6; ++n2) {
            n = n2 % 6;
            if (this.sideCache[n] != 1 && this.sideCache[n] != 6 || !this.extractItem(1, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.inputTrackerSecondary = n;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int n;
        int n2;
        if (!this.augmentAutoOutput) {
            return;
        }
        if (this.inventory[2] != null) {
            for (n2 = this.outputTrackerPrimary + 1; n2 <= this.outputTrackerPrimary + 6; ++n2) {
                n = n2 % 6;
                if (this.sideCache[n] != 2 && this.sideCache[n] != 4 || !this.transferItem(2, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
                this.outputTrackerPrimary = n;
                break;
            }
        }
        if (this.inventory[3] == null) {
            return;
        }
        for (n2 = this.outputTrackerSecondary + 1; n2 <= this.outputTrackerSecondary + 6; ++n2) {
            n = n2 % 6;
            if (this.sideCache[n] != 3 && this.sideCache[n] != 4 || !this.transferItem(3, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.outputTrackerSecondary = n;
            break;
        }
    }

    @Override
    protected void onLevelChange() {
        super.onLevelChange();
        this.tank.setCapacity(10000 * TileMachineBase.FLUID_CAPACITY[this.level]);
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!super.readPortableTagInternal(entityPlayer, nBTTagCompound)) {
            return false;
        }
        this.lockPrimary = nBTTagCompound.func_74767_n("SlotLock");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!super.writePortableTagInternal(entityPlayer, nBTTagCompound)) {
            return false;
        }
        nBTTagCompound.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiInsolator(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerInsolator(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public void receiveGuiNetworkData(int n, int n2) {
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, 0, this.tank.getFluidAmount());
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.inputTrackerPrimary = nBTTagCompound.func_74762_e("TrackIn1");
        this.inputTrackerSecondary = nBTTagCompound.func_74762_e("TrackIn2");
        this.outputTrackerPrimary = nBTTagCompound.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nBTTagCompound.func_74762_e("Tracker2");
        this.lockPrimary = nBTTagCompound.func_74767_n("SlotLock");
        this.tank.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("TrackIn1", this.inputTrackerPrimary);
        nBTTagCompound.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nBTTagCompound.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nBTTagCompound.func_74768_a("Tracker2", this.outputTrackerSecondary);
        nBTTagCompound.func_74757_a("SlotLock", this.lockPrimary);
        this.tank.writeToNBT(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addBool(this.lockPrimary);
        packetCoFHBase.addInt(this.tank.getFluidAmount());
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addBool(this.lockPrimary);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.lockPrimary = packetCoFHBase.getBool();
        this.tank.getFluid().amount = packetCoFHBase.getInt();
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.lockPrimary = packetCoFHBase.getBool();
        this.func_70296_d();
        this.callNeighborTileChange();
    }

    public void setMode(boolean bl) {
        boolean bl2 = this.lockPrimary;
        this.lockPrimary = bl;
        this.sendModePacket();
        this.lockPrimary = bl2;
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        if (this.lockPrimary) {
            if (n == 0) {
                return InsolatorManager.isItemFertilizer(itemStack);
            }
            if (n == 1) {
                return !InsolatorManager.isItemFertilizer(itemStack) && InsolatorManager.isItemValid(itemStack);
            }
        }
        return n <= 1 ? InsolatorManager.isItemValid(itemStack) : true;
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return this.tank.fill(fluidStack, bl);
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

