/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.api.core.ICustomInventory;
import cofh.api.item.IAugmentItem;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiExtruder;
import cofh.thermalexpansion.gui.container.machine.ContainerExtruder;
import cofh.thermalexpansion.item.TEAugments;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileExtruder
extends TileMachineBase
implements ICustomInventory,
IFluidHandler {
    static final int TYPE = BlockMachine.Types.EXTRUDER.ordinal();
    public byte processLevel;
    static int[] processLava = new int[]{0, 0, 1000};
    static int[][] processWater = new int[][]{{0, 1000, 1000}, {0, 500, 500}, {0, 250, 250}, {0, 125, 125}};
    static int[][] processTime = new int[][]{{40, 80, 120}, {40, 80, 60}, {40, 80, 30}, {40, 80, 15}};
    static ItemStack[] processItems = new ItemStack[3];
    ItemStack[] outputItems = new ItemStack[3];
    int outputTracker;
    byte curSelection;
    byte prevSelection;
    FluidStack hotRenderFluid = new FluidStack(FluidRegistry.LAVA, 0);
    FluidStack coldRenderFluid = new FluidStack(FluidRegistry.WATER, 0);
    FluidTankAdv hotTank = new FluidTankAdv(4000);
    FluidTankAdv coldTank = new FluidTankAdv(4000);

    public static void initialize() {
        processItems = new ItemStack[3];
        TileExtruder.processItems[0] = new ItemStack(Blocks.field_150347_e);
        TileExtruder.processItems[1] = new ItemStack(Blocks.field_150348_b);
        TileExtruder.processItems[2] = new ItemStack(Blocks.field_150343_Z);
        ThermalExpansion.config.removeCategory("RecipeManagers.Extruder.Recipes");
        ThermalExpansion.config.removeCategory("RecipeManagers.Extruder");
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE] = new TileTEBase.SideConfig();
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].numConfig = 4;
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, {0}};
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].allowInsertionSide = new boolean[]{false, true, false, true};
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].allowExtractionSide = new boolean[]{false, false, true, true};
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].sideTex = new int[]{0, 1, 4, 7};
        TileMachineBase.defaultSideConfig[TileExtruder.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileMachineBase.defaultEnergyConfig[TileExtruder.TYPE] = new TileTEBase.EnergyConfig();
        TileMachineBase.defaultEnergyConfig[TYPE].setParamsPower(0);
        GameRegistry.registerTileEntity(TileExtruder.class, (String)"thermalexpansion.Extruder");
    }

    public TileExtruder() {
        this.inventory = new ItemStack[1];
        for (int i = 0; i < 3; ++i) {
            this.outputItems[i] = processItems[i].func_77946_l();
        }
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_145845_h() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return;
        }
        boolean bl = this.isActive;
        if (this.isActive) {
            if (this.processRem > 0) {
                this.processRem -= this.processMod;
            }
            if (this.canFinish()) {
                this.processFinish();
                this.transferOutput();
                this.processRem = this.processMax;
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(((TileEntity)this).field_145850_b);
                } else {
                    this.processStart();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
            }
            if (this.timeCheckEighth() && this.canStart()) {
                this.processStart();
                this.processRem -= this.processMod;
                this.isActive = true;
            }
        }
        this.updateIfChanged(bl);
    }

    @Override
    protected boolean canStart() {
        if (this.hotTank.getFluidAmount() < 1000 || this.coldTank.getFluidAmount() < 1000) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(this.outputItems[this.curSelection])) {
            return false;
        }
        return this.inventory[0].field_77994_a != this.outputItems[this.curSelection].func_77976_d();
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = processTime[this.processLevel][this.curSelection];
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void processFinish() {
        int n = Math.min(this.outputItems[this.prevSelection].field_77994_a, Math.min(this.hotTank.getFluidAmount() / Math.max(1, processLava[this.prevSelection]), this.coldTank.getFluidAmount() / Math.max(1, processWater[this.processLevel][this.prevSelection])));
        if (this.inventory[0] == null) {
            this.inventory[0] = ItemHelper.cloneStack((ItemStack)this.outputItems[this.prevSelection], (int)n);
        } else {
            this.inventory[0].field_77994_a += n;
            int n2 = this.inventory[0].func_77976_d();
            if (this.inventory[0].field_77994_a > n2) {
                n -= this.inventory[0].field_77994_a - n2;
                this.inventory[0].field_77994_a = n2;
            }
        }
        this.hotTank.drain(processLava[this.prevSelection] * n, true);
        this.coldTank.drain(processWater[this.processLevel][this.prevSelection] * n, true);
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void transferOutput() {
        if (!this.augmentAutoOutput) {
            return;
        }
        if (this.inventory[0] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int n = i % 6;
            if (this.sideCache[n] != 2 || !this.transferItem(0, TileMachineBase.AUTO_TRANSFER[this.level], n)) continue;
            this.outputTracker = n;
            break;
        }
    }

    @Override
    protected void onLevelChange() {
        super.onLevelChange();
        this.hotTank.setCapacity(4000 * TileMachineBase.FLUID_CAPACITY[this.level]);
        this.coldTank.setCapacity(4000 * TileMachineBase.FLUID_CAPACITY[this.level]);
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!super.readPortableTagInternal(entityPlayer, nBTTagCompound)) {
            return false;
        }
        if (nBTTagCompound.func_74764_b("Sel")) {
            this.curSelection = nBTTagCompound.func_74771_c("Sel");
            if (!this.isActive) {
                this.prevSelection = this.curSelection;
            }
        }
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!super.writePortableTagInternal(entityPlayer, nBTTagCompound)) {
            return false;
        }
        nBTTagCompound.func_74774_a("Sel", this.curSelection);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiExtruder(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerExtruder(inventoryPlayer, (TileEntity)this);
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    public FluidTankAdv getTank(int n) {
        if (n == 0) {
            return this.hotTank;
        }
        return this.coldTank;
    }

    public FluidStack getTankFluid(int n) {
        if (n == 0) {
            return this.hotTank.getFluid();
        }
        return this.coldTank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.outputTracker = nBTTagCompound.func_74762_e("Tracker");
        this.prevSelection = nBTTagCompound.func_74771_c("Prev");
        this.curSelection = nBTTagCompound.func_74771_c("Sel");
        this.hotTank.readFromNBT(nBTTagCompound.func_74775_l("HotTank"));
        this.coldTank.readFromNBT(nBTTagCompound.func_74775_l("ColdTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Tracker", this.outputTracker);
        nBTTagCompound.func_74774_a("Prev", this.prevSelection);
        nBTTagCompound.func_74774_a("Sel", this.curSelection);
        nBTTagCompound.func_74782_a("HotTank", (NBTBase)this.hotTank.writeToNBT(new NBTTagCompound()));
        nBTTagCompound.func_74782_a("ColdTank", (NBTBase)this.coldTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addByte(this.curSelection);
        packetCoFHBase.addByte(this.prevSelection);
        if (this.hotTank.getFluid() == null) {
            packetCoFHBase.addFluidStack(this.hotRenderFluid);
        } else {
            packetCoFHBase.addFluidStack(this.hotTank.getFluid());
        }
        if (this.coldTank.getFluid() == null) {
            packetCoFHBase.addFluidStack(this.coldRenderFluid);
        } else {
            packetCoFHBase.addFluidStack(this.coldTank.getFluid());
        }
        packetCoFHBase.addByte(this.processLevel);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase packetCoFHBase = super.getFluidPacket();
        packetCoFHBase.addFluidStack(this.hotRenderFluid);
        packetCoFHBase.addFluidStack(this.coldRenderFluid);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase packetCoFHBase = super.getModePacket();
        packetCoFHBase.addByte(this.curSelection);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.curSelection = packetCoFHBase.getByte();
        this.prevSelection = packetCoFHBase.getByte();
        this.hotTank.setFluid(packetCoFHBase.getFluidStack());
        this.coldTank.setFluid(packetCoFHBase.getFluidStack());
        byte by = this.processLevel;
        this.processLevel = packetCoFHBase.getByte();
        if (by != this.processLevel) {
            for (int i = 0; i < 3; ++i) {
                this.outputItems[i].field_77994_a = TEAugments.MACHINE_EXTRUDER_PROCESS_MOD[i][this.processLevel];
            }
        }
    }

    @Override
    protected void handleFluidPacket(PacketCoFHBase packetCoFHBase) {
        super.handleFluidPacket(packetCoFHBase);
        this.hotRenderFluid = packetCoFHBase.getFluidStack();
        this.coldRenderFluid = packetCoFHBase.getFluidStack();
        ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        super.handleModePacket(packetCoFHBase);
        this.curSelection = packetCoFHBase.getByte();
        if (!this.isActive) {
            this.prevSelection = this.curSelection;
        }
    }

    public void setMode(int n) {
        byte by = this.curSelection;
        this.curSelection = (byte)n;
        this.sendModePacket();
        this.curSelection = by;
    }

    @Override
    protected boolean installAugment(int n) {
        IAugmentItem iAugmentItem = (IAugmentItem)this.augments[n].func_77973_b();
        boolean bl = false;
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_SPEED) > 0) {
            return false;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_EXTRUDER_BOOST) > 0) {
            int n2 = iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.MACHINE_EXTRUDER_BOOST);
            if (n2 > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(TEAugments.MACHINE_EXTRUDER_BOOST, n2, n)) {
                return false;
            }
            if (this.hasAugmentChain(TEAugments.MACHINE_EXTRUDER_BOOST, n2)) {
                this.processLevel = (byte)Math.max(n2, this.processLevel);
                for (int i = 0; i < 3; ++i) {
                    this.outputItems[i].field_77994_a = TEAugments.MACHINE_EXTRUDER_PROCESS_MOD[i][this.processLevel];
                }
            } else {
                return false;
            }
            bl = true;
        }
        return bl ? true : super.installAugment(n);
    }

    @Override
    protected void onInstalled() {
        super.onInstalled();
        for (int i = 0; i < 3; ++i) {
            this.outputItems[i].field_77994_a = TEAugments.MACHINE_EXTRUDER_PROCESS_MOD[i][this.processLevel];
        }
    }

    @Override
    protected void resetAugments() {
        super.resetAugments();
        this.processLevel = 0;
        for (int i = 0; i < 3; ++i) {
            this.outputItems[i].field_77994_a = 1;
        }
    }

    public ItemStack[] getInventorySlots(int n) {
        return this.outputItems;
    }

    public int getSlotStackLimit(int n) {
        return 64;
    }

    public void onSlotUpdate() {
        this.func_70296_d();
    }

    public int fill(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        if (forgeDirection != ForgeDirection.UNKNOWN && this.sideCache[forgeDirection.ordinal()] != 1) {
            return 0;
        }
        if (fluidStack.getFluid() == FluidRegistry.LAVA) {
            return this.hotTank.fill(fluidStack, bl);
        }
        if (fluidStack.getFluid() == FluidRegistry.WATER) {
            return this.coldTank.fill(fluidStack, bl);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection forgeDirection, FluidStack fluidStack, boolean bl) {
        return null;
    }

    public FluidStack drain(ForgeDirection forgeDirection, int n, boolean bl) {
        return null;
    }

    public boolean canFill(ForgeDirection forgeDirection, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection forgeDirection, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection forgeDirection) {
        return new FluidTankInfo[]{this.hotTank.getInfo(), this.coldTank.getInfo()};
    }
}

