/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.tileentity.IPortableData;
import cofh.core.block.TileCoFHBase;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.core.TEProps;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileTEBase
extends TileCoFHBase
implements ITileInfoPacketHandler,
ITilePacketHandler,
IPortableData {
    protected String tileName = "";

    public boolean setInvName(String string) {
        if (string.isEmpty()) {
            return false;
        }
        this.tileName = string;
        return true;
    }

    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        return false;
    }

    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        return false;
    }

    public int getInvSlotCount() {
        return 0;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean openGui(EntityPlayer entityPlayer) {
        if (this.hasGui()) {
            entityPlayer.openGui((Object)ThermalExpansion.instance, 0, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            return true;
        }
        return false;
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        PacketCoFHBase packetCoFHBase;
        if (iCrafting instanceof EntityPlayer && (packetCoFHBase = this.getGuiPacket()) != null) {
            PacketHandler.sendTo((PacketBase)packetCoFHBase, (EntityPlayer)((EntityPlayer)iCrafting));
        }
    }

    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        if (nBTTagCompound.func_74764_b("Name")) {
            this.tileName = nBTTagCompound.func_74779_i("Name");
        }
    }

    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74778_a("Version", "1.7.10R4.0.3B1");
        if (!this.tileName.isEmpty()) {
            nBTTagCompound.func_74778_a("Name", this.tileName);
        }
    }

    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addString(this.tileName);
        return packetCoFHBase;
    }

    public PacketCoFHBase getGuiPacket() {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        packetTileInfo.addByte(TEProps.PacketID.GUI.ordinal());
        return packetTileInfo;
    }

    public PacketCoFHBase getFluidPacket() {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        packetTileInfo.addByte(TEProps.PacketID.FLUID.ordinal());
        return packetTileInfo;
    }

    public PacketCoFHBase getModePacket() {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        packetTileInfo.addByte(TEProps.PacketID.MODE.ordinal());
        return packetTileInfo;
    }

    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
    }

    protected void handleFluidPacket(PacketCoFHBase packetCoFHBase) {
    }

    protected void handleModePacket(PacketCoFHBase packetCoFHBase) {
        this.markChunkDirty();
    }

    public void sendFluidPacket() {
        PacketHandler.sendToDimension((PacketBase)this.getFluidPacket(), (int)((TileEntity)this).field_145850_b.field_73011_w.field_76574_g);
    }

    public void sendModePacket() {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            PacketHandler.sendToServer((PacketBase)this.getModePacket());
        }
    }

    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            this.tileName = packetCoFHBase.getString();
        } else {
            packetCoFHBase.getString();
        }
    }

    public void handleTileInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        switch (TEProps.PacketID.values()[packetCoFHBase.getByte()]) {
            case GUI: {
                this.handleGuiPacket(packetCoFHBase);
                return;
            }
            case FLUID: {
                this.handleFluidPacket(packetCoFHBase);
                return;
            }
            case MODE: {
                this.handleModePacket(packetCoFHBase);
                return;
            }
        }
    }

    public String getDataType() {
        return this.getName();
    }

    public void readPortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer)) {
            return;
        }
        if (this.readPortableTagInternal(entityPlayer, nBTTagCompound)) {
            this.func_70296_d();
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void writePortableData(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (!this.canPlayerAccess(entityPlayer)) {
            return;
        }
        if (this.writePortableTagInternal(entityPlayer, nBTTagCompound)) {
            // empty if block
        }
    }

    public static class SideConfig {
        public int numConfig;
        public int[][] slotGroups;
        public boolean[] allowInsertionSide;
        public boolean[] allowExtractionSide;
        public boolean[] allowInsertionSlot;
        public boolean[] allowExtractionSlot;
        public int[] sideTex;
        public byte[] defaultSides;
    }

    public static class EnergyConfig {
        public int minPower = 8;
        public int maxPower = 80;
        public int maxEnergy = 40000;
        public int minPowerLevel = 1 * this.maxEnergy / 10;
        public int maxPowerLevel = 9 * this.maxEnergy / 10;
        public int energyRamp = this.maxPowerLevel / this.maxPower;

        public EnergyConfig() {
        }

        public EnergyConfig(EnergyConfig energyConfig) {
            this.minPower = energyConfig.minPower;
            this.maxPower = energyConfig.maxPower;
            this.maxEnergy = energyConfig.maxEnergy;
            this.minPowerLevel = energyConfig.minPowerLevel;
            this.maxPowerLevel = energyConfig.maxPowerLevel;
            this.energyRamp = energyConfig.energyRamp;
        }

        public EnergyConfig copy() {
            return new EnergyConfig(this);
        }

        public boolean setParams(int n, int n2, int n3) {
            this.minPower = n;
            this.maxPower = n2;
            this.maxEnergy = n3;
            this.maxPowerLevel = n3 * 8 / 10;
            this.energyRamp = n2 > 0 ? this.maxPowerLevel / n2 : 0;
            this.minPowerLevel = n * this.energyRamp;
            return true;
        }

        public boolean setParamsPower(int n) {
            return this.setParams(n / 4, n, n * 1200);
        }

        public boolean setParamsPower(int n, int n2) {
            return this.setParams(n / 4, n, n * 1200 * n2);
        }

        public boolean setParamsEnergy(int n) {
            return this.setParams(n / 4800, n / 1200, n);
        }

        public boolean setParamsEnergy(int n, int n2) {
            return this.setParams((n *= n2) / 4800, n / 1200, n);
        }

        public boolean setParamsDefault(int n) {
            this.maxPower = n;
            this.minPower = n / 10;
            this.maxEnergy = n * 500;
            this.minPowerLevel = 1 * this.maxEnergy / 10;
            this.maxPowerLevel = 9 * this.maxEnergy / 10;
            this.energyRamp = this.maxPowerLevel / n;
            return true;
        }
    }
}

