/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.api.item.IAugmentItem;
import cofh.api.tileentity.IAugmentable;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.block.TileReconfigurable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.item.TEAugments;
import cofh.thermalexpansion.util.ReconfigurableHelper;
import cofh.thermalexpansion.util.Utils;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class TileAugmentable
extends TileReconfigurable
implements IAugmentable,
IEnergyInfo,
ISidedInventory {
    protected TileTEBase.SideConfig sideConfig;
    protected boolean[] augmentStatus = new boolean[3];
    protected ItemStack[] augments = new ItemStack[3];
    public boolean augmentAutoInput;
    public boolean augmentAutoOutput;
    public boolean augmentReconfigSides;
    public boolean augmentRedstoneControl;

    @Override
    public byte[] getDefaultSides() {
        return (byte[])this.sideConfig.defaultSides.clone();
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        if (this.augmentRedstoneControl) {
            this.rsMode = RedstoneControlHelper.getControlFromNBT((NBTTagCompound)nBTTagCompound);
        }
        if (this.augmentReconfigSides) {
            byte by = ReconfigurableHelper.getFacingFromNBT(nBTTagCompound);
            byte[] byArray = ReconfigurableHelper.getSideCacheFromNBT(nBTTagCompound, this.getDefaultSides());
            this.sideCache[0] = byArray[0];
            this.sideCache[1] = byArray[1];
            this.sideCache[this.facing] = byArray[by];
            this.sideCache[BlockHelper.getLeftSide((int)this.facing)] = byArray[BlockHelper.getLeftSide((int)by)];
            this.sideCache[BlockHelper.getRightSide((int)this.facing)] = byArray[BlockHelper.getRightSide((int)by)];
            this.sideCache[BlockHelper.getOppositeSide((int)this.facing)] = byArray[BlockHelper.getOppositeSide((int)by)];
            for (int i = 0; i < 6; ++i) {
                if (this.sideCache[i] < this.getNumConfig(i)) continue;
                this.sideCache[i] = 0;
            }
        }
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer entityPlayer, NBTTagCompound nBTTagCompound) {
        RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)nBTTagCompound, (IRedstoneControl)this);
        ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, this);
        return true;
    }

    public int getScaledProgress(int n) {
        return 0;
    }

    public int getScaledSpeed(int n) {
        return 0;
    }

    public FluidTankAdv getTank() {
        return null;
    }

    public FluidStack getTankFluid() {
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.readAugmentsFromNBT(nBTTagCompound);
        this.installAugments();
        this.energyStorage.readFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.writeAugmentsToNBT(nBTTagCompound);
    }

    public void readAugmentsFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Augments", 10);
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.augments.length) continue;
            this.augments[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeAugmentsToNBT(NBTTagCompound nBTTagCompound) {
        if (this.augments.length <= 0) {
            return;
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.augments[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.augments[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Augments", (NBTBase)nBTTagList);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.augmentReconfigSides);
        packetCoFHBase.addBool(this.augmentRedstoneControl);
        return packetCoFHBase;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addBool(this.isActive);
        packetCoFHBase.addInt(this.energyStorage.getMaxEnergyStored());
        packetCoFHBase.addInt(this.energyStorage.getEnergyStored());
        packetCoFHBase.addBool(this.augmentReconfigSides);
        packetCoFHBase.addBool(this.augmentRedstoneControl);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        this.isActive = packetCoFHBase.getBool();
        this.energyStorage.setCapacity(packetCoFHBase.getInt());
        this.energyStorage.setEnergyStored(packetCoFHBase.getInt());
        boolean bl = this.augmentReconfigSides;
        boolean bl2 = this.augmentRedstoneControl;
        this.augmentReconfigSides = packetCoFHBase.getBool();
        this.augmentRedstoneControl = packetCoFHBase.getBool();
        if (this.augmentReconfigSides != bl || this.augmentRedstoneControl != bl2) {
            this.onInstalled();
        }
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (!bl) {
            this.augmentReconfigSides = packetCoFHBase.getBool();
            this.augmentRedstoneControl = packetCoFHBase.getBool();
        } else {
            packetCoFHBase.getBool();
            packetCoFHBase.getBool();
        }
    }

    public ItemStack[] getAugmentSlots() {
        return this.augments;
    }

    public boolean[] getAugmentStatus() {
        return this.augmentStatus;
    }

    public void installAugments() {
        this.resetAugments();
        for (int i = 0; i < this.augments.length; ++i) {
            this.augmentStatus[i] = false;
            if (!Utils.isAugmentItem(this.augments[i])) continue;
            this.augmentStatus[i] = this.installAugment(i);
        }
        if (((TileEntity)this).field_145850_b != null && ServerHelper.isServerWorld((World)((TileEntity)this).field_145850_b)) {
            this.onInstalled();
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    protected boolean hasAugment(String string, int n) {
        for (int i = 0; i < this.augments.length; ++i) {
            if (!Utils.isAugmentItem(this.augments[i]) || ((IAugmentItem)this.augments[i].func_77973_b()).getAugmentLevel(this.augments[i], string) != n) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDuplicateAugment(String string, int n, int n2) {
        for (int i = 0; i < this.augments.length; ++i) {
            if (i == n2 || !Utils.isAugmentItem(this.augments[i]) || ((IAugmentItem)this.augments[i].func_77973_b()).getAugmentLevel(this.augments[i], string) != n) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAugmentChain(String string, int n) {
        boolean bl = true;
        for (int i = 1; i < n; ++i) {
            bl = bl && this.hasAugment(string, i);
        }
        return bl;
    }

    protected boolean installAugment(int n) {
        IAugmentItem iAugmentItem = (IAugmentItem)this.augments[n].func_77973_b();
        boolean bl = false;
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_AUTO_OUTPUT) > 0) {
            this.augmentAutoOutput = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_AUTO_INPUT) > 0) {
            this.augmentAutoInput = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_RECONFIG_SIDES) > 0) {
            this.augmentReconfigSides = true;
            bl = true;
        }
        if (iAugmentItem.getAugmentLevel(this.augments[n], TEAugments.GENERAL_REDSTONE_CONTROL) > 0) {
            this.augmentRedstoneControl = true;
            bl = true;
        }
        return bl;
    }

    protected void onInstalled() {
        if (!this.augmentReconfigSides) {
            this.setDefaultSides();
            this.sideCache[this.facing] = 0;
        }
        if (!this.augmentRedstoneControl) {
            this.rsMode = IRedstoneControl.ControlMode.DISABLED;
        }
    }

    protected void resetAugments() {
        this.augmentAutoOutput = false;
        this.augmentAutoInput = false;
        this.augmentReconfigSides = false;
        this.augmentRedstoneControl = false;
    }

    public int getInfoEnergyPerTick() {
        return 0;
    }

    public int getInfoMaxEnergyPerTick() {
        return 0;
    }

    public int getInfoEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getInfoMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean decrSide(int n) {
        return this.augmentReconfigSides ? super.decrSide(n) : false;
    }

    @Override
    public boolean incrSide(int n) {
        return this.augmentReconfigSides ? super.incrSide(n) : false;
    }

    @Override
    public boolean setSide(int n, int n2) {
        return this.augmentReconfigSides ? super.setSide(n, n2) : false;
    }

    @Override
    public boolean resetSides() {
        return this.augmentReconfigSides ? super.resetSides() : false;
    }

    @Override
    public int getNumConfig(int n) {
        return this.sideConfig.numConfig;
    }

    public int[] func_94128_d(int n) {
        return this.sideConfig.slotGroups[this.sideCache[n]];
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return this.sideConfig.allowInsertionSide[this.sideCache[n2]] && this.sideConfig.allowInsertionSlot[n] ? this.func_94041_b(n, itemStack) : false;
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return this.sideConfig.allowExtractionSide[this.sideCache[n2]] && this.sideConfig.allowExtractionSlot[n];
    }
}

