/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui;

public class GuiColor
extends Number {
    private static final long serialVersionUID = 7024827242888861187L;
    private final int _color;

    public GuiColor(int argb) {
        this._color = argb;
    }

    public GuiColor(int rgba, Void dummy) {
        this(rgba >>> 24, rgba >> 16, rgba >> 8, rgba);
    }

    public GuiColor(byte alpha, int argb) {
        this(argb >> 16, argb >> 8, argb, alpha);
    }

    public GuiColor(int rgba, byte alpha) {
        this(rgba >>> 24, rgba >> 16, rgba >> 8, alpha);
    }

    public GuiColor(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public GuiColor(int r, int g, int b, int a) {
        this._color = b & 0xFF | (g & 0xFF) << 8 | (r & 0xFF) << 16 | (a & 0xFF) << 24;
    }

    public int getColor() {
        return this._color;
    }

    public int getIntR() {
        return this._color >> 16 & 0xFF;
    }

    public int getIntG() {
        return this._color >> 8 & 0xFF;
    }

    public int getIntB() {
        return this._color >> 0 & 0xFF;
    }

    public int getIntA() {
        return this._color >> 24 & 0xFF;
    }

    public float getFloatR() {
        return (float)this.getIntR() / 255.0f;
    }

    public float getFloatG() {
        return (float)this.getIntG() / 255.0f;
    }

    public float getFloatB() {
        return (float)this.getIntB() / 255.0f;
    }

    public float getFloatA() {
        return (float)this.getIntA() / 255.0f;
    }

    @Override
    public int intValue() {
        return this.getColor();
    }

    @Override
    public long longValue() {
        return this.getColor();
    }

    @Override
    public float floatValue() {
        return this.getColor();
    }

    @Override
    public double doubleValue() {
        return this.getColor();
    }
}

