/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.test;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class EnergyValueMappingsTestSuite {
    Map<WrappedStack, EnergyValue> testSuiteValueMap;

    public EnergyValueMappingsTestSuite() {
        this.testSuiteValueMap = new TreeMap<WrappedStack, EnergyValue>();
    }

    public EnergyValueMappingsTestSuite(File jsonFile) {
        if (jsonFile != null && jsonFile.exists() && jsonFile.isFile()) {
            this.testSuiteValueMap = SerializationHelper.readEnergyValueStackMapFromJsonFile(jsonFile);
        }
    }

    public void add(Object object, Object value) {
        if (WrappedStack.canBeWrapped(object)) {
            if (value instanceof Number) {
                Number number = (Number)value;
                WrappedStack wrappedStack = WrappedStack.wrap(object);
                wrappedStack.setStackSize(1);
                this.testSuiteValueMap.put(wrappedStack, new EnergyValue(number.floatValue()));
            } else if (value == null) {
                WrappedStack wrappedStack = WrappedStack.wrap(object);
                wrappedStack.setStackSize(1);
                this.testSuiteValueMap.put(wrappedStack, null);
            }
        }
    }

    public void remove(Object object) {
        if (WrappedStack.canBeWrapped(object)) {
            WrappedStack wrappedStack = WrappedStack.wrap(object);
            wrappedStack.setStackSize(1);
            this.testSuiteValueMap.remove(wrappedStack);
        }
    }

    public void loadTestSuite(File jsonFile) {
        if (jsonFile != null && jsonFile.exists() && jsonFile.isFile()) {
            this.testSuiteValueMap = SerializationHelper.readEnergyValueStackMapFromJsonFile(jsonFile);
        }
    }

    public void saveTestSuite(File jsonFile) {
        if (jsonFile != null) {
            SerializationHelper.writeEnergyValueStackMapToJsonFile(jsonFile, this.testSuiteValueMap);
        }
    }

    public void runTestSuite() {
        this.runTestSuite(false);
    }

    public void runTestSuite(boolean strict) {
        ArrayList<String> successMessages = new ArrayList<String>();
        ArrayList<String> failureMessages = new ArrayList<String>();
        for (WrappedStack wrappedStack : this.testSuiteValueMap.keySet()) {
            EnergyValue registryEnergyValue = EnergyValueRegistryProxy.getEnergyValue(wrappedStack, strict);
            EnergyValue testSuiteEnergryValue = this.testSuiteValueMap.get(wrappedStack);
            if (registryEnergyValue == null && testSuiteEnergryValue == null) {
                successMessages.add(String.format("SUCCESS: Object '%s' had the expected energy value [Expected (%s), Found (%s)]", wrappedStack, testSuiteEnergryValue, registryEnergyValue));
                continue;
            }
            if (registryEnergyValue == null) {
                failureMessages.add(String.format("FAILURE: Object '%s' did not have the expected energy value [Expected (%s), Found (%s)]", wrappedStack, testSuiteEnergryValue, registryEnergyValue));
                continue;
            }
            if (registryEnergyValue == null || testSuiteEnergryValue == null) continue;
            if (registryEnergyValue.equals(testSuiteEnergryValue)) {
                successMessages.add(String.format("SUCCESS: Object '%s' had the expected energy value [Expected (%s), Found (%s)]", wrappedStack, testSuiteEnergryValue, registryEnergyValue));
                continue;
            }
            failureMessages.add(String.format("FAILURE: Object '%s' did not have the expected energy value [Expected (%s), Found (%s)]", wrappedStack, testSuiteEnergryValue, registryEnergyValue));
        }
        for (String successMessage : successMessages) {
            LogHelper.info(successMessage);
        }
        for (String failureMessage : failureMessages) {
            LogHelper.warn(failureMessage);
        }
    }
}

