/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.recipe;

import com.google.common.collect.ImmutableList;
import com.pahimar.ee3.api.exchange.RecipeRegistryProxy;
import com.pahimar.ee3.item.crafting.RecipeAludel;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AludelRecipeManager {
    private static AludelRecipeManager aludelRegistry = null;
    private List<RecipeAludel> aludelRecipes = new ArrayList<RecipeAludel>();

    private AludelRecipeManager() {
    }

    public static AludelRecipeManager getInstance() {
        if (aludelRegistry == null) {
            aludelRegistry = new AludelRecipeManager();
        }
        return aludelRegistry;
    }

    public void addRecipe(ItemStack recipeOutput, ItemStack recipeInputStack, ItemStack recipeInputDust) {
        this.addRecipe(new RecipeAludel(recipeOutput, recipeInputStack, recipeInputDust));
    }

    public void addRecipe(RecipeAludel recipeAludel) {
        if (!this.aludelRecipes.contains(recipeAludel)) {
            LogHelper.trace(String.format("AludelRecipeManager[%s]: Mod with ID '%s' added Aludel recipe '%s'", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), recipeAludel));
            this.aludelRecipes.add(recipeAludel);
        }
    }

    public ItemStack getResult(ItemStack recipeInputStack, ItemStack recipeInputDust) {
        for (RecipeAludel recipeAludel : this.aludelRecipes) {
            if (!recipeAludel.matches(recipeInputStack, recipeInputDust)) continue;
            return recipeAludel.getRecipeOutput();
        }
        return null;
    }

    public RecipeAludel getRecipe(ItemStack recipeInputStack, ItemStack recipeInputDust) {
        for (RecipeAludel recipeAludel : this.aludelRecipes) {
            if (!recipeAludel.matches(recipeInputStack, recipeInputDust)) continue;
            return recipeAludel;
        }
        return null;
    }

    public List<RecipeAludel> getRecipes() {
        return ImmutableList.copyOf(this.aludelRecipes);
    }

    public static void registerRecipes() {
        for (RecipeAludel recipeAludel : AludelRecipeManager.getInstance().getRecipes()) {
            RecipeRegistryProxy.addRecipe(recipeAludel.getRecipeOutput(), recipeAludel.getRecipeInputsAsWrappedStacks());
        }
    }
}

