/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.tileentity.TileEntityAludel;
import com.pahimar.ee3.util.ColorHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MessageTileEntityAludel
implements IMessage,
IMessageHandler<MessageTileEntityAludel, IMessage> {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;
    public UUID ownerUUID;
    public int itemId;
    public int metaData;
    public int stackSize;
    public int itemColor;

    public MessageTileEntityAludel() {
    }

    public MessageTileEntityAludel(TileEntityAludel tileEntityAludel, ItemStack outputItemStack) {
        this.x = tileEntityAludel.field_145851_c;
        this.y = tileEntityAludel.field_145848_d;
        this.z = tileEntityAludel.field_145849_e;
        this.orientation = (byte)tileEntityAludel.getOrientation().ordinal();
        this.state = (byte)tileEntityAludel.getState();
        this.customName = tileEntityAludel.getCustomName();
        this.ownerUUID = tileEntityAludel.getOwnerUUID();
        if (outputItemStack != null) {
            this.itemId = Item.func_150891_b((Item)outputItemStack.func_77973_b());
            this.metaData = outputItemStack.func_77960_j();
            this.stackSize = outputItemStack.field_77994_a;
            this.itemColor = ColorHelper.getColor(outputItemStack);
        } else {
            this.itemId = -1;
            this.metaData = 0;
            this.stackSize = 0;
            this.itemColor = 0;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        this.ownerUUID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        this.itemId = buf.readInt();
        this.metaData = buf.readInt();
        this.stackSize = buf.readInt();
        this.itemColor = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        if (this.ownerUUID != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.ownerUUID.getMostSignificantBits());
            buf.writeLong(this.ownerUUID.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.itemId);
        buf.writeInt(this.metaData);
        buf.writeInt(this.stackSize);
        buf.writeInt(this.itemColor);
    }

    public IMessage onMessage(MessageTileEntityAludel message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityAludel) {
            ((TileEntityAludel)tileEntity).setOrientation(message.orientation);
            ((TileEntityAludel)tileEntity).setState(message.state);
            ((TileEntityAludel)tileEntity).setCustomName(message.customName);
            ((TileEntityAludel)tileEntity).setOwnerUUID(message.ownerUUID);
            ItemStack outputItemStack = null;
            if (message.itemId != -1) {
                outputItemStack = new ItemStack(Item.func_150899_d((int)message.itemId), message.stackSize, message.metaData);
                if (message.itemColor != Integer.parseInt("ffffff", 16)) {
                    ColorHelper.setColor(outputItemStack, this.itemColor);
                }
            }
            ((TileEntityAludel)tileEntity).outputItemStack = outputItemStack;
            FMLClientHandler.instance().getClient().field_71441_e.func_147451_t(message.x, message.y, message.z);
        }
        return null;
    }

    public String toString() {
        return String.format("MessageTileEntityAludel - x:%s, y:%s, z:%s, orientation:%s, state:%s, customName:%s, ownerUUID:%s, itemId: %s, metaData: %s, stackSize: %s, itemColor: %s", this.x, this.y, this.z, this.orientation, this.state, this.customName, this.ownerUUID, this.itemId, this.metaData, this.stackSize, this.itemColor);
    }
}

