/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.knowledge;

import com.pahimar.ee3.api.event.PlayerKnowledgeEvent;
import com.pahimar.ee3.api.event.TemplateKnowledgeEvent;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledge;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class TransmutationKnowledgeRegistry {
    private static TransmutationKnowledgeRegistry transmutationKnowledgeRegistry = null;
    private static File playerKnowledgeDirectory;
    private static File dataKnowledgeDirectory;
    private static TransmutationKnowledge templateKnowledge;
    private static HashMap<UUID, TransmutationKnowledge> playerKnowledgeMap;

    private TransmutationKnowledgeRegistry() {
        playerKnowledgeDirectory = new File(SerializationHelper.getPlayerDataDirectory(), "knowledge" + File.separator + "transmutation");
        playerKnowledgeDirectory.mkdirs();
        dataKnowledgeDirectory = new File(SerializationHelper.getDataDirectory(), "knowledge" + File.separator + "transmutation");
        dataKnowledgeDirectory.mkdirs();
        this.loadTemplateKnowledgeFromDisk();
        playerKnowledgeMap = new HashMap();
    }

    public static TransmutationKnowledgeRegistry getInstance() {
        if (transmutationKnowledgeRegistry == null) {
            transmutationKnowledgeRegistry = new TransmutationKnowledgeRegistry();
        }
        return transmutationKnowledgeRegistry;
    }

    public TransmutationKnowledge getTemplateKnowledge() {
        return templateKnowledge;
    }

    public Set<ItemStack> getTemplatesKnownTransmutations() {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        return templateKnowledge.getKnownTransmutations();
    }

    public Set<ItemStack> getTemplatesKnownTransmutationsFilteredStartsWith(String filterString) {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        return FilterUtils.filterByNameStartsWith(templateKnowledge.getKnownTransmutations(), filterString);
    }

    public Set<ItemStack> getTemplatesKnownTransmutationsFilteredContains(String filterString) {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        return FilterUtils.filterByNameContains(templateKnowledge.getKnownTransmutations(), filterString);
    }

    public boolean doesTemplateKnow(ItemStack itemStack) {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        return templateKnowledge.isKnown(itemStack);
    }

    public boolean canTemplateLearn(ItemStack itemStack) {
        if (AbilityRegistry.getInstance().isLearnable(itemStack)) {
            if (templateKnowledge == null) {
                this.loadTemplateKnowledgeFromDisk();
            }
            return !templateKnowledge.isKnown(itemStack);
        }
        return false;
    }

    public void teachTemplate(ItemStack itemStack) {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        if (this.canTemplateLearn(itemStack) && !MinecraftForge.EVENT_BUS.post((Event)new TemplateKnowledgeEvent.TemplateLearnKnowledgeEvent(itemStack))) {
            templateKnowledge.learnTransmutation(itemStack);
            this.saveTemplateKnowledgeToDisk();
        }
    }

    public void makeTemplateForget(ItemStack itemStack) {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        if (this.doesTemplateKnow(itemStack) && !MinecraftForge.EVENT_BUS.post((Event)new TemplateKnowledgeEvent.TemplateForgetKnowledgeEvent(itemStack))) {
            templateKnowledge.forgetTransmutation(itemStack);
            this.saveTemplateKnowledgeToDisk();
        }
    }

    public void makeTemplateForgetEverything() {
        if (templateKnowledge == null) {
            this.loadTemplateKnowledgeFromDisk();
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new TemplateKnowledgeEvent.TemplateForgetAllKnowledgeEvent())) {
            templateKnowledge.forgetAllTransmutations();
            this.saveTemplateKnowledgeToDisk();
        }
    }

    public Set<ItemStack> getPlayersKnownTransmutations(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            return this.getPlayersKnownTransmutations(entityPlayer.func_110124_au());
        }
        return null;
    }

    public Set<ItemStack> getPlayersKnownTransmutations(UUID playerUUID) {
        if (playerUUID != null) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID)) {
                return playerKnowledgeMap.get(playerUUID).getKnownTransmutations();
            }
        }
        return null;
    }

    public Set<ItemStack> getPlayersKnownTransmutationsFilteredStartsWith(EntityPlayer entityPlayer, String startsWith) {
        if (entityPlayer != null) {
            return this.getPlayersKnownTransmutationsFilteredStartsWith(entityPlayer.func_110124_au(), startsWith);
        }
        return null;
    }

    public Set<ItemStack> getPlayersKnownTransmutationsFilteredStartsWith(UUID playerUUID, String startsWith) {
        if (playerUUID != null) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID)) {
                return playerKnowledgeMap.get(playerUUID).filterByNameStartsWith(startsWith);
            }
        }
        return null;
    }

    public Set<ItemStack> getPlayersKnownTransmutationsFilteredContains(EntityPlayer entityPlayer, String contains) {
        if (entityPlayer != null) {
            return this.getPlayersKnownTransmutationsFilteredContains(entityPlayer.func_110124_au(), contains);
        }
        return null;
    }

    public Set<ItemStack> getPlayersKnownTransmutationsFilteredContains(UUID playerUUID, String contains) {
        if (playerUUID != null) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID)) {
                return playerKnowledgeMap.get(playerUUID).filterByNameContains(contains);
            }
        }
        return null;
    }

    public boolean doesPlayerKnow(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (entityPlayer != null && itemStack != null) {
            this.loadPlayerFromDiskIfNeeded(entityPlayer);
            if (playerKnowledgeMap.containsKey(entityPlayer.func_110124_au())) {
                return playerKnowledgeMap.get(entityPlayer.func_110124_au()).isKnown(itemStack);
            }
        }
        return false;
    }

    public boolean doesPlayerKnow(UUID playerUUID, ItemStack itemStack) {
        if (playerUUID != null && itemStack != null) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID)) {
                return playerKnowledgeMap.get(playerUUID).isKnown(itemStack);
            }
        }
        return false;
    }

    public boolean canPlayerLearn(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (entityPlayer != null) {
            return this.canPlayerLearn(entityPlayer.func_110124_au(), itemStack);
        }
        return false;
    }

    public boolean canPlayerLearn(UUID playerUUID, ItemStack itemStack) {
        if (playerUUID != null && itemStack != null && AbilityRegistry.getInstance().isLearnable(itemStack)) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID)) {
                return !playerKnowledgeMap.get(playerUUID).isKnown(itemStack);
            }
        }
        return false;
    }

    public void teachPlayer(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (entityPlayer != null) {
            this.teachPlayer(entityPlayer.func_110124_au(), itemStack);
        }
    }

    public void teachPlayer(UUID playerUUID, ItemStack itemStack) {
        if (playerUUID != null && itemStack != null && this.canPlayerLearn(playerUUID, itemStack)) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID) && !MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeEvent.PlayerLearnKnowledgeEvent(playerUUID, itemStack))) {
                playerKnowledgeMap.get(playerUUID).learnTransmutation(itemStack);
                this.savePlayerKnowledgeToDisk(playerUUID);
            }
        }
    }

    public void makePlayerForget(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (entityPlayer != null) {
            this.makePlayerForget(entityPlayer.func_110124_au(), itemStack);
        }
    }

    public void makePlayerForget(UUID playerUUID, ItemStack itemStack) {
        if (playerUUID != null && itemStack != null && this.doesPlayerKnow(playerUUID, itemStack)) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID) && !MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeEvent.PlayerForgetKnowledgeEvent(playerUUID, itemStack))) {
                playerKnowledgeMap.get(playerUUID).forgetTransmutation(itemStack);
                this.savePlayerKnowledgeToDisk(playerUUID);
            }
        }
    }

    public void makePlayerForgetEverything(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            this.makePlayerForgetEverything(entityPlayer.func_110124_au());
        }
    }

    public void makePlayerForgetEverything(UUID playerUUID) {
        if (playerUUID != null) {
            this.loadPlayerFromDiskIfNeeded(playerUUID);
            if (playerKnowledgeMap.containsKey(playerUUID) && !MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeEvent.PlayerForgetAllKnowledgeEvent(playerUUID))) {
                playerKnowledgeMap.get(playerUUID).forgetAllTransmutations();
                this.savePlayerKnowledgeToDisk(playerUUID);
            }
        }
    }

    public void loadTemplateKnowledgeFromDisk() {
        if (dataKnowledgeDirectory != null) {
            File templateFile = new File(dataKnowledgeDirectory, "template.json");
            if (!templateFile.exists()) {
                templateKnowledge = new TransmutationKnowledge();
                SerializationHelper.writeTransmutationKnowledgeToFile(dataKnowledgeDirectory, "template.json", templateKnowledge);
            } else {
                templateKnowledge = SerializationHelper.readTransmutationKnowledgeFromFile(dataKnowledgeDirectory, "template.json");
            }
        } else {
            templateKnowledge = new TransmutationKnowledge();
        }
    }

    public void saveTemplateKnowledgeToDisk() {
        if (dataKnowledgeDirectory != null) {
            if (templateKnowledge != null) {
                SerializationHelper.writeTransmutationKnowledgeToFile(dataKnowledgeDirectory, "template.json", templateKnowledge);
            } else {
                templateKnowledge = new TransmutationKnowledge();
                SerializationHelper.writeTransmutationKnowledgeToFile(dataKnowledgeDirectory, "template.json", templateKnowledge);
            }
        }
    }

    public void loadPlayerFromDiskIfNeeded(EntityPlayer entityPlayer) {
        if (entityPlayer != null && entityPlayer.func_110124_au() != null) {
            this.loadPlayerFromDiskIfNeeded(entityPlayer.func_110124_au());
        }
    }

    public void loadPlayerFromDiskIfNeeded(UUID playerUUID) {
        if (playerUUID != null && playerKnowledgeDirectory != null && !playerKnowledgeMap.containsKey(playerUUID)) {
            TransmutationKnowledge playerTransmutationKnowledge = new TransmutationKnowledge();
            File playerKnowledgeFile = new File(playerKnowledgeDirectory, playerUUID.toString() + ".json");
            if (playerKnowledgeFile.exists() && playerKnowledgeFile.isFile()) {
                playerTransmutationKnowledge = SerializationHelper.readTransmutationKnowledgeFromFile(playerKnowledgeDirectory, playerUUID.toString() + ".json");
            }
            playerKnowledgeMap.put(playerUUID, playerTransmutationKnowledge);
        }
    }

    public void unloadPlayer(EntityPlayer entityPlayer) {
        if (entityPlayer != null) {
            this.unloadPlayer(entityPlayer.func_110124_au());
        }
    }

    public void unloadPlayer(UUID playerUUID) {
        if (playerUUID != null && playerKnowledgeMap.containsKey(playerUUID)) {
            this.savePlayerKnowledgeToDisk(playerUUID);
            playerKnowledgeMap.remove(playerUUID);
        }
    }

    public void savePlayerKnowledgeToDisk(EntityPlayer entityPlayer) {
        if (entityPlayer != null && entityPlayer.func_110124_au() != null) {
            this.savePlayerKnowledgeToDisk(entityPlayer.func_110124_au());
        }
    }

    public void savePlayerKnowledgeToDisk(UUID playerUUID) {
        if (playerUUID != null && playerKnowledgeDirectory != null) {
            if (playerKnowledgeMap.containsKey(playerUUID) && playerKnowledgeMap.get(playerUUID) != null) {
                if (playerKnowledgeMap.get(playerUUID).hasBeenModified()) {
                    SerializationHelper.writeTransmutationKnowledgeToFile(playerKnowledgeDirectory, playerUUID.toString() + ".json", playerKnowledgeMap.get(playerUUID));
                }
            } else {
                this.loadPlayerFromDiskIfNeeded(playerUUID);
                SerializationHelper.writeTransmutationKnowledgeToFile(playerKnowledgeDirectory, playerUUID.toString() + ".json", playerKnowledgeMap.get(playerUUID));
            }
        }
    }

    public void saveAll() {
        if (dataKnowledgeDirectory != null) {
            this.saveTemplateKnowledgeToDisk();
        }
        if (playerKnowledgeDirectory != null) {
            for (UUID playerUUID : playerKnowledgeMap.keySet()) {
                SerializationHelper.writeTransmutationKnowledgeToFile(playerKnowledgeDirectory, playerUUID.toString() + ".json", playerKnowledgeMap.get(playerUUID));
            }
        }
    }

    public void clear() {
        this.saveAll();
        transmutationKnowledgeRegistry = null;
    }
}

