/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pahimar.ee3.item.ItemToolModalEE;
import com.pahimar.ee3.reference.Key;
import com.pahimar.ee3.reference.Material;
import com.pahimar.ee3.reference.ToolMode;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.IChargeable;
import com.pahimar.ee3.util.IKeyBound;
import com.pahimar.ee3.util.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class ItemDarkMatterAxe
extends ItemToolModalEE
implements IKeyBound,
IChargeable {
    private static final Set blocksEffectiveAgainst = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP});

    public ItemDarkMatterAxe() {
        super(3.0f, Material.Tools.DARK_MATTER, blocksEffectiveAgainst);
        this.func_77655_b("axeDarkMatter");
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        return block.func_149688_o() != Material.field_151575_d && block.func_149688_o() != Material.field_151585_k && block.func_149688_o() != Material.field_151582_l ? super.func_150893_a(itemStack, block) : this.field_77864_a;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return ImmutableSet.of((Object)"axe");
    }

    @Override
    public short getMaxChargeLevel() {
        return 3;
    }

    @Override
    public short getChargeLevel(ItemStack itemStack) {
        return NBTHelper.getShort(itemStack, "chargeLevel");
    }

    @Override
    public void setChargeLevel(ItemStack itemStack, short chargeLevel) {
        if (chargeLevel <= this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", chargeLevel);
        }
    }

    @Override
    public void increaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") < this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") + 1));
        }
    }

    @Override
    public void decreaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") > 0) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") - 1));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer entityPlayer, ItemStack itemStack, Key key) {
        if (key == Key.CHARGE) {
            if (!entityPlayer.func_70093_af()) {
                if (this.getChargeLevel(itemStack) == this.getMaxChargeLevel()) {
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
                } else {
                    this.increaseChargeLevel(itemStack);
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeUp", 0.5f, 0.5f + 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel()));
                }
            } else if (this.getChargeLevel(itemStack) == 0) {
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
            } else {
                this.decreaseChargeLevel(itemStack);
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeDown", 0.5f, 1.0f - (0.5f - 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel())));
            }
        } else if (key == Key.EXTRA) {
            CommonSoundHelper.playSoundAtPlayer(entityPlayer, "tock", 0.5f, 1.5f);
            this.changeToolMode(itemStack);
        }
    }

    @Override
    public List<ToolMode> getAvailableToolModes() {
        return Arrays.asList(ToolMode.STANDARD);
    }
}

