/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class JsonFluidStack
implements JsonSerializer<JsonFluidStack>,
JsonDeserializer<JsonFluidStack> {
    public static final Gson jsonSerializer = new GsonBuilder().registerTypeAdapter(JsonFluidStack.class, (Object)new JsonFluidStack()).create();
    public Fluid fluid;
    public int amount;
    public NBTTagCompound tag;

    public JsonFluidStack() {
        this.fluid = null;
        this.amount = 0;
        this.tag = null;
    }

    public JsonFluidStack(FluidStack fluidStack) {
        this.fluid = fluidStack.getFluid();
        this.amount = fluidStack.amount;
        this.tag = fluidStack.tag;
    }

    public JsonFluidStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)json;
            JsonFluidStack jsonFluidStack = new JsonFluidStack();
            if (!jsonObject.has("fluidName")) {
                throw new JsonParseException("");
            }
            jsonFluidStack.fluid = FluidRegistry.getFluid((String)jsonObject.get("fluidName").getAsString());
            if (!jsonObject.has("amount")) {
                throw new JsonParseException("");
            }
            jsonFluidStack.amount = jsonObject.get("amount").getAsInt();
            if (jsonObject.has("tag")) {
                try {
                    NBTBase nbtBase = JsonToNBT.func_150315_a((String)jsonObject.get("tag").getAsString());
                    if (nbtBase instanceof NBTTagCompound) {
                        jsonFluidStack.tag = (NBTTagCompound)nbtBase;
                    }
                }
                catch (NBTException e) {
                    throw new JsonParseException(e.getMessage(), e.getCause());
                }
            }
            return jsonFluidStack;
        }
        return null;
    }

    public JsonElement serialize(JsonFluidStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluidName", src.fluid.getName());
        jsonObject.addProperty("amount", (Number)src.amount);
        if (src.tag != null) {
            jsonObject.addProperty("tag", src.tag.toString());
        }
        return jsonObject;
    }

    public String toString() {
        return String.format("fluid: %s, amount: %s, tag: %s", this.fluid, this.amount, this.tag);
    }
}

