/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.handler;

import com.pahimar.ee3.EquivalentExchange3;
import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.array.AlchemyArrayRegistry;
import com.pahimar.ee3.client.util.RenderUtils;
import com.pahimar.ee3.item.ItemChalk;
import com.pahimar.ee3.item.ItemDarkMatterAxe;
import com.pahimar.ee3.item.ItemDarkMatterHammer;
import com.pahimar.ee3.item.ItemDarkMatterHoe;
import com.pahimar.ee3.item.ItemDarkMatterPickAxe;
import com.pahimar.ee3.item.ItemDarkMatterShovel;
import com.pahimar.ee3.reference.ToolMode;
import com.pahimar.ee3.settings.ChalkSettings;
import com.pahimar.ee3.tileentity.TileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityDummyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.util.IModalTool;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class DrawBlockHighlightEventHandler {
    @SubscribeEvent
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        if (event.currentItem != null && event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (event.currentItem.func_77973_b() instanceof ItemDarkMatterShovel) {
                this.drawSelectionBoxForShovel(event, (IModalTool)event.currentItem.func_77973_b());
            } else if (event.currentItem.func_77973_b() instanceof ItemDarkMatterPickAxe) {
                this.drawSelectionBoxForPickAxe(event, (IModalTool)event.currentItem.func_77973_b());
            } else if (event.currentItem.func_77973_b() instanceof ItemDarkMatterHammer) {
                this.drawSelectionBoxForHammer(event, (IModalTool)event.currentItem.func_77973_b());
            } else if (event.currentItem.func_77973_b() instanceof ItemDarkMatterAxe) {
                this.drawSelectionBoxForAxe(event, (IModalTool)event.currentItem.func_77973_b());
            } else if (event.currentItem.func_77973_b() instanceof ItemDarkMatterHoe) {
                this.drawSelectionBoxForHoe(event, (IModalTool)event.currentItem.func_77973_b());
            } else if (event.currentItem.func_77973_b() instanceof ItemChalk) {
                this.drawAlchemyArrayOverlay(event);
            }
        }
    }

    private void drawSelectionBoxForShovel(DrawBlockHighlightEvent event, IModalTool modalTool) {
        ToolMode toolMode = modalTool.getCurrentToolMode(event.currentItem);
        int facing = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (toolMode != ToolMode.UNKNOWN) {
            event.setCanceled(true);
            if (toolMode == ToolMode.STANDARD) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
            }
        }
    }

    private void drawSelectionBoxForPickAxe(DrawBlockHighlightEvent event, IModalTool modalTool) {
        ToolMode toolMode = modalTool.getCurrentToolMode(event.currentItem);
        int facing = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (toolMode != ToolMode.UNKNOWN) {
            event.setCanceled(true);
            if (toolMode == ToolMode.STANDARD) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
            } else if (toolMode == ToolMode.WIDE) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                if (event.target.field_72310_e == ForgeDirection.NORTH.ordinal() || event.target.field_72310_e == ForgeDirection.SOUTH.ordinal()) {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b - 1, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b + 1, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                } else if (event.target.field_72310_e == ForgeDirection.EAST.ordinal() || event.target.field_72310_e == ForgeDirection.WEST.ordinal()) {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d - 1, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d + 1, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                } else if (facing == 0 || facing == 2) {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b - 1, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b + 1, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                } else {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d - 1, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d + 1, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                }
            } else if (toolMode == ToolMode.TALL) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                if (event.target.field_72310_e == ForgeDirection.NORTH.ordinal() || event.target.field_72310_e == ForgeDirection.SOUTH.ordinal() || event.target.field_72310_e == ForgeDirection.EAST.ordinal() || event.target.field_72310_e == ForgeDirection.WEST.ordinal()) {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c - 1, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c + 1, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                } else if (facing == 1 || facing == 3) {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b - 1, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b + 1, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                } else {
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d - 1, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                    this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d + 1, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
                }
            }
        }
    }

    private void drawSelectionBoxForHammer(DrawBlockHighlightEvent event, IModalTool modalTool) {
        ToolMode toolMode = modalTool.getCurrentToolMode(event.currentItem);
        int facing = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (toolMode != ToolMode.UNKNOWN) {
            event.setCanceled(true);
            if (toolMode == ToolMode.STANDARD) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
            }
        }
    }

    private void drawSelectionBoxForAxe(DrawBlockHighlightEvent event, IModalTool modalTool) {
        ToolMode toolMode = modalTool.getCurrentToolMode(event.currentItem);
        int facing = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (toolMode != ToolMode.UNKNOWN) {
            event.setCanceled(true);
            if (toolMode == ToolMode.STANDARD) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
            }
        }
    }

    private void drawSelectionBoxForHoe(DrawBlockHighlightEvent event, IModalTool modalTool) {
        ToolMode toolMode = modalTool.getCurrentToolMode(event.currentItem);
        int facing = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (toolMode != ToolMode.UNKNOWN) {
            event.setCanceled(true);
            if (toolMode == ToolMode.STANDARD) {
                this.drawSelectionBox(event.context, event.player, new MovingObjectPosition(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e, event.target.field_72307_f), 0, event.partialTicks);
            }
        }
    }

    private void drawAlchemyArrayOverlay(DrawBlockHighlightEvent event) {
        ChalkSettings chalkSettings = EquivalentExchange3.proxy.getClientProxy().chalkSettings;
        AlchemyArray alchemyArray = AlchemyArrayRegistry.getInstance().getAlchemyArray(chalkSettings.getIndex());
        ResourceLocation texture = alchemyArray.getTexture();
        int rotation = chalkSettings.getRotation();
        double x = (float)event.target.field_72311_b + 0.5f;
        double y = (float)event.target.field_72312_c + 0.5f;
        double z = (float)event.target.field_72309_d + 0.5f;
        double iPX = event.player.field_70169_q + (event.player.field_70165_t - event.player.field_70169_q) * (double)event.partialTicks;
        double iPY = event.player.field_70167_r + (event.player.field_70163_u - event.player.field_70167_r) * (double)event.partialTicks;
        double iPZ = event.player.field_70166_s + (event.player.field_70161_v - event.player.field_70166_s) * (double)event.partialTicks;
        int zCorrection = 1;
        int rotationAngle = 0;
        int playerFacing = MathHelper.func_76128_c((double)((double)(event.player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int facingCorrectionAngle = 0;
        float zScale = 1.0f;
        float yScale = 1.0f;
        float xScale = 1.0f;
        float zShift = 0.0f;
        float yShift = 0.0f;
        float xShift = 0.0f;
        float zRotate = 0.0f;
        float yRotate = 0.0f;
        float xRotate = 0.0f;
        int chargeLevel = (chalkSettings.getSize() - 1) * 2 + 1;
        ForgeDirection sideHit = ForgeDirection.getOrientation((int)event.target.field_72310_e);
        TileEntity tileEntity = event.player.field_70170_p.func_147438_o(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d);
        boolean shouldRender = true;
        if (tileEntity instanceof TileEntityEE && ((TileEntityEE)tileEntity).getOrientation() != sideHit) {
            shouldRender = false;
        }
        if (!this.canPlaceAlchemyArray(event.currentItem, event.player.field_70170_p, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d, event.target.field_72310_e)) {
            shouldRender = false;
        }
        if (shouldRender) {
            switch (sideHit) {
                case UP: {
                    xScale = zScale = (float)chargeLevel;
                    yShift = 0.001f;
                    xRotate = -1.0f;
                    rotationAngle = -90 * (rotation + 2) % 360;
                    facingCorrectionAngle = -90 * (playerFacing + 2) % 360;
                    if (tileEntity instanceof TileEntityAlchemyArray) {
                        y -= 1.0;
                    }
                    if (!(tileEntity instanceof TileEntityDummyArray)) break;
                    x = (float)((TileEntityDummyArray)tileEntity).getTrueXCoord() + 0.5f;
                    y = (float)((TileEntityDummyArray)tileEntity).getTrueYCoord() + 0.5f - 1.0f;
                    z = (float)((TileEntityDummyArray)tileEntity).getTrueXCoord() + 0.5f;
                    break;
                }
                case DOWN: {
                    xScale = zScale = (float)chargeLevel;
                    yShift = -0.001f;
                    xRotate = 1.0f;
                    rotationAngle = -90 * (rotation + 2) % 360;
                    facingCorrectionAngle = -90 * (playerFacing + 2) % 360;
                    if (!(tileEntity instanceof TileEntityAlchemyArray)) break;
                    y += 1.0;
                    break;
                }
                case NORTH: {
                    xScale = yScale = (float)chargeLevel;
                    zCorrection = -1;
                    zShift = -0.001f;
                    zRotate = 1.0f;
                    rotationAngle = -90 * (rotation + 1) % 360;
                    if (!(tileEntity instanceof TileEntityAlchemyArray)) break;
                    z += 1.0;
                    break;
                }
                case SOUTH: {
                    xScale = yScale = (float)chargeLevel;
                    zShift = 0.001f;
                    zRotate = -1.0f;
                    rotationAngle = -90 * (rotation + 1) % 360;
                    if (!(tileEntity instanceof TileEntityAlchemyArray)) break;
                    z -= 1.0;
                    break;
                }
                case EAST: {
                    yScale = zScale = (float)chargeLevel;
                    xShift = 0.001f;
                    yRotate = 1.0f;
                    rotationAngle = -90 * (rotation + 2) % 360;
                    if (!(tileEntity instanceof TileEntityAlchemyArray)) break;
                    x -= 1.0;
                    break;
                }
                case WEST: {
                    yScale = zScale = (float)chargeLevel;
                    xShift = -0.001f;
                    yRotate = -1.0f;
                    rotationAngle = -90 * (rotation + 2) % 360;
                    if (!(tileEntity instanceof TileEntityAlchemyArray)) break;
                    x += 1.0;
                    break;
                }
            }
            if (shouldRender) {
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)2884);
                GL11.glPushMatrix();
                GL11.glTranslated((double)(-iPX + x + (double)xShift), (double)(-iPY + y + (double)yShift), (double)(-iPZ + z + (double)zShift));
                GL11.glScalef((float)(1.0f * xScale), (float)(1.0f * yScale), (float)(1.0f * zScale));
                GL11.glRotatef((float)rotationAngle, (float)sideHit.offsetX, (float)sideHit.offsetY, (float)sideHit.offsetZ);
                GL11.glRotatef((float)facingCorrectionAngle, (float)sideHit.offsetX, (float)sideHit.offsetY, (float)sideHit.offsetZ);
                GL11.glRotatef((float)90.0f, (float)xRotate, (float)yRotate, (float)zRotate);
                GL11.glTranslated((double)0.0, (double)0.0, (double)(0.5f * (float)zCorrection));
                GL11.glClear((int)256);
                RenderUtils.renderPulsingQuad(texture, 1.0f);
                GL11.glPopMatrix();
                GL11.glEnable((int)2884);
                GL11.glDepthMask((boolean)true);
            }
        }
    }

    private boolean canPlaceAlchemyArray(ItemStack itemStack, World world, int x, int y, int z, int side) {
        boolean canPlaceAlchemyArray;
        block9: {
            ForgeDirection orientation;
            int coordOffset;
            block11: {
                block10: {
                    ChalkSettings chalkSettings = EquivalentExchange3.proxy.getClientProxy().chalkSettings;
                    coordOffset = chalkSettings.getSize() - 1;
                    orientation = ForgeDirection.getOrientation((int)side);
                    AlchemyArray alchemyArray = AlchemyArrayRegistry.getInstance().getAlchemyArray(chalkSettings.getIndex());
                    canPlaceAlchemyArray = this.isValidForArray(world, x, y, z, side);
                    int chargeLevel = (chalkSettings.getSize() - 1) * 2 + 1;
                    if (itemStack.func_77960_j() == itemStack.func_77958_k() && chargeLevel * chargeLevel * alchemyArray.getChalkCostPerBlock() == 1) {
                        canPlaceAlchemyArray = true;
                    } else if (itemStack.func_77958_k() - itemStack.func_77960_j() + 1 < chargeLevel * chargeLevel * alchemyArray.getChalkCostPerBlock()) {
                        canPlaceAlchemyArray = false;
                    }
                    if (!canPlaceAlchemyArray) break block9;
                    if (orientation != ForgeDirection.UP && orientation != ForgeDirection.DOWN) break block10;
                    for (int i = x - coordOffset; i <= x + coordOffset; ++i) {
                        for (int j = z - coordOffset; j <= z + coordOffset; ++j) {
                            if (i == x && j == z || this.isValidForArray(world, i, y, j, side)) continue;
                            canPlaceAlchemyArray = false;
                        }
                    }
                    break block9;
                }
                if (orientation != ForgeDirection.NORTH && orientation != ForgeDirection.SOUTH) break block11;
                for (int i = x - coordOffset; i <= x + coordOffset; ++i) {
                    for (int j = y - coordOffset; j <= y + coordOffset; ++j) {
                        if (i == x && j == y || this.isValidForArray(world, i, j, z, side)) continue;
                        canPlaceAlchemyArray = false;
                    }
                }
                break block9;
            }
            if (orientation != ForgeDirection.EAST && orientation != ForgeDirection.WEST) break block9;
            for (int i = y - coordOffset; i <= y + coordOffset; ++i) {
                for (int j = z - coordOffset; j <= z + coordOffset; ++j) {
                    if (i == y && j == z || this.isValidForArray(world, x, i, j, side)) continue;
                    canPlaceAlchemyArray = false;
                }
            }
        }
        return canPlaceAlchemyArray;
    }

    private boolean isValidForArray(World world, int x, int y, int z, int sideHit) {
        ForgeDirection side = ForgeDirection.getOrientation((int)sideHit);
        return world.isSideSolid(x, y, z, side) && (side == ForgeDirection.DOWN && world.func_147439_a(x, y - 1, z).isReplaceable((IBlockAccess)world, x, y, z) || side == ForgeDirection.UP && world.func_147439_a(x, y + 1, z).isReplaceable((IBlockAccess)world, x, y, z) || side == ForgeDirection.NORTH && world.func_147439_a(x, y, z - 1).isReplaceable((IBlockAccess)world, x, y, z) || side == ForgeDirection.SOUTH && world.func_147439_a(x, y, z + 1).isReplaceable((IBlockAccess)world, x, y, z) || side == ForgeDirection.WEST && world.func_147439_a(x - 1, y, z).isReplaceable((IBlockAccess)world, x, y, z) || side == ForgeDirection.EAST && world.func_147439_a(x + 1, y, z).isReplaceable((IBlockAccess)world, x, y, z));
    }

    private void drawSelectionBox(RenderGlobal context, EntityPlayer entityPlayer, MovingObjectPosition rayTrace, int i, float partialTicks) {
        if (i == 0 && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            GL11.glLineWidth((float)3.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f1 = 0.002f;
            Block block = entityPlayer.field_70170_p.func_147439_a(rayTrace.field_72311_b, rayTrace.field_72312_c, rayTrace.field_72309_d);
            if (block.func_149688_o() != Material.field_151579_a) {
                block.func_149719_a((IBlockAccess)entityPlayer.field_70170_p, rayTrace.field_72311_b, rayTrace.field_72312_c, rayTrace.field_72309_d);
                double d0 = entityPlayer.field_70142_S + (entityPlayer.field_70165_t - entityPlayer.field_70142_S) * (double)partialTicks;
                double d1 = entityPlayer.field_70137_T + (entityPlayer.field_70163_u - entityPlayer.field_70137_T) * (double)partialTicks;
                double d2 = entityPlayer.field_70136_U + (entityPlayer.field_70161_v - entityPlayer.field_70136_U) * (double)partialTicks;
                RenderGlobal.func_147590_a((AxisAlignedBB)block.func_149633_g(entityPlayer.field_70170_p, rayTrace.field_72311_b, rayTrace.field_72312_c, rayTrace.field_72309_d).func_72314_b((double)f1, (double)f1, (double)f1).func_72325_c(-d0, -d1, -d2), (int)-1);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }
}

