/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.array;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.init.ModBlocks;
import com.pahimar.ee3.reference.Textures;
import com.pahimar.ee3.tileentity.TileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityTransmutationTablet;
import com.pahimar.ee3.util.CommonParticleHelper;
import com.pahimar.ee3.util.CommonSoundHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TransmutationAlchemyArray
extends AlchemyArray
implements IInventory {
    private ItemStack[] inventory = new ItemStack[25];

    public TransmutationAlchemyArray() {
        super(Textures.AlchemyArray.TRANSMUTATION_ALCHEMY_ARRAY, "arrays.ee3:transmutation");
    }

    @Override
    public void onArrayActivated(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        block13: {
            if (world.field_72995_K || !entityPlayer.func_70093_af()) break block13;
            boolean successFlag = false;
            if (world.func_147438_o(arrayX, arrayY, arrayZ) instanceof TileEntityAlchemyArray) {
                TileEntityAlchemyArray tileEntityAlchemyArray = (TileEntityAlchemyArray)world.func_147438_o(arrayX, arrayY, arrayZ);
                if (tileEntityAlchemyArray.getOrientation() == ForgeDirection.UP && tileEntityAlchemyArray.getSize() == 2 && this.areBlocksValidForTransmutationTablet(world, arrayX, arrayY, arrayZ)) {
                    world.func_147465_d(arrayX - 1, arrayY - 1, arrayZ - 1, ModBlocks.ashInfusedStoneSlab, 1, 3);
                    world.func_147465_d(arrayX, arrayY - 1, arrayZ - 1, ModBlocks.ashInfusedStoneSlab, 2, 3);
                    world.func_147465_d(arrayX + 1, arrayY - 1, arrayZ - 1, ModBlocks.ashInfusedStoneSlab, 3, 3);
                    world.func_147465_d(arrayX - 1, arrayY - 1, arrayZ, ModBlocks.ashInfusedStoneSlab, 4, 3);
                    world.func_147465_d(arrayX, arrayY - 1, arrayZ, (Block)ModBlocks.transmutationTablet, 0, 3);
                    world.func_147465_d(arrayX + 1, arrayY - 1, arrayZ, ModBlocks.ashInfusedStoneSlab, 5, 3);
                    world.func_147465_d(arrayX - 1, arrayY - 1, arrayZ + 1, ModBlocks.ashInfusedStoneSlab, 6, 3);
                    world.func_147465_d(arrayX, arrayY - 1, arrayZ + 1, ModBlocks.ashInfusedStoneSlab, 7, 3);
                    world.func_147465_d(arrayX + 1, arrayY - 1, arrayZ + 1, ModBlocks.ashInfusedStoneSlab, 8, 3);
                    if (world.func_147438_o(arrayX, arrayY - 1, arrayZ) instanceof TileEntityTransmutationTablet) {
                        ((TileEntityTransmutationTablet)world.func_147438_o(arrayX, arrayY - 1, arrayZ)).setOrientation(tileEntityAlchemyArray.getOrientation());
                    }
                    this.ejectInventory(world, arrayX, arrayY, arrayZ);
                    successFlag = true;
                }
                if (successFlag) {
                    CommonSoundHelper.playSoundAtLocation(world.field_73011_w.field_76574_g, arrayX, arrayY, arrayZ, "transmute", 1.0f, 1.0f);
                    if (tileEntityAlchemyArray.getSize() == 1) {
                        CommonParticleHelper.spawnParticleAtLocation("largesmoke", world.field_73011_w.field_76574_g, (double)arrayX + 0.5, arrayY, (double)arrayZ + 0.5, 0.0, 0.1, 0.0);
                    } else if (tileEntityAlchemyArray.getSize() == 2) {
                        for (int i = -1; i <= 1; ++i) {
                            for (int j = -1; j <= 1; ++j) {
                                CommonParticleHelper.spawnParticleAtLocation("largesmoke", world.field_73011_w.field_76574_g, (double)(arrayX + i) + 0.5, arrayY, (double)(arrayZ + j) + 0.5, 0.0, 0.1, 0.0);
                            }
                        }
                    } else if (tileEntityAlchemyArray.getSize() == 3) {
                        for (int i = -2; i <= 2; ++i) {
                            for (int j = -2; j <= 2; ++j) {
                                CommonParticleHelper.spawnParticleAtLocation("largesmoke", world.field_73011_w.field_76574_g, (double)(arrayX + i) + 0.5, arrayY, (double)(arrayZ + j) + 0.5, 0.0, 0.1, 0.0);
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean areBlocksValidForTransmutationTablet(World world, int arrayX, int arrayY, int arrayZ) {
        boolean areBlocksValid = true;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (world.func_147439_a(arrayX + i, arrayY - 1, arrayZ + j) == ModBlocks.ashInfusedStone) continue;
                areBlocksValid = false;
            }
        }
        return areBlocksValid;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (slotIndex < this.func_70302_i_()) {
            return this.inventory[slotIndex];
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slotIndex, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (itemStack != null) {
            this.func_70299_a(slotIndex, null);
        }
        return itemStack;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.func_70302_i_()) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return "arrays.ee3:transmutation";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.func_70302_i_()) {
            return itemStack.func_77973_b() instanceof ItemBlock;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.func_70302_i_(); ++currentIndex) {
            if (this.func_70301_a(currentIndex) == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.func_70301_a(currentIndex).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
    }

    protected void ejectInventory(World world, int x, int y, int z) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.func_77946_l());
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }
}

