/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.api.exchange;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public final class EnergyValue
implements Comparable<EnergyValue>,
JsonDeserializer<EnergyValue>,
JsonSerializer<EnergyValue> {
    private static final Gson jsonSerializer = new GsonBuilder().registerTypeAdapter(EnergyValue.class, (Object)new EnergyValue()).create();
    private float energyValue;

    public EnergyValue() {
        this(0.0f);
    }

    public EnergyValue(float energyValue) {
        this.energyValue = energyValue;
    }

    public boolean equals(Object object) {
        return object instanceof EnergyValue && this.compareTo((EnergyValue)object) == 0;
    }

    public String toString() {
        return String.format("%s", Float.valueOf(this.energyValue));
    }

    @Override
    public int compareTo(EnergyValue energyValue) {
        if (energyValue != null) {
            return Float.compare(this.energyValue, energyValue.getValue());
        }
        return -1;
    }

    public float getValue() {
        return this.energyValue;
    }

    public IChatComponent getChatComponent() {
        return new ChatComponentText("" + this.getValue());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74776_a("energyValue", this.energyValue);
        return nbtTagCompound;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("energyValue")) {
            this.energyValue = nbtTagCompound.func_74760_g("energyValue");
        }
    }

    public static NBTTagCompound writeEnergyValueToNBT(EnergyValue energyValue) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        energyValue.writeToNBT(nbtTagCompound);
        return nbtTagCompound;
    }

    public static EnergyValue loadEnergyValueFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("energyValue")) {
            float energyValue = nbtTagCompound.func_74760_g("energyValue");
            return new EnergyValue(energyValue);
        }
        return null;
    }

    public static EnergyValue createFromJson(String jsonEnergyValue) {
        try {
            return (EnergyValue)jsonSerializer.fromJson(jsonEnergyValue, EnergyValue.class);
        }
        catch (JsonSyntaxException exception) {
            exception.printStackTrace();
        }
        catch (JsonParseException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public String toJson() {
        return jsonSerializer.toJson((Object)this);
    }

    public EnergyValue deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        float energyValue;
        JsonObject jsonEnergyValue = (JsonObject)jsonElement;
        if (jsonEnergyValue.get("value") != null && jsonEnergyValue.get("value").isJsonPrimitive() && Float.compare(energyValue = jsonEnergyValue.get("value").getAsFloat(), 0.0f) >= 0) {
            return new EnergyValue(energyValue);
        }
        return null;
    }

    public JsonElement serialize(EnergyValue energyValueObject, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonEnergyValue = new JsonObject();
        jsonEnergyValue.addProperty("value", (Number)Float.valueOf(energyValueObject.energyValue));
        return jsonEnergyValue;
    }
}

