/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import mantle.blocks.iface.IFacingLogic;
import mantle.blocks.iface.IMasterLogic;
import mantle.blocks.iface.IServantLogic;
import mantle.world.CoordTuple;
import mantle.world.CoordTupleSort;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import tconstruct.TConstruct;
import tconstruct.library.component.LogicComponent;

public class TankLayerScan
extends LogicComponent {
    protected TileEntity master;
    protected IMasterLogic imaster;
    protected Block[] scanBlocks;
    protected CoordTuple masterCoord;
    protected boolean completeStructure;
    protected int bricks = 0;
    protected int airBlocks = 0;
    protected int structureTop = 0;
    protected HashSet<CoordTuple> layerBlockCoords = new HashSet();
    protected HashSet<CoordTuple> layerAirCoords = new HashSet();
    public ArrayList<CoordTuple> blockCoords = new ArrayList();
    public ArrayList<CoordTuple> airCoords = new ArrayList();
    protected ArrayList<int[]> validAirCoords = new ArrayList();
    protected CoordTuple returnStone;
    private static boolean debug = System.getenv("DBG_MANTLE_TankLayerScan") != null;
    private static int MAX_LAYER_RECURSION_DEPTH = System.getProperty("os.arch").equals("amd64") ? 4000 : 2000;

    public TankLayerScan(TileEntity te, Block ... ids) {
        assert (te instanceof IMasterLogic) : "TileEntity must be an instance of IMasterLogic";
        this.master = te;
        this.imaster = (IMasterLogic)te;
        this.scanBlocks = ids;
        this.masterCoord = new CoordTuple((double)te.field_145851_c, (double)te.field_145848_d, (double)te.field_145849_e);
        this.validAirCoords.add(new int[]{1, 0});
        this.validAirCoords.add(new int[]{-1, 0});
        this.validAirCoords.add(new int[]{0, 1});
        this.validAirCoords.add(new int[]{0, -1});
        if (debug) {
            TConstruct.logger.info("In debug mode: " + this);
            TConstruct.logger.info("Using recursion size " + MAX_LAYER_RECURSION_DEPTH + " on JVM arch " + System.getProperty("os.arch"));
        }
    }

    public void checkValidStructure() {
        this.bricks = 0;
        this.airBlocks = 0;
        this.blockCoords.clear();
        this.airCoords.clear();
        boolean validAir = false;
        byte dir = this.getDirection();
        switch (this.getDirection()) {
            case 2: 
            case 3: {
                if (!this.checkAir(this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e - 1) || !this.checkAir(this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e + 1)) break;
                validAir = true;
                break;
            }
            case 4: 
            case 5: {
                if (!this.checkAir(this.master.field_145851_c - 1, this.master.field_145848_d, this.master.field_145849_e) || !this.checkAir(this.master.field_145851_c + 1, this.master.field_145848_d, this.master.field_145849_e)) break;
                validAir = true;
            }
        }
        boolean validBlocks = false;
        int xPos = 0;
        int zPos = 0;
        if (dir == 2) {
            xPos = 1;
        }
        if (dir == 3) {
            xPos = -1;
        }
        if (dir == 4) {
            zPos = -1;
        }
        if (dir == 5) {
            zPos = 1;
        }
        this.returnStone = new CoordTuple((double)(this.master.field_145851_c - xPos), (double)this.master.field_145848_d, (double)(this.master.field_145849_e - zPos));
        if (this.initialRecurseLayer(this.master.field_145851_c + xPos, this.master.field_145848_d, this.master.field_145849_e + zPos)) {
            xPos = 0;
            zPos = 0;
            switch (dir) {
                case 2: {
                    zPos = 1;
                    break;
                }
                case 3: {
                    zPos = -1;
                    break;
                }
                case 4: {
                    xPos = 1;
                    break;
                }
                case 5: {
                    xPos = -1;
                }
            }
            if (!this.world.field_72995_K && debug) {
                TConstruct.logger.info("Bricks in recursion: " + this.blockCoords.size());
            }
            this.blockCoords.clear();
            this.bricks = 0;
            boolean sealed = this.floodTest(this.master.field_145851_c + xPos, this.master.field_145848_d, this.master.field_145849_e + zPos);
            if (!this.world.field_72995_K && debug) {
                TConstruct.logger.info("Air in ring: " + this.airBlocks);
                TConstruct.logger.info("Bricks in ring: " + this.bricks);
            }
            if (sealed) {
                this.blockCoords.add(new CoordTuple((double)this.master.field_145851_c, (double)this.master.field_145848_d, (double)this.master.field_145849_e));
                this.layerAirCoords = new HashSet<CoordTuple>(this.airCoords);
                this.layerBlockCoords = new HashSet<CoordTuple>(this.blockCoords);
                int lowY = this.recurseStructureDown(this.master.field_145848_d - 1);
                if (lowY != -1) {
                    this.completeStructure = true;
                    this.structureTop = this.recurseStructureUp(this.master.field_145848_d + 1);
                    this.finalizeStructure();
                    if (!this.world.field_72995_K && debug) {
                        TConstruct.logger.info("Air in structure: " + this.airCoords.size());
                        TConstruct.logger.info("Bricks in structure: " + this.blockCoords.size());
                    }
                }
            }
        }
    }

    protected void finalizeStructure() {
        Collections.sort(this.blockCoords, new CoordTupleSort());
        Collections.sort(this.airCoords, new CoordTupleSort());
        for (CoordTuple coord : this.blockCoords) {
            TileEntity servant = this.world.func_147438_o(coord.x, coord.y, coord.z);
            if (!(servant instanceof IServantLogic)) continue;
            ((IServantLogic)servant).verifyMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
    }

    public boolean isComplete() {
        return this.completeStructure;
    }

    public int getAirLayerSize() {
        return this.layerAirCoords.size();
    }

    public int getAirSize() {
        return this.airBlocks;
    }

    public CoordTuple getAirByIndex(int index) {
        if (index >= this.airCoords.size() || index < 0) {
            return null;
        }
        return this.airCoords.get(index);
    }

    private byte getDirection() {
        if (this.master instanceof IFacingLogic) {
            return ((IFacingLogic)this.master).getRenderDirection();
        }
        return 0;
    }

    protected boolean checkAir(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        return block == null || this.world.func_147437_c(x, y, z);
    }

    protected boolean checkServant(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        if (block == null || this.world.func_147437_c(x, y, z) || !this.isValidBlock(x, y, z)) {
            return false;
        }
        if (!block.hasTileEntity(this.world.func_72805_g(x, y, z))) {
            return false;
        }
        TileEntity be = this.world.func_147438_o(x, y, z);
        if (be instanceof IServantLogic) {
            return ((IServantLogic)be).setPotentialMaster(this.imaster, this.world, x, y, z);
        }
        return false;
    }

    protected boolean initialRecurseLayer(int x, int y, int z) {
        if (this.bricks > MAX_LAYER_RECURSION_DEPTH) {
            return false;
        }
        CoordTuple keystone = new CoordTuple((double)x, (double)y, (double)z);
        if (keystone.equals((Object)this.returnStone)) {
            return true;
        }
        for (int xPos = -1; xPos <= 1; ++xPos) {
            for (int zPos = -1; zPos <= 1; ++zPos) {
                CoordTuple coord = new CoordTuple((double)(x + xPos), (double)y, (double)(z + zPos));
                if (this.blockCoords.contains(coord) || !this.isValidBlock(x + xPos, y, z + zPos)) continue;
                ++this.bricks;
                this.blockCoords.add(coord);
                return this.initialRecurseLayer(x + xPos, y, z + zPos);
            }
        }
        return false;
    }

    protected boolean isValidBlock(int x, int y, int z) {
        Block block = this.world.func_147439_a(x, y, z);
        if (block != null) {
            for (int i = 0; i < this.scanBlocks.length; ++i) {
                if (block != this.scanBlocks[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean floodTest(int x, int y, int z) {
        if (this.airBlocks > MAX_LAYER_RECURSION_DEPTH) {
            return false;
        }
        for (int[] offset : this.validAirCoords) {
            CoordTuple coord = new CoordTuple((double)(x + offset[0]), (double)y, (double)(z + offset[1]));
            if (this.airCoords.contains(coord)) continue;
            if (this.checkAir(x + offset[0], y, z + offset[1])) {
                this.addAirBlock(coord.x, y, coord.z);
                this.floodTest(x + offset[0], y, z + offset[1]);
                continue;
            }
            if (this.blockCoords.contains(coord) || !this.checkServant(x + offset[0], y, z + offset[1])) continue;
            ++this.bricks;
            this.blockCoords.add(coord);
        }
        return true;
    }

    public int recurseStructureDown(int y) {
        Iterator<CoordTuple> i = this.layerAirCoords.iterator();
        if (i.hasNext()) {
            CoordTuple coord2 = i.next();
            if (this.checkAir(coord2.x, y, coord2.z)) {
                boolean valid = true;
                this.addAirBlock(coord2.x, y, coord2.z);
                while (i.hasNext()) {
                    coord2 = i.next();
                    if (this.checkAir(coord2.x, y, coord2.z)) {
                        this.addAirBlock(coord2.x, y, coord2.z);
                        continue;
                    }
                    valid = false;
                    break;
                }
                for (CoordTuple coord2 : this.layerBlockCoords) {
                    if (this.checkServant(coord2.x, y, coord2.z)) {
                        this.blockCoords.add(new CoordTuple((double)coord2.x, (double)y, (double)coord2.z));
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (valid) {
                    return this.recurseStructureDown(y - 1);
                }
            } else if (this.checkServant(coord2.x, y, coord2.z)) {
                boolean valid = true;
                while (i.hasNext()) {
                    coord2 = i.next();
                    if (this.checkServant(coord2.x, y, coord2.z)) {
                        this.blockCoords.add(new CoordTuple((double)coord2.x, (double)y, (double)coord2.z));
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (valid) {
                    return y + 1;
                }
            }
        }
        return -1;
    }

    public int recurseStructureUp(int y) {
        Iterator<CoordTuple> i = this.layerBlockCoords.iterator();
        if (i.hasNext()) {
            CoordTuple coord2 = i.next();
            if (this.checkServant(coord2.x, y, coord2.z)) {
                boolean valid = true;
                while (i.hasNext()) {
                    coord2 = i.next();
                    if (this.checkServant(coord2.x, y, coord2.z)) {
                        this.blockCoords.add(new CoordTuple((double)coord2.x, (double)y, (double)coord2.z));
                        continue;
                    }
                    valid = false;
                    break;
                }
                if (valid) {
                    for (CoordTuple coord2 : this.layerAirCoords) {
                        if (this.checkAir(coord2.x, y, coord2.z)) {
                            this.addAirBlock(coord2.x, y, coord2.z);
                            continue;
                        }
                        valid = false;
                        break;
                    }
                }
                if (valid) {
                    this.recurseStructureUp(y + 1);
                }
            }
        }
        return y - 1;
    }

    protected void addAirBlock(int x, int y, int z) {
        ++this.airBlocks;
        this.airCoords.add(new CoordTuple((double)x, (double)y, (double)z));
    }

    public void recheckStructure() {
        System.out.println("Rechecking structure");
        int height = -1;
        for (CoordTuple coord : this.blockCoords) {
            TileEntity servant = this.world.func_147438_o(coord.x, coord.y, coord.z);
            boolean canPass = false;
            if (servant instanceof IServantLogic && (canPass = ((IServantLogic)servant).verifyMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e)) || canPass) continue;
            System.out.println("Coord: " + coord);
            height = coord.y;
            break;
        }
        if (height != -1) {
            if (height <= this.master.field_145848_d) {
                this.invalidateStructure();
            } else {
                this.invalidateBlocksAbove(height);
            }
        } else {
            if (this.structureTop == 0) {
                for (CoordTuple coord : this.blockCoords) {
                    this.structureTop = coord.y;
                }
            }
            this.structureTop = this.recurseStructureUp(this.structureTop + 1);
            this.finalizeStructure();
        }
    }

    protected void invalidateStructure() {
        this.completeStructure = false;
        for (CoordTuple coord : this.blockCoords) {
            TileEntity servant = this.world.func_147438_o(coord.x, coord.y, coord.z);
            if (!(servant instanceof IServantLogic)) continue;
            ((IServantLogic)servant).invalidateMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
        this.master.func_145831_w().func_147471_g(this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
    }

    protected void invalidateBlocksAbove(int height) {
        for (CoordTuple coord : this.blockCoords) {
            TileEntity servant;
            if (coord.y < height || !((servant = this.world.func_147438_o(coord.x, coord.y, coord.z)) instanceof IServantLogic)) continue;
            ((IServantLogic)servant).invalidateMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
    }

    public void cleanup() {
        for (CoordTuple coord : this.blockCoords) {
            TileEntity te = this.world.func_147438_o(coord.x, coord.y, coord.z);
            if (te == null || !(te instanceof IServantLogic)) continue;
            ((IServantLogic)te).invalidateMaster(this.imaster, this.world, this.master.field_145851_c, this.master.field_145848_d, this.master.field_145849_e);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        NBTTagList air;
        NBTTagList blocks;
        super.readFromNBT(tags);
        NBTTagList layerAir = tags.func_150295_c("AirLayer", 10);
        if (layerAir != null) {
            this.layerAirCoords.clear();
            for (int i = 0; i < layerAir.func_74745_c(); ++i) {
                int[] coord = layerAir.func_150306_c(i);
                this.layerAirCoords.add(new CoordTuple((double)coord[0], (double)coord[1], (double)coord[2]));
            }
        }
        if ((blocks = tags.func_150295_c("Blocks", 10)) != null) {
            this.blockCoords.clear();
            for (int i = 0; i < blocks.func_74745_c(); ++i) {
                int[] coord = blocks.func_150306_c(i);
                this.blockCoords.add(new CoordTuple((double)coord[0], (double)coord[1], (double)coord[2]));
            }
        }
        if ((air = tags.func_150295_c("Air", 10)) != null) {
            this.airCoords.clear();
            for (int i = 0; i < air.func_74745_c(); ++i) {
                int[] coord = air.func_150306_c(i);
                this.airCoords.add(new CoordTuple((double)coord[0], (double)coord[1], (double)coord[2]));
            }
        }
        this.structureTop = tags.func_74762_e("structureTop");
    }

    @Override
    public void readNetworkNBT(NBTTagCompound tags) {
        this.completeStructure = tags.func_74767_n("Complete");
    }

    @Override
    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        NBTTagList layerAir = new NBTTagList();
        for (CoordTuple coordTuple : this.layerAirCoords) {
            layerAir.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{coordTuple.x, coordTuple.y, coordTuple.z}));
        }
        tags.func_74782_a("AirLayer", (NBTBase)layerAir);
        NBTTagList blocks = new NBTTagList();
        for (CoordTuple coord : this.blockCoords) {
            blocks.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("Blocks", (NBTBase)blocks);
        NBTTagList nBTTagList = new NBTTagList();
        for (CoordTuple coord : this.airCoords) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("Air", (NBTBase)nBTTagList);
        tags.func_74768_a("structureTop", this.structureTop);
    }

    @Override
    public void writeNetworkNBT(NBTTagCompound tags) {
        tags.func_74757_a("Complete", this.completeStructure);
    }
}

