/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructCreativeTab;
import tconstruct.library.crafting.Detailing;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.modifier.ActiveArmorMod;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;

public class TConstructRegistry {
    public static TConstructRegistry instance = new TConstructRegistry();
    public static Logger logger = LogManager.getLogger((String)"TCon-API");
    public static TConstructCreativeTab toolTab;
    public static TConstructCreativeTab partTab;
    public static TConstructCreativeTab materialTab;
    public static TConstructCreativeTab blockTab;
    public static TConstructCreativeTab equipableTab;
    public static TConstructCreativeTab weaponryTab;
    public static HashMap<String, Item> itemDirectory;
    static HashMap<String, ItemStack> itemstackDirectory;
    public static ArrayList<ToolCore> tools;
    public static HashMap<List, ItemStack> patternPartMapping;
    public static HashMap<Integer, ToolMaterial> toolMaterials;
    public static HashMap<String, ToolMaterial> toolMaterialStrings;
    public static List<Integer> defaultToolPartMaterials;
    public static List<Integer> defaultShardMaterials;
    public static HashMap<Integer, BowMaterial> bowMaterials;
    public static HashMap<Integer, ArrowMaterial> arrowMaterials;
    public static ArrayList<CustomMaterial> customMaterials;
    public static ArrayList<ActiveToolMod> activeModifiers;
    public static LinkedList<ActiveArmorMod> activeArmorModifiers;

    public static void addItemToDirectory(String name, Item itemstack) {
        Item add = itemDirectory.get(name);
        if (add != null) {
            logger.warn(name + " is already present in the Item directory");
        }
        itemDirectory.put(name, itemstack);
    }

    public static Item getItem(String name) {
        Item ret = itemDirectory.get(name);
        if (ret == null) {
            logger.warn("Could not find " + name + " in the Item directory");
        }
        return ret;
    }

    public static void addItemStackToDirectory(String name, ItemStack itemstack) {
        ItemStack add = itemstackDirectory.get(name);
        if (add != null) {
            logger.warn(name + " is already present in the ItemStack directory");
        }
        itemstackDirectory.put(name, itemstack);
    }

    public static ItemStack getItemStack(String name) {
        ItemStack ret = itemstackDirectory.get(name);
        if (ret == null) {
            logger.warn("Could not find " + name + " in the ItemStack directory");
        }
        return ret;
    }

    public static void addPartMapping(Item woodPattern, int patternMeta, int materialID, ItemStack output) {
        patternPartMapping.put(Arrays.asList(woodPattern, patternMeta, materialID), output);
    }

    public static ItemStack getPartMapping(Item item, int metadata, int materialID) {
        ItemStack stack = patternPartMapping.get(Arrays.asList(item, metadata, materialID));
        if (stack != null) {
            return stack.func_77946_l();
        }
        return null;
    }

    public static void addToolMapping(ToolCore tool) {
        tools.add(tool);
    }

    public static ArrayList<ToolCore> getToolMapping() {
        return tools;
    }

    public static void addToolRecipe(ToolCore output, Item ... parts) {
        ToolBuilder tb = ToolBuilder.instance;
        if (parts.length < 2 || parts.length > 4) {
            logger.warn("Wrong amount of items to craft into a tool");
        }
        ToolBuilder.addToolRecipe(output, parts);
    }

    public static void addDefaultToolPartMaterial(int materialID) {
        if (!toolMaterials.containsKey(materialID)) {
            logger.error("[TCon API] Can't add default toolpart: Material ID " + materialID + " is unknown.");
        } else {
            defaultToolPartMaterials.add(materialID);
        }
    }

    public static void addDefaultShardMaterial(int materialID) {
        if (!toolMaterials.containsKey(materialID)) {
            logger.error("[TCon API] Can't add default shard: Material ID " + materialID + " is unknown.");
        } else {
            defaultShardMaterials.add(materialID);
        }
    }

    public static void addToolMaterial(int materialID, String materialName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, int primaryColor) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        mat = new ToolMaterial(materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, primaryColor);
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(materialName, mat);
    }

    public static void addToolMaterial(int materialID, String materialName, String localizationName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, int primaryColor) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        mat = new ToolMaterial(materialName, localizationName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, primaryColor);
        toolMaterials.put(materialID, mat);
        toolMaterialStrings.put(materialName, mat);
    }

    @Deprecated
    public static void addToolMaterial(int materialID, String materialName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style) {
        logger.warn("[TCon API] Using deprecated addToolMaterial with no primary color. A fallback of white will be used.");
        TConstructRegistry.addToolMaterial(materialID, materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style, 0xFFFFFF);
    }

    @Deprecated
    public static void addToolMaterial(int materialID, String materialName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, String ability) {
        logger.warn("[TCon API] Using deprecated addToolMaterial with ability name. ability will be ignored, use languages files for that.");
        TConstructRegistry.addToolMaterial(materialID, materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style);
    }

    @Deprecated
    public static void addToolMaterial(int materialID, String materialName, String displayName, int harvestLevel, int durability, int miningspeed, int attack, float handleModifier, int reinforced, float stonebound, String style, String ability) {
        logger.warn("[TCon API] Using deprecated addToolMaterial with display and ability name. displayName and ability will be ignored, use languages files for that.");
        TConstructRegistry.addToolMaterial(materialID, materialName, harvestLevel, durability, miningspeed, attack, handleModifier, reinforced, stonebound, style);
    }

    public static void addtoolMaterial(int materialID, ToolMaterial material) {
        ToolMaterial mat = toolMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Material ID " + materialID + " is already occupied by " + mat.materialName);
        }
        toolMaterials.put(materialID, material);
        toolMaterialStrings.put(material.name(), material);
    }

    public static ToolMaterial getMaterial(int key) {
        return toolMaterials.get(key);
    }

    public static ToolMaterial getMaterial(String key) {
        return toolMaterialStrings.get(key);
    }

    @Deprecated
    public static void addBowMaterial(int materialID, int durability, int drawSpeed, float speedMax) {
        TConstructRegistry.addBowMaterial(materialID, drawSpeed, speedMax);
    }

    public static void addBowMaterial(int materialID, int drawSpeed, float speedMax) {
        BowMaterial mat = bowMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Bow Material ID " + materialID + " is already occupied");
        }
        mat = new BowMaterial(drawSpeed, speedMax);
        bowMaterials.put(materialID, mat);
    }

    public static boolean validBowMaterial(int materialID) {
        return bowMaterials.containsKey(materialID);
    }

    public static BowMaterial getBowMaterial(int materialID) {
        return bowMaterials.get(materialID);
    }

    @Deprecated
    public static void addArrowMaterial(int materialID, float mass, float breakChance, float accuracy) {
        TConstructRegistry.addArrowMaterial(materialID, mass, breakChance);
    }

    public static void addArrowMaterial(int materialID, float mass, float breakChance) {
        ArrowMaterial mat = arrowMaterials.get(materialID);
        if (mat != null) {
            throw new IllegalArgumentException("[TCon API] Arrow Material ID " + materialID + " is already occupied");
        }
        mat = new ArrowMaterial(mass, breakChance);
        arrowMaterials.put(materialID, mat);
    }

    public static boolean validArrowMaterial(int materialID) {
        return arrowMaterials.containsKey(materialID);
    }

    public static ArrowMaterial getArrowMaterial(int materialID) {
        return arrowMaterials.get(materialID);
    }

    public static void addCustomMaterial(CustomMaterial mat) {
        if (mat != null) {
            customMaterials.add(mat);
        }
    }

    public static void addBowstringMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float durability, float drawSpeed, float flightSpeed, int color) {
        BowstringMaterial mat = new BowstringMaterial(materialID, value, input, craftingMaterial, durability, drawSpeed, flightSpeed, color);
        customMaterials.add(mat);
    }

    public static void addFletchingMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float accuracy, float breakChance, float durabilityModifier, int color) {
        FletchingMaterial mat = new FletchingMaterial(materialID, value, input, craftingMaterial, accuracy, breakChance, durabilityModifier, color);
        customMaterials.add(mat);
    }

    @Deprecated
    public static void addBowstringMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float durability, float drawSpeed, float flightSpeed) {
        BowstringMaterial mat = new BowstringMaterial(materialID, value, input, craftingMaterial, durability, drawSpeed, flightSpeed);
        customMaterials.add(mat);
    }

    @Deprecated
    public static void addFletchingMaterial(int materialID, int value, ItemStack input, ItemStack craftingMaterial, float accuracy, float breakChance, float mass) {
        FletchingMaterial mat = new FletchingMaterial(materialID, value, input, craftingMaterial, accuracy, breakChance, mass);
        customMaterials.add(mat);
    }

    public static CustomMaterial getCustomMaterial(int materialID, Class<? extends CustomMaterial> clazz) {
        for (CustomMaterial mat : customMaterials) {
            if (!mat.getClass().equals(clazz) || mat.materialID != materialID) continue;
            return mat;
        }
        return null;
    }

    public static CustomMaterial getCustomMaterial(ItemStack input, Class<? extends CustomMaterial> clazz) {
        for (CustomMaterial mat : customMaterials) {
            if (!mat.getClass().equals(clazz) || !mat.matches(input)) continue;
            return mat;
        }
        return null;
    }

    public static LiquidCasting getTableCasting() {
        return instance.tableCasting();
    }

    LiquidCasting tableCasting() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getTableCasting", new Class[0]);
            LiquidCasting lc = (LiquidCasting)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            logger.warn("Could not find casting table recipes.");
            return null;
        }
    }

    public static LiquidCasting getBasinCasting() {
        return instance.basinCasting();
    }

    LiquidCasting basinCasting() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getBasinCasting", new Class[0]);
            LiquidCasting lc = (LiquidCasting)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            logger.warn("Could not find casting basin recipes.");
            return null;
        }
    }

    public static Detailing getChiselDetailing() {
        return instance.chiselDetailing();
    }

    Detailing chiselDetailing() {
        try {
            Class<?> clazz = Class.forName("tconstruct.TConstruct");
            Method method = clazz.getMethod("getChiselDetailing", new Class[0]);
            Detailing lc = (Detailing)method.invoke((Object)this, new Object[0]);
            return lc;
        }
        catch (Exception e) {
            logger.warn("Could not find chisel detailing recipes.");
            return null;
        }
    }

    public static void registerActiveToolMod(ActiveToolMod mod) {
        activeModifiers.add(mod);
    }

    public static void registerActiveArmorMod(ActiveArmorMod mod) {
        activeArmorModifiers.add(mod);
    }

    static {
        itemDirectory = new HashMap();
        itemstackDirectory = new HashMap();
        tools = new ArrayList(20);
        patternPartMapping = new HashMap();
        toolMaterials = new HashMap(40);
        toolMaterialStrings = new HashMap(40);
        defaultToolPartMaterials = new LinkedList<Integer>();
        defaultShardMaterials = new LinkedList<Integer>();
        bowMaterials = new HashMap(40);
        arrowMaterials = new HashMap(40);
        customMaterials = new ArrayList();
        activeModifiers = new ArrayList();
        activeArmorModifiers = new LinkedList();
    }
}

