/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props.common;

import com.mia.props.common.TileProps;
import com.mia.props.common.entities.TileBaseSwitchable;
import com.mia.props.common.entities.TileBed;
import com.mia.props.common.entities.TileChair;
import com.mia.props.common.entities.TileContainer;
import com.mia.props.common.entities.TileDecobench;
import com.mia.props.common.entities.TileFaucet;
import com.mia.props.common.entities.TileMountable;
import com.mia.props.common.entities.TileParticleEmitter;
import com.mia.props.common.entities.TileParticleEmitterSwitchable;
import com.mia.props.common.entities.TileShowerHandles;
import com.mia.props.common.entities.TileShowerHead;
import com.mia.props.common.entities.TileSwitchableLamp;
import com.mia.props.common.entities.TileVariableRendering;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;

public enum TileTypeMap {
    Props(TileProps.class, "TileBirdFountain"),
    BaseSwitchable(TileBaseSwitchable.class, new String[0]),
    Bed(TileBed.class, new String[0]),
    Chair(TileChair.class, new String[0]),
    Container(TileContainer.class, new String[0]),
    Decobench(TileDecobench.class, new String[0]),
    Mountable(TileMountable.class, new String[0]),
    ShowerHandles(TileShowerHandles.class, new String[0]),
    ShowerHead(TileShowerHead.class, new String[0]),
    SwitchableLamp(TileSwitchableLamp.class, new String[0]),
    ParticleEmitter(TileParticleEmitter.class, "TileChandelier", "TileChemistrySet", "TileCrystalChandelier", "TileCandleStick", "TileCandleWall"),
    ParticleEmitterSwitchable(TileParticleEmitterSwitchable.class, new String[0]),
    Faucet(TileFaucet.class, "TileKitchenFaucetInward", "TileKitchenFaucetOutward", "TileSinkFaucetInward", "TileSinkFaucetOutward", "TileTubFaucet"),
    VariableRendering(TileVariableRendering.class, new String[0]);

    private Class<? extends TileProps> clazz;
    private String[] altnames;

    private TileTypeMap(Class<? extends TileProps> clazz, String ... altnames) {
        this.clazz = clazz;
        this.altnames = altnames;
    }

    public Class<? extends TileProps> getTileClass() {
        return this.clazz;
    }

    public static TileTypeMap getTileType(Class<? extends TileProps> clazz) {
        for (TileTypeMap type : TileTypeMap.values()) {
            if (type.clazz != clazz) continue;
            return type;
        }
        return Props;
    }

    public static void register() {
        for (TileTypeMap type : TileTypeMap.values()) {
            ArrayList<String> altNames = new ArrayList<String>();
            altNames.add(type.clazz.getSimpleName());
            altNames.add(type.clazz.getCanonicalName().replace(".common.", "."));
            for (String s : type.altnames) {
                altNames.add("com.mia.props.common.entities." + s);
                altNames.add("com.mia.props.entities." + s);
            }
            GameRegistry.registerTileEntityWithAlternatives(type.clazz, (String)type.clazz.getCanonicalName(), (String[])altNames.toArray(new String[0]));
        }
    }
}

