/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.api.CSLibAPI;
import com.mia.craftstudio.api.ICSProject;
import com.mia.props.DecoModelMetadata;
import com.mia.props.client.container.GuiHandler;
import com.mia.props.common.BlockFake;
import com.mia.props.common.BlockProps;
import com.mia.props.common.ItemCratingClay;
import com.mia.props.common.ItemProps;
import com.mia.props.common.TileFake;
import com.mia.props.common.TileTypeMap;
import com.mia.props.common.entities.EntityChairMount;
import com.mia.props.common.entities.TileDecobench;
import com.mia.props.events.CommonProxy;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="props", name="DecoCraft", version="2.2.1", dependencies="after:PTRModelLib@[1.0.0,)")
public class Props {
    @Mod.Instance(value="props")
    public static Props instance;
    @SidedProxy(clientSide="com.mia.props.events.ClientProxy", serverSide="com.mia.props.events.CommonProxy")
    public static CommonProxy proxy;
    public static final String modid = "props";
    public static Logger log;
    public static Block blockProps;
    public static Block blockFake;
    public static Item itemProps;
    public static Item itemClay;
    public static HashSet<String> recipes;
    public static Map<Integer, DecoModelMetadata> modelData;
    public static ICSProject csproject;
    private static Configuration config;
    public static boolean clayRecipe;
    public static boolean clayDrops;
    public static boolean allowPropRecycling;
    public static boolean enabledOldStyleRecipes;
    public static final HashSet<ItemStack> allowableResourceItems;

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        allowableResourceItems.add(new ItemStack(itemClay, 1, Short.MAX_VALUE));
        if (allowPropRecycling) {
            allowableResourceItems.add(new ItemStack(itemProps, 1, Short.MAX_VALUE));
        }
        allowableResourceItems.add(new ItemStack(Items.field_151119_aD));
        allowableResourceItems.add(new ItemStack(Blocks.field_150435_aG));
        for (TileDecobench.DyeResourceMap dyeMap : TileDecobench.DyeResourceMap.values()) {
            ArrayList dyesFound = OreDictionary.getOres((String)dyeMap.name());
            for (ItemStack dye : dyesFound) {
                allowableResourceItems.add(dye);
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        config = new Configuration(ev.getSuggestedConfigurationFile());
        try {
            config.load();
            clayRecipe = config.getBoolean("clayRecipe", "general", true, "");
            clayDrops = config.getBoolean("clayDrops", "general", false, "");
            allowPropRecycling = config.getBoolean("allowPropRecycling", "general", true, "Allow old props to be turned back in to resources at the decobench?");
            enabledOldStyleRecipes = config.getBoolean("enabledOldStyleRecipes", "general", false, "Enable old style crafting recipes using crafting clay.");
        }
        catch (Exception e) {
            FMLLog.severe((String)"Decocraft has a problem loading it's configuration", (Object[])new Object[0]);
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        blockProps = new BlockProps();
        blockFake = new BlockFake();
        itemProps = new ItemProps();
        itemClay = new ItemCratingClay();
        GameRegistry.registerBlock((Block)blockProps, (String)"blockProps");
        GameRegistry.registerBlock((Block)blockFake, (String)"blockFake");
        GameRegistry.registerItem((Item)itemProps, (String)modid);
        GameRegistry.registerItem((Item)itemClay, (String)"clay");
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityChairMount.class, (String)"FakeChairEntity", (int)id);
        EntityRegistry.registerModEntity(EntityChairMount.class, (String)"FakeChairEntity", (int)id, (Object)modid, (int)80, (int)3, (boolean)true);
        GameRegistry.registerTileEntity(TileFake.class, (String)"TileFake");
        TileTypeMap.register();
        if (clayRecipe) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemClay, 4, 0), new Object[]{Blocks.field_150354_m, Blocks.field_150346_d, "dyeRed"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemClay, 4, 1), new Object[]{Blocks.field_150354_m, Blocks.field_150346_d, "dyeBlue"}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemClay, 4, 2), new Object[]{Blocks.field_150354_m, Blocks.field_150346_d, "dyeGreen"}));
        }
        csproject = CSLibAPI.getCSProjectAndLoad("Decopack");
        this.createModelMetadata();
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemProps, 1, 508), new Object[]{" R ", "GTB", Character.valueOf('R'), new ItemStack(itemClay, 1, 0), Character.valueOf('G'), new ItemStack(itemClay, 1, 1), Character.valueOf('B'), new ItemStack(itemClay, 1, 2), Character.valueOf('T'), Blocks.field_150462_ai}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemProps, 1, 508), new Object[]{" R ", "GTB", " C ", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "dyeGreen", Character.valueOf('B'), "dyeBlue", Character.valueOf('T'), Blocks.field_150462_ai, Character.valueOf('C'), Blocks.field_150435_aG}));
        proxy.preInit();
    }

    public void createModelMetadata() {
        Gson gson = new GsonBuilder().create();
        for (Map.Entry entry : csproject.getModels().entrySet()) {
            JsonElement modelDescriptor = csproject.getDescriptor((Integer)entry.getKey());
            if (modelDescriptor == null) continue;
            DecoModelMetadata metaData = (DecoModelMetadata)gson.fromJson(modelDescriptor, DecoModelMetadata.class);
            if (modelData.containsKey(metaData.decocraftModelID)) {
                DecoModelMetadata existingMeta = modelData.get(metaData.decocraftModelID);
                if (!existingMeta.craftstudioAssetName.equals(metaData.craftstudioAssetName)) {
                    throw new RuntimeException("You gave a new model the same DecoID as an existing model! xD Existing:[" + existingMeta.craftstudioAssetName + "], New:[" + metaData.craftstudioAssetName + "]");
                }
                recipes.remove(existingMeta.recipe);
            }
            metaData.csmodel = (CSModel)entry.getValue();
            metaData.validate();
            modelData.put(metaData.decocraftModelID, metaData);
        }
        proxy.setupModelWrappers();
    }

    public static TileEntity getTileEntityPreferNotCreating(IBlockAccess blockAccess, int x, int y, int z) {
        if (blockAccess instanceof World) {
            return Props.getTileEntityWithoutCreating((World)blockAccess, x, y, z);
        }
        if (blockAccess instanceof ChunkCache) {
            return Props.getTileEntityWithoutCreating(((ChunkCache)blockAccess).field_72815_e, x, y, z);
        }
        return blockAccess.func_147438_o(x, y, z);
    }

    public static TileEntity getTileEntityWithoutCreating(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            return world.func_72938_d(x, z).getTileEntityUnsafe(x & 0xF, y, z & 0xF);
        }
        return null;
    }

    static {
        log = LogManager.getLogger((String)modid);
        recipes = new HashSet();
        modelData = new HashMap<Integer, DecoModelMetadata>(){

            @Override
            public DecoModelMetadata get(Object key) {
                return super.containsKey(key) ? (DecoModelMetadata)super.get(key) : (DecoModelMetadata)super.get(0);
            }
        };
        config = null;
        clayRecipe = true;
        clayDrops = false;
        allowPropRecycling = true;
        enabledOldStyleRecipes = false;
        allowableResourceItems = new HashSet();
    }
}

