/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.layer.GenLayer;
import org.apache.commons.io.FileUtils;

public class MapUtil {
    public static AtomicBoolean calculatingMap = new AtomicBoolean();
    public static boolean doneOverworldTexture = false;
    private static int ix = 0;
    private static int iz = 0;
    private static int biomeMapx0 = 0;
    private static int biomeMapz0 = 0;
    private static int biomeMapz00;
    private static int biomeMapCx;
    private static int biomeMapCz;
    private static int biomeMapFactor;
    private static WorldChunkManager biomeMapWCM;
    private static BufferedImage biomeMapImage;
    private static File biomeMapFile;
    private static EntityPlayerMP biomeMapPlayerBase;
    private static int biomeMapSizeX;
    private static int biomeMapSizeZ;
    private static ArrayList<BlockVec3> biomeColours;
    private static Random rand;
    private static World biomeMapWorld;
    private static final float[] parabolicField;
    private static int[] heights;
    private static double[] heighttemp;
    private static GenLayer biomeMapGenLayer;
    static double[] field_147427_d;
    static double[] field_147428_e;
    static double[] field_147425_f;
    static double[] field_147426_g;
    private static NoiseGeneratorOctaves field_147431_j;
    private static NoiseGeneratorOctaves field_147432_k;
    private static NoiseGeneratorOctaves field_147429_l;
    private static NoiseGeneratorPerlin field_147430_m;
    public static NoiseGeneratorOctaves noiseGen5;
    public static NoiseGeneratorOctaves noiseGen6;
    private static WorldType field_147435_p;

    public static void getLocalMap(World world, int chunkXPos, int chunkZPos, BufferedImage image) {
        for (int x0 = -12; x0 <= 12; ++x0) {
            for (int z0 = -12; z0 <= 12; ++z0) {
                Chunk chunk = world.func_72964_e(chunkXPos + x0, chunkZPos + z0);
                if (chunk == null) continue;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int l4 = chunk.func_76611_b(x, z) + 1;
                        Block block = Blocks.field_150350_a;
                        int i5 = 0;
                        if (l4 > 1) {
                            while ((block = chunk.func_150810_a(x, --l4, z)).func_149728_f(i5 = chunk.func_76628_c(x, l4, z)) == MapColor.field_151660_b && l4 > 0) {
                            }
                        }
                        int col = block.func_149728_f((int)i5).field_76291_p;
                        image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                    }
                }
            }
        }
    }

    public static void makeOverworldTexture() {
        File outputFile;
        doneOverworldTexture = true;
        if (doneOverworldTexture) {
            return;
        }
        World world = WorldUtil.getProviderForDimension((int)0).field_76579_a;
        if (world == null) {
            return;
        }
        if (calculatingMap.getAndSet(true)) {
            return;
        }
        biomeMapWCM = world.func_72959_q();
        try {
            Field bil = biomeMapWCM.getClass().getDeclaredField(VersionUtil.getNameDynamic("biomeIndexLayer"));
            bil.setAccessible(true);
            biomeMapGenLayer = (GenLayer)bil.get(biomeMapWCM);
        }
        catch (Exception bil) {
            // empty catch block
        }
        if (biomeMapGenLayer == null) {
            calculatingMap.set(false);
            if (ConfigManagerCore.enableDebug) {
                System.out.println("Failed to get gen layer from World Chunk Manager.");
            }
            return;
        }
        File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            GCLog.severe("Base folder(s) could not be created: " + baseFolder.getAbsolutePath());
            calculatingMap.set(false);
            return;
        }
        if (ConfigManagerCore.enableDebug) {
            System.out.println("Starting overworld generation centered at 0,0");
        }
        ix = 0;
        iz = 0;
        biomeMapCx = 0;
        biomeMapCz = 0;
        biomeMapFactor = 256;
        biomeMapSizeX = 192;
        biomeMapSizeZ = 48;
        biomeMapWorld = world;
        biomeMapImage = new BufferedImage(biomeMapSizeX, biomeMapSizeZ, 1);
        int limitX = biomeMapSizeX * biomeMapFactor / 32;
        int limitZ = biomeMapSizeZ * biomeMapFactor / 32;
        biomeMapz00 = -limitZ;
        biomeMapx0 = -limitZ;
        biomeMapz0 = biomeMapz00;
        biomeMapFile = outputFile = new File(baseFolder, "Overworld192x48.jpg");
        biomeMapPlayerBase = null;
    }

    public static void getBiomeMapForCoords(World world, int cx, int cz, int scale, int size, File outputFile, EntityPlayerMP player) {
        if (calculatingMap.getAndSet(true)) {
            return;
        }
        if (ConfigManagerCore.enableDebug) {
            System.out.println("Starting map generation centered at " + cx + "," + cz);
        }
        ix = 0;
        iz = 0;
        biomeMapCx = cx;
        biomeMapCz = cz;
        biomeMapFactor = 1 << scale;
        biomeMapWCM = world.func_72959_q();
        biomeMapWorld = world;
        try {
            Field bil = biomeMapWCM.getClass().getDeclaredField(VersionUtil.getNameDynamic("biomeIndexLayer"));
            bil.setAccessible(true);
            biomeMapGenLayer = (GenLayer)bil.get(biomeMapWCM);
        }
        catch (Exception bil) {
            // empty catch block
        }
        if (biomeMapGenLayer == null) {
            calculatingMap.set(false);
            return;
        }
        biomeMapImage = new BufferedImage(size, size, 1);
        int limit = size * biomeMapFactor / 32;
        biomeMapz00 = -limit;
        biomeMapSizeX = size;
        biomeMapSizeZ = size;
        biomeMapx0 = -limit;
        biomeMapz0 = biomeMapz00;
        biomeMapFile = outputFile;
        biomeMapPlayerBase = player;
    }

    private static void doneBiomeMap() {
        if (biomeMapSizeZ == 48) {
            BufferedImage worldImage = new BufferedImage(biomeMapSizeX, biomeMapSizeZ, 1);
            IResourceManager rm = Minecraft.func_71410_x().func_110442_L();
            BufferedImage paletteImage = null;
            try {
                InputStream in = rm.func_110536_a(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png")).func_110527_b();
                paletteImage = ImageIO.read(in);
                in.close();
                paletteImage.getHeight();
            }
            catch (Exception e) {
                e.printStackTrace();
                calculatingMap.set(false);
                return;
            }
            MapUtil.convertTo12pxTexture(worldImage, paletteImage);
            MapUtil.writeOutputFile(worldImage, false);
            doneOverworldTexture = true;
            calculatingMap.set(false);
            return;
        }
        MapUtil.writeOutputFile(biomeMapImage, true);
        calculatingMap.set(false);
    }

    private static void convertTo12pxTexture(BufferedImage overworldImage, BufferedImage paletteImage) {
        TreeMap<Integer, Integer> mapColPos = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> mapColPosB = new TreeMap<Integer, Integer>();
        int count = 0;
        for (int x = 0; x < biomeMapSizeX; x += 4) {
            for (int z = 0; z < biomeMapSizeZ; z += 4) {
                int r = 0;
                int g = 0;
                int b = 0;
                for (int xx = 0; xx < 4; ++xx) {
                    for (int zz = 0; zz < 4; ++zz) {
                        int col = biomeMapImage.getRGB(xx + x, zz + z);
                        r += col >> 16;
                        g += col >> 8 & 0xFF;
                        b += col & 0xFF;
                    }
                }
                while (mapColPos.containsKey(g - b)) {
                    ++g;
                }
                mapColPos.put(g - b, count);
                if (x < biomeMapSizeZ) {
                    int col = paletteImage.getRGB(x + 1, z + 1);
                    r = col >> 16;
                    g = col >> 8 & 0xFF;
                    b = col & 0xFF;
                    while (mapColPosB.containsKey(g - b)) {
                        ++g;
                    }
                    mapColPosB.put(g - b, col);
                }
                ++count;
            }
        }
        count = 0;
        int newCol = 0;
        Iterator it = mapColPosB.keySet().iterator();
        Iterator itt = mapColPos.keySet().iterator();
        int modulus = biomeMapSizeZ / 4;
        int mod2 = biomeMapSizeX / biomeMapSizeZ;
        for (int x = 0; x < biomeMapSizeX / 4; ++x) {
            for (int z = 0; z < modulus; ++z) {
                if (count % mod2 == 0) {
                    newCol = (Integer)mapColPosB.get(it.next());
                }
                int position = (Integer)mapColPos.get(itt.next());
                int xx = position / modulus;
                int zz = position % modulus;
                for (int xxx = 0; xxx < 4; ++xxx) {
                    for (int zzz = 0; zzz < 4; ++zzz) {
                        overworldImage.setRGB(xx * 4 + xxx, zz * 4 + zzz, newCol);
                    }
                }
                ++count;
            }
        }
    }

    public static BufferedImage readImage(Object source) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(source);
        ImageReader reader = ImageIO.getImageReaders(stream).next();
        reader.setInput(stream);
        ImageReadParam param = reader.getDefaultReadParam();
        ImageTypeSpecifier typeToUse = null;
        Iterator<ImageTypeSpecifier> i = reader.getImageTypes(0);
        while (i.hasNext()) {
            ImageTypeSpecifier type = i.next();
            if (!type.getColorModel().getColorSpace().isCS_sRGB()) continue;
            typeToUse = type;
        }
        if (typeToUse != null) {
            param.setDestinationType(typeToUse);
        }
        BufferedImage b = reader.read(0, param);
        reader.dispose();
        stream.close();
        return b;
    }

    private static void writeOutputFile(BufferedImage image, boolean flag) {
        try {
            if (!biomeMapFile.exists() || biomeMapFile.canWrite() && biomeMapFile.canRead()) {
                FileImageOutputStream outputStream = new FileImageOutputStream(biomeMapFile);
                GalacticraftCore.jpgWriter.setOutput(outputStream);
                GalacticraftCore.jpgWriter.write(null, new IIOImage(image, null, null), GalacticraftCore.writeParam);
                outputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (flag) {
            try {
                byte[] bytes = FileUtils.readFileToByteArray((File)biomeMapFile);
                GalacticraftCore.packetPipeline.sendToAll(new PacketSimple(PacketSimple.EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{bytes}));
            }
            catch (Exception ex) {
                System.err.println("Error sending overworld image to player.");
                ex.printStackTrace();
            }
        }
    }

    public static void BiomeMapNextTick() {
        MapUtil.initialise(biomeMapWorld);
        for (int j = 24; j > 0; --j) {
            if (!MapUtil.BiomeMapOneTick()) continue;
            MapUtil.doneBiomeMap();
            return;
        }
    }

    public static boolean BiomeMapOneTick() {
        int imagefactor;
        int multifactor = biomeMapFactor / 16;
        if (multifactor < 1) {
            multifactor = 1;
        }
        if ((imagefactor = 16 / biomeMapFactor) < 1) {
            imagefactor = 1;
        }
        MapUtil.biomeMapOneChunk(biomeMapCx + biomeMapx0, biomeMapCz + biomeMapz0, ix, iz, biomeMapFactor);
        biomeMapz0 += multifactor;
        if ((iz += imagefactor) > biomeMapSizeZ - imagefactor) {
            iz = 0;
            if (ConfigManagerCore.enableDebug) {
                System.out.println("Finished map column " + ix);
            }
            ix += imagefactor;
            biomeMapz0 = biomeMapz00;
            if ((biomeMapx0 += multifactor) > -biomeMapz00 * 4) {
                biomeMapx0 += biomeMapz00 * 8;
            }
            return ix > biomeMapSizeX - imagefactor;
        }
        return false;
    }

    private static void biomeMapOneChunk(int x0, int z0, int ix, int iz, int factor) {
        BiomeGenBase[] biomesGrid = biomeMapWCM.func_76931_a(null, x0 << 4, z0 << 4, 16, 16, false);
        if (biomesGrid == null) {
            return;
        }
        MapUtil.getHeightMap(x0, z0);
        int limit = Math.min(factor, 16);
        int halfFactor = limit * limit / 2;
        ArrayList<Integer> cols = new ArrayList<Integer>();
        int[] count = new int[limit * limit];
        for (int x = 0; x < 16; x += factor) {
            int izstore = iz;
            for (int z = 0; z < 16; z += factor) {
                cols.clear();
                for (int j = 0; j < count.length; ++j) {
                    count[j] = 0;
                }
                int maxcount = 0;
                int maxindex = -1;
                int biome = -1;
                int lastcol = -1;
                int idx = 0;
                int avgHeight = 0;
                int divisor = 0;
                block3: for (int xx = 0; xx < limit; ++xx) {
                    int hidx = (xx + x << 4) + z;
                    for (int zz = 0; zz < limit; ++zz) {
                        int height = heights[hidx + zz];
                        avgHeight += height;
                        ++divisor;
                        biome = height < 63 ? 24 : biomesGrid[xx + x + (zz + z << 4)].field_76756_M;
                        if (biome != lastcol) {
                            idx = cols.indexOf(biome);
                            if (idx == -1) {
                                idx = cols.size();
                                cols.add(biome);
                            }
                            lastcol = biome;
                        }
                        int n = idx;
                        count[n] = count[n] + 1;
                        if (count[idx] <= maxcount) continue;
                        maxcount = count[idx];
                        maxindex = idx;
                        if (maxcount > halfFactor) break block3;
                    }
                }
                biomeMapImage.setRGB(ix, iz, MapUtil.convertBiomeColour((Integer)cols.get(maxindex), avgHeight / divisor));
                ++iz;
            }
            iz = izstore;
            ++ix;
        }
    }

    public static int convertBiomeColour(int in, int height) {
        BlockVec3 bv;
        int s = biomeColours.size();
        if (in >= 128 && in < 128 + s) {
            in -= 128;
        }
        int rv = in >= s ? BiomeGenBase.func_150568_d((int)in).field_76790_z : ((bv = biomeColours.get(in)) == null ? BiomeGenBase.func_150568_d((int)in).field_76790_z : (bv.z > 0 && rand.nextInt(100) < bv.z ? bv.y : bv.x));
        if (height < 63) {
            return rv;
        }
        float factor = ((float)height - 68.0f) / 194.0f;
        return ColorUtil.lighten(rv, factor);
    }

    private static void setupColours() {
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(13946264, Material.field_151570_A.func_151565_r().field_76291_p, 3));
        biomeColours.add(new BlockVec3(5072204, Material.field_151576_e.func_151565_r().field_76291_p, 5));
        biomeColours.add(new BlockVec3(3962145, 4813878, 65));
        biomeColours.add(new BlockVec3(6454881, 1518103, 18));
        biomeColours.add(new BlockVec3(3355675, 1118985, 25));
        biomeColours.add(new BlockVec3(4813878, 0, 0));
        biomeColours.add(new BlockVec3(0, 0, 0));
        biomeColours.add(new BlockVec3(0, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151588_w.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151588_w.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, Material.field_151588_w.func_151565_r().field_76291_p, 5));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, Material.field_151578_c.func_151565_r().field_76291_p, 10));
        biomeColours.add(new BlockVec3(6510175, 8131604, 10));
        biomeColours.add(new BlockVec3(0x6A6066, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151595_p.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(13946264, 0, 0));
        biomeColours.add(new BlockVec3(3962145, 4813878, 40));
        biomeColours.add(new BlockVec3(6454881, 1518103, 14));
        biomeColours.add(new BlockVec3(5072204, 4813878, 50));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(1534979, 1000706, 25));
        biomeColours.add(new BlockVec3(Material.field_151586_h.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151576_e.func_151565_r().field_76291_p, 0, 0));
        biomeColours.add(new BlockVec3(Material.field_151595_p.func_151565_r().field_76291_p, Material.field_151597_y.func_151565_r().field_76291_p, 75));
        biomeColours.add(new BlockVec3(5335862, 4813878, 65));
        biomeColours.add(new BlockVec3(5335862, 4813878, 55));
        biomeColours.add(new BlockVec3(4093987, 925192, 70));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 1518103, 12));
        biomeColours.add(new BlockVec3(Material.field_151597_y.func_151565_r().field_76291_p, 1518103, 12));
        biomeColours.add(new BlockVec3(1518103, 7228981, 12));
        biomeColours.add(new BlockVec3(1518103, 7228981, 12));
        biomeColours.add(new BlockVec3(8092024, 4813878, 10));
        biomeColours.add(new BlockVec3(5657897, 2499332, 20));
        biomeColours.add(new BlockVec3(5657897, 2499332, 14));
        biomeColours.add(new BlockVec3(10506783, 7417635, 14));
        biomeColours.add(new BlockVec3(10506783, 7417635, 17));
        biomeColours.add(new BlockVec3(10506783, 7417635, 20));
    }

    public static void getHeightMap(int cx, int cz) {
        rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        int seaLevel = 63;
        BiomeGenBase[] biomesGrid = biomeMapWorld.func_72959_q().func_76937_a(null, cx * 4 - 2, cz * 4 - 2, 10, 10);
        MapUtil.func_147423_a(biomesGrid, cx * 4, 0, cz * 4);
        for (int xx = 0; xx < 4; ++xx) {
            int xa = xx * 5;
            int xb = (xx + 1) * 5;
            for (int zz = 0; zz < 4; ++zz) {
                int aa = (xa + zz) * 33;
                int ab = (xa + zz + 1) * 33;
                int ba = (xb + zz) * 33;
                int bb = (xb + zz + 1) * 33;
                for (int yy = 0; yy < 32; ++yy) {
                    double d0 = 0.125;
                    double d1 = heighttemp[aa + yy];
                    double d2 = heighttemp[ab + yy];
                    double d3 = heighttemp[ba + yy];
                    double d4 = heighttemp[bb + yy];
                    double d5 = (heighttemp[aa + yy + 1] - d1) * d0;
                    double d6 = (heighttemp[ab + yy + 1] - d2) * d0;
                    double d7 = (heighttemp[ba + yy + 1] - d3) * d0;
                    double d8 = (heighttemp[bb + yy + 1] - d4) * d0;
                    for (int y = 0; y < 8; ++y) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int truey = yy * 8 + y;
                        for (int x = 0; x < 4; ++x) {
                            int idx = x + xx * 4 << 4 | zz * 4;
                            double d16 = (d11 - d10) * 0.25;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                d15 += d16;
                                if (!(d > 0.0)) continue;
                                MapUtil.heights[idx + z] = truey;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private static void initialise(World world) {
        rand = new Random(world.func_72905_C());
        field_147431_j = new NoiseGeneratorOctaves(rand, 16);
        field_147432_k = new NoiseGeneratorOctaves(rand, 16);
        field_147429_l = new NoiseGeneratorOctaves(rand, 8);
        field_147430_m = new NoiseGeneratorPerlin(rand, 4);
        noiseGen5 = new NoiseGeneratorOctaves(rand, 10);
        noiseGen6 = new NoiseGeneratorOctaves(rand, 16);
    }

    private static void func_147423_a(BiomeGenBase[] biomesGrid, int p_147423_1_, int p_147423_2_, int p_147423_3_) {
        double d0 = 684.412;
        double d1 = 684.412;
        double d2 = 512.0;
        double d3 = 512.0;
        field_147426_g = noiseGen6.func_76305_a(field_147426_g, p_147423_1_, p_147423_3_, 5, 5, 200.0, 200.0, 0.5);
        field_147427_d = field_147429_l.func_76304_a(field_147427_d, p_147423_1_, p_147423_2_, p_147423_3_, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        field_147428_e = field_147431_j.func_76304_a(field_147428_e, p_147423_1_, p_147423_2_, p_147423_3_, 5, 33, 5, 684.412, 684.412, 684.412);
        field_147425_f = field_147432_k.func_76304_a(field_147425_f, p_147423_1_, p_147423_2_, p_147423_3_, 5, 33, 5, 684.412, 684.412, 684.412);
        boolean flag1 = false;
        boolean flag = false;
        int l = 0;
        int i1 = 0;
        double d4 = 8.5;
        for (int xx = 0; xx < 5; ++xx) {
            for (int zz = 0; zz < 5; ++zz) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = biomesGrid[xx + 2 + (zz + 2) * 10];
                for (int x = -b0; x <= b0; ++x) {
                    for (int z = -b0; z <= b0; ++z) {
                        BiomeGenBase biomegenbase1 = biomesGrid[xx + x + 2 + (zz + z + 2) * 10];
                        float f3 = biomegenbase1.field_76748_D;
                        float f4 = biomegenbase1.field_76749_E;
                        if (field_147435_p == WorldType.field_151360_e && f3 > 0.0f) {
                            f3 = 1.0f + f3 * 2.0f;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = parabolicField[x + 2 + (z + 2) * 5] / (f3 + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = field_147426_g[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = field_147428_e[l] / 512.0;
                    double d8 = field_147425_f[l] / 512.0;
                    double d9 = (field_147427_d[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    MapUtil.heighttemp[l] = d10;
                    ++l;
                }
            }
        }
    }

    static {
        biomeColours = new ArrayList(40);
        rand = new Random();
        parabolicField = new float[25];
        heights = new int[256];
        heighttemp = new double[825];
        MapUtil.setupColours();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                MapUtil.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        field_147435_p = WorldType.field_77137_b;
    }
}

