/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

class AirLockProtocol {
    private ArrayList<TileEntityAirLock> adjacentAirLocks = new ArrayList();
    private final World worldObj;
    private final TileEntity head;
    private final int maxLoops;
    private int airLocksVerticalMin = 0;
    private int airLocksVerticalMax = 0;
    private int airLocksHorizontalMin = 0;
    private int airLocksHorizontalMax = 0;
    private boolean horizontal;
    public int minX = 6000000;
    public int maxX = -6000000;
    public int minY = 6000000;
    public int maxY = -6000000;
    public int minZ = 6000000;
    public int maxZ = -6000000;

    public AirLockProtocol(TileEntity head) {
        this.worldObj = head.func_145831_w();
        this.head = head;
        this.maxLoops = 26;
    }

    public void loopThrough(TileEntity tile2, int loops) {
        if (loops > 0) {
            for (int y = -1; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        TileEntity tile;
                        if (x == 0 && y == 0 && z == 0 || tile2.field_145851_c + x != this.head.field_145851_c && tile2.field_145849_e + z != this.head.field_145849_e || !((tile = this.worldObj.func_147438_o(tile2.field_145851_c + x, tile2.field_145848_d + y, tile2.field_145849_e + z)) instanceof TileEntityAirLock) || this.adjacentAirLocks.contains(tile)) continue;
                        this.adjacentAirLocks.add((TileEntityAirLock)tile);
                        this.loopThrough(tile, loops - 1);
                    }
                }
            }
        }
    }

    public void loopThroughHorizontal(TileEntity tile2, int loops) {
        if (loops > 0) {
            for (int y = -1; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        TileEntity tile;
                        if (x == 0 && y == 0 && z == 0 || tile2.field_145848_d + y != this.head.field_145848_d || !((tile = this.worldObj.func_147438_o(tile2.field_145851_c + x, tile2.field_145848_d + y, tile2.field_145849_e + z)) instanceof TileEntityAirLock) || this.adjacentAirLocks.contains(tile)) continue;
                        this.adjacentAirLocks.add((TileEntityAirLock)tile);
                        this.loopThroughHorizontal(tile, loops - 1);
                    }
                }
            }
        }
    }

    @Deprecated
    public ArrayList<TileEntityAirLock> calculate() {
        return this.calculate(false);
    }

    public ArrayList<TileEntityAirLock> calculate(boolean horizontal) {
        TileEntity tileAt;
        int y;
        if (this.worldObj.field_72995_K) {
            return null;
        }
        this.adjacentAirLocks = new ArrayList();
        this.horizontal = horizontal;
        if (horizontal) {
            this.loopThroughHorizontal(this.head, this.maxLoops);
        } else {
            this.loopThrough(this.head, this.maxLoops);
        }
        for (TileEntityAirLock airLock : this.adjacentAirLocks) {
            if (airLock.field_145851_c < this.minX) {
                this.minX = airLock.field_145851_c;
            }
            if (airLock.field_145851_c > this.maxX) {
                this.maxX = airLock.field_145851_c;
            }
            if (airLock.field_145848_d < this.minY) {
                this.minY = airLock.field_145848_d;
            }
            if (airLock.field_145848_d > this.maxY) {
                this.maxY = airLock.field_145848_d;
            }
            if (airLock.field_145849_e < this.minZ) {
                this.minZ = airLock.field_145849_e;
            }
            if (airLock.field_145849_e <= this.maxZ) continue;
            this.maxZ = airLock.field_145849_e;
        }
        int count = this.maxX - this.minX + this.maxZ - this.minZ + this.maxY - this.minY;
        if (count > 24 || this.maxX - this.minX <= 1 && this.maxZ - this.minZ <= 1 || !horizontal && this.maxY - this.minY <= 1) {
            return null;
        }
        if (horizontal && (this.maxX - this.minX <= 1 || this.maxZ - this.minZ <= 1)) {
            return null;
        }
        this.airLocksVerticalMin = 0;
        this.airLocksVerticalMax = 0;
        this.airLocksHorizontalMin = 0;
        this.airLocksHorizontalMax = 0;
        for (y = this.minY; y <= this.maxY; ++y) {
            tileAt = this.worldObj.func_147438_o(this.minX, y, this.minZ);
            if (!(tileAt instanceof TileEntityAirLock)) continue;
            ++this.airLocksVerticalMin;
        }
        for (y = this.minY; y <= this.maxY; ++y) {
            tileAt = this.worldObj.func_147438_o(this.maxX, y, this.maxZ);
            if (!(tileAt instanceof TileEntityAirLock)) continue;
            ++this.airLocksVerticalMax;
        }
        if (this.minX != this.maxX) {
            int x;
            for (x = this.minX; x <= this.maxX; ++x) {
                tileAt = this.worldObj.func_147438_o(x, this.maxY, this.maxZ);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMax;
            }
            for (x = this.minX; x <= this.maxX; ++x) {
                tileAt = this.worldObj.func_147438_o(x, this.minY, this.maxZ);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMin;
            }
        } else if (this.minZ != this.maxZ) {
            int z;
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = this.worldObj.func_147438_o(this.maxX, this.maxY, z);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMax;
            }
            for (z = this.minZ; z <= this.maxZ; ++z) {
                tileAt = this.worldObj.func_147438_o(this.maxX, this.minY, z);
                if (!(tileAt instanceof TileEntityAirLock)) continue;
                ++this.airLocksHorizontalMin;
            }
        }
        if (this.airLocksHorizontalMax == 0 || this.airLocksHorizontalMin == 0 || !this.horizontal && (this.airLocksVerticalMin == 0 || this.airLocksVerticalMax == 0) || this.airLocksHorizontalMax != this.airLocksHorizontalMin || this.airLocksVerticalMax != this.airLocksVerticalMin) {
            return null;
        }
        return this.adjacentAirLocks;
    }
}

