/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import cpw.mods.fml.client.FMLClientHandler;
import java.nio.FloatBuffer;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldProvider;
import org.lwjgl.opengl.GL11;

public class DrawGameScreen
extends IScreenManager {
    private TextureManager renderEngine;
    private static FloatBuffer colorBuffer = GLAllocation.func_74529_h((int)16);
    private float tickDrawn;
    public boolean initialise;
    public boolean initialiseLast;
    private boolean readyToInitialise;
    private int tileCount;
    private int callCount;
    private float scaleX;
    private float scaleZ;
    public TileEntity driver;
    public Class telemetryLastClass;
    public String telemetryLastName;
    public Entity telemetryLastEntity;
    public Render telemetryLastRender;

    public DrawGameScreen(float scaleXparam, float scaleZparam, TileEntity te) {
        this.renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
        this.tickDrawn = -1.0f;
        this.initialise = true;
        this.initialiseLast = false;
        this.readyToInitialise = false;
        this.tileCount = 0;
        this.callCount = 0;
        this.scaleX = scaleXparam;
        this.scaleZ = scaleZparam;
        this.driver = te;
    }

    public void drawScreen(int type, float ticks, boolean cornerBlock) {
        if (type >= GalacticraftRegistry.getMaxScreenTypes()) {
            System.out.println("Wrong gamescreen type detected - this is a bug." + type);
            return;
        }
        if (cornerBlock) {
            this.doDraw(type, ticks);
            this.initialise = true;
            this.initialiseLast = false;
            return;
        }
        if (this.initialise) {
            if (!this.initialiseLast) {
                this.tickDrawn = ticks;
                this.readyToInitialise = false;
                this.initialiseLast = true;
                return;
            }
            if (!this.readyToInitialise && ticks == this.tickDrawn) {
                return;
            }
            if (!this.readyToInitialise) {
                this.readyToInitialise = true;
                this.tickDrawn = ticks;
                this.tileCount = 1;
                return;
            }
            if (ticks == this.tickDrawn) {
                ++this.tileCount;
                return;
            }
            this.initialise = false;
            this.initialiseLast = false;
            this.readyToInitialise = false;
        }
        if (++this.callCount < this.tileCount) {
            if (this.callCount == 1 || this.tickDrawn == ticks) {
                this.tickDrawn = ticks;
                return;
            }
            this.initialise = true;
        }
        if (this.callCount == this.tileCount) {
            this.callCount = 0;
            if (this.tileCount > 1 && ticks != this.tickDrawn) {
                this.initialise = true;
            }
        }
        this.tickDrawn = ticks;
        this.doDraw(type, ticks);
    }

    private void doDraw(int type, float ticks) {
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        if (type > 0) {
            GL11.glDisable((int)2896);
        }
        GalacticraftRegistry.getGameScreen(type).render(type, ticks, this.scaleX, this.scaleZ, this);
        if (type > 0) {
            GL11.glEnable((int)2896);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
    }

    @Override
    public WorldProvider getWorldProvider() {
        if (this.driver != null) {
            return this.driver.func_145831_w().field_73011_w;
        }
        return null;
    }
}

